/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.client.render.entity;

import com.google.common.collect.ImmutableMap;
import foundationgames.enhancedblockentities.client.model.ModelIdentifiers;
import foundationgames.enhancedblockentities.client.render.BlockEntityRendererOverride;
import foundationgames.enhancedblockentities.util.EBEUtil;
import foundationgames.enhancedblockentities.util.duck.BakedModelManagerAccess;
import java.util.Map;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_8172;
import net.minecraft.class_8173;
import net.minecraft.class_827;
import net.minecraft.class_8526;

public class DecoratedPotBlockEntityRendererOverride
extends BlockEntityRendererOverride {
    public static final float WOBBLE_STRENGTH = 0.015625f;
    private class_1087 baseModel = null;
    private Map<class_5321<String>, class_1087[]> potPatternModels = null;

    private void tryGetModels() {
        BakedModelManagerAccess models = (BakedModelManagerAccess)class_310.method_1551().method_1554();
        if (this.baseModel == null) {
            this.baseModel = models.enhanced_bes$getModel(ModelIdentifiers.DECORATED_POT_BASE);
        }
        if (this.potPatternModels == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            class_7923.field_42940.method_42021().forEach(k -> {
                class_2960[] patternModelIDs = ModelIdentifiers.POTTERY_PATTERNS.get(k);
                class_1087[] patternPerFaceModels = new class_1087[patternModelIDs.length];
                for (int i = 0; i < patternModelIDs.length; ++i) {
                    patternPerFaceModels[i] = models.enhanced_bes$getModel(patternModelIDs[i]);
                }
                builder.put(k, (Object)patternPerFaceModels);
            });
            this.potPatternModels = builder.build();
        }
    }

    @Override
    public void render(class_827<class_2586> renderer, class_2586 blockEntity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        this.tryGetModels();
        if (blockEntity instanceof class_8172) {
            float tilt;
            class_8172 pot = (class_8172)blockEntity;
            matrices.method_22903();
            class_2350 dir = pot.method_49204();
            matrices.method_46416(0.5f, 0.0f, 0.5f);
            matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f - dir.method_10144()));
            matrices.method_46416(-0.5f, 0.0f, -0.5f);
            class_8172.class_8837 wobbleType = pot.field_46662;
            if (wobbleType != null && pot.method_10997() != null && (tilt = ((float)(pot.method_10997().method_8510() - pot.field_46661) + tickDelta) / (float)wobbleType.field_46666) >= 0.0f && tilt <= 1.0f) {
                if (wobbleType == class_8172.class_8837.field_46664) {
                    float animPeriod = tilt * ((float)Math.PI * 2);
                    float tiltX = -1.5f * (class_3532.method_15362((float)animPeriod) + 0.5f) * class_3532.method_15374((float)(animPeriod * 0.5f));
                    matrices.method_49278(class_7833.field_40714.rotation(tiltX * 0.015625f), 0.5f, 0.0f, 0.5f);
                    float tiltZ = class_3532.method_15374((float)animPeriod);
                    matrices.method_49278(class_7833.field_40718.rotation(tiltZ * 0.015625f), 0.5f, 0.0f, 0.5f);
                } else {
                    float yaw = (1.0f - tilt) * class_3532.method_15374((float)(-tilt * 3.0f * (float)Math.PI)) * 0.125f;
                    matrices.method_49278(class_7833.field_40716.rotation(yaw), 0.5f, 0.0f, 0.5f);
                }
            }
            class_8526 sherds = pot.method_51511();
            EBEUtil.renderBakedModel(vertexConsumers, blockEntity.method_11010(), matrices, this.baseModel, light, overlay);
            EBEUtil.renderBakedModel(vertexConsumers, blockEntity.method_11010(), matrices, this.potPatternModels.get(sherds.comp_1487().map(class_8173::method_49206).orElse(class_8173.field_42793))[0], light, overlay);
            EBEUtil.renderBakedModel(vertexConsumers, blockEntity.method_11010(), matrices, this.potPatternModels.get(sherds.comp_1488().map(class_8173::method_49206).orElse(class_8173.field_42793))[1], light, overlay);
            EBEUtil.renderBakedModel(vertexConsumers, blockEntity.method_11010(), matrices, this.potPatternModels.get(sherds.comp_1489().map(class_8173::method_49206).orElse(class_8173.field_42793))[2], light, overlay);
            EBEUtil.renderBakedModel(vertexConsumers, blockEntity.method_11010(), matrices, this.potPatternModels.get(sherds.comp_1490().map(class_8173::method_49206).orElse(class_8173.field_42793))[3], light, overlay);
            matrices.method_22909();
        }
    }

    @Override
    public void onModelsReload() {
        this.baseModel = null;
        this.potPatternModels = null;
    }
}

