/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.mixins.chunk.loading.portals;

import com.ibm.asyncutil.iteration.AsyncIterator;
import com.ishland.vmp.common.chunk.loading.IEntityPortalInterface;
import com.ishland.vmp.common.chunk.loading.IPOIAsyncPreload;
import com.ishland.vmp.common.chunk.loading.async_chunks_on_player_login.AsyncChunkLoadUtil;
import com.ishland.vmp.common.config.Config;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2424;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_2791;
import net.minecraft.class_2874;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_5459;
import net.minecraft.class_7477;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public abstract class MixinEntity
implements IEntityPortalInterface {
    @Unique
    private static final CompletableFuture<class_5454> TARGET_COMPLETED_FUTURE = CompletableFuture.completedFuture(null);
    @Shadow
    protected boolean field_5963;
    @Shadow
    public class_1937 field_6002;
    @Shadow
    @Final
    private static Logger field_5955;
    @Shadow
    protected int field_5972;
    @Shadow
    protected class_2338 field_5991;
    @Unique
    private CompletableFuture<class_5454> vmp$locatePortalFuture;
    @Unique
    private CompletableFuture<class_5454> vmp$lastLocateFuture = TARGET_COMPLETED_FUTURE;
    @Unique
    private long vmp$locateIndex = 0L;

    @Shadow
    public abstract boolean method_5765();

    @Shadow
    public abstract double method_23317();

    @Shadow
    public abstract double method_23318();

    @Shadow
    public abstract double method_23321();

    @Shadow
    public abstract int method_5741();

    @Shadow
    @Nullable
    protected abstract class_5454 method_30329(class_3218 var1);

    @Shadow
    @Nullable
    public abstract class_1297 method_5731(class_3218 var1);

    @Shadow
    protected abstract class_243 method_30633(class_2350.class_2351 var1, class_5459.class_5460 var2);

    @Shadow
    public abstract class_4048 method_18377(class_4050 var1);

    @Shadow
    public abstract class_4050 method_18376();

    @Shadow
    public abstract class_243 method_18798();

    @Shadow
    public abstract float method_36454();

    @Shadow
    public abstract float method_36455();

    @Shadow
    public abstract boolean method_31481();

    @Shadow
    public abstract void method_18375();

    @Shadow
    public abstract class_1299<?> method_5864();

    @Inject(method={"tickPortal"}, at={@At(value="HEAD")})
    private void onTickNetherPortal(CallbackInfo ci) {
        if (this.field_6002.field_9236) {
            return;
        }
        if (this instanceof class_3222) {
            if (this.field_5963 && this.field_5972 >= this.method_5741() - 50) {
                if (this.vmp$locatePortalFuture == null && this.vmp$lastLocateFuture.isDone()) {
                    MixinEntity mixinEntity;
                    MinecraftServer minecraftServer = this.field_6002.method_8503();
                    class_5321 registryKey = this.field_6002.method_27983() == class_1937.field_25180 ? class_1937.field_25179 : class_1937.field_25180;
                    class_3218 destination = minecraftServer.method_3847(registryKey);
                    long currentLocateIndex = ++this.vmp$locateIndex;
                    long startTime = System.nanoTime();
                    if (Config.SHOW_ASYNC_LOADING_MESSAGES && (mixinEntity = this) instanceof class_3222) {
                        class_3222 player = (class_3222)mixinEntity;
                        player.method_7353((class_2561)class_2561.method_43470((String)"Locating portal destination..."), true);
                    }
                    this.vmp$locatePortalFuture = this.getTeleportTargetAtAsync(destination).thenComposeAsync(target -> {
                        if (target != null) {
                            return AsyncChunkLoadUtil.scheduleChunkLoad(destination, new class_1923(class_2338.method_49637((double)target.field_25879.field_1352, (double)target.field_25879.field_1351, (double)target.field_25879.field_1350))).thenApplyAsync(unused -> {
                                class_2338 blockPos = class_2338.method_49637((double)target.field_25879.field_1352, (double)target.field_25879.field_1351, (double)target.field_25879.field_1350);
                                destination.method_14178().method_17297(class_3230.field_19280, new class_1923(blockPos), 3, (Object)blockPos);
                                return target;
                            }, (Executor)destination.method_8503());
                        }
                        return CompletableFuture.completedFuture(null);
                    }, (Executor)destination.method_8503()).whenCompleteAsync((target, throwable) -> {
                        if (currentLocateIndex != this.vmp$locateIndex) {
                            return;
                        }
                        if (throwable != null) {
                            MixinEntity patt0$temp;
                            field_5955.error("Error occurred for entity {} while locating portal", (Object)this, throwable);
                            if (Config.SHOW_ASYNC_LOADING_MESSAGES && (patt0$temp = this) instanceof class_3222) {
                                class_3222 player = (class_3222)patt0$temp;
                                player.method_7353((class_2561)class_2561.method_43470((String)"Error occurred while locating portal"), true);
                            }
                        } else if (target != null) {
                            if (Config.SHOW_ASYNC_LOADING_MESSAGES) {
                                field_5955.info("Portal located for entity {} at {}", (Object)this, target);
                                class_2338 blockPos = class_2338.method_49637((double)target.field_25879.field_1352, (double)target.field_25879.field_1351, (double)target.field_25879.field_1350);
                                MixinEntity patt0$temp = this;
                                if (patt0$temp instanceof class_3222) {
                                    class_3222 player = (class_3222)patt0$temp;
                                    player.method_7353((class_2561)class_2561.method_43470((String)"Portal located after %.1fms, waiting for portal teleportation...".formatted((double)(System.nanoTime() - startTime) / 1000000.0)), true);
                                }
                            }
                        } else if (Config.SHOW_ASYNC_LOADING_MESSAGES) {
                            field_5955.info("Portal not located for entity {} at {}", (Object)this, target);
                            MixinEntity patt0$temp = this;
                            if (patt0$temp instanceof class_3222) {
                                class_3222 player = (class_3222)patt0$temp;
                                player.method_7353((class_2561)class_2561.method_43470((String)"Portal not located, will spawn a new portal later"), true);
                            }
                        }
                    }, (Executor)destination.method_8503()).toCompletableFuture();
                    this.vmp$lastLocateFuture = this.vmp$locatePortalFuture;
                }
            } else if (this.vmp$locatePortalFuture != null) {
                MixinEntity mixinEntity;
                boolean done = this.vmp$locatePortalFuture.isDone();
                this.vmp$locatePortalFuture.cancel(false);
                this.vmp$locatePortalFuture = null;
                ++this.vmp$locateIndex;
                if (!done && Config.SHOW_ASYNC_LOADING_MESSAGES && (mixinEntity = this) instanceof class_3222) {
                    class_3222 player = (class_3222)mixinEntity;
                    player.method_7353((class_2561)class_2561.method_43470((String)"Portal location cancelled"), true);
                }
            }
        }
    }

    @Redirect(method={"tickPortal"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;getMaxNetherPortalTime()I"))
    private int redirectMaxPortalTime(class_1297 instance) {
        if (instance instanceof class_3222) {
            return this.vmp$locatePortalFuture != null && this.vmp$locatePortalFuture.isDone() ? instance.method_5741() : Integer.MAX_VALUE;
        }
        return instance.method_5741();
    }

    @Inject(method={"getTeleportTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void beforeGetTeleportTarget(class_3218 destination, CallbackInfoReturnable<class_5454> cir) {
        class_5454 value;
        if (this.vmp$locatePortalFuture != null && this.vmp$locatePortalFuture.isDone() && !this.vmp$locatePortalFuture.isCompletedExceptionally() && (value = this.vmp$locatePortalFuture.join()) != null) {
            cir.setReturnValue((Object)value);
        }
    }

    @Unique
    public CompletionStage<class_5454> getTeleportTargetAtAsync(class_3218 destination) {
        boolean bl2;
        boolean bl = this.field_6002.method_27983() == class_1937.field_25181 && destination.method_27983() == class_1937.field_25179;
        boolean bl3 = bl2 = destination.method_27983() == class_1937.field_25181;
        if (!bl && !bl2) {
            boolean bl32;
            boolean bl4 = bl32 = destination.method_27983() == class_1937.field_25180;
            if (this.field_6002.method_27983() != class_1937.field_25180 && !bl32) {
                return CompletableFuture.completedFuture(null);
            }
            class_2784 worldBorder = destination.method_8621();
            double d = class_2874.method_31109((class_2874)this.field_6002.method_8597(), (class_2874)destination.method_8597());
            class_2338 destPos = worldBorder.method_39538(this.method_23317() * d, this.method_23318(), this.method_23321() * d);
            return this.getPortalRectAtAsync(destination, destPos, bl32, worldBorder).thenComposeAsync(optional -> optional.map(rect -> AsyncChunkLoadUtil.scheduleChunkLoad(destination, new class_1923(this.field_5991)).thenComposeAsync(unused -> {
                class_243 vec3d;
                class_2350.class_2351 axis;
                class_2680 blockState = this.field_6002.method_8320(this.field_5991);
                if (blockState.method_28498((class_2769)class_2741.field_12529)) {
                    axis = (class_2350.class_2351)blockState.method_11654((class_2769)class_2741.field_12529);
                    class_5459.class_5460 rectangle = class_5459.method_30574((class_2338)this.field_5991, (class_2350.class_2351)axis, (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, pos -> this.field_6002.method_8320(pos) == blockState);
                    vec3d = this.method_30633(axis, rectangle);
                } else {
                    axis = class_2350.class_2351.field_11048;
                    vec3d = new class_243(0.5, 0.0, 0.0);
                }
                return AsyncChunkLoadUtil.scheduleChunkLoad(destination, new class_1923(rect.field_25936)).thenApplyAsync(unused1 -> class_2424.method_30484((class_3218)destination, (class_5459.class_5460)rect, (class_2350.class_2351)axis, (class_243)vec3d, (class_1297)((class_1297)this), (class_243)this.method_18798(), (float)this.method_36454(), (float)this.method_36455()), (Executor)destination.method_8503());
            }, (Executor)destination.method_8503())).orElse(CompletableFuture.completedFuture(null)), (Executor)destination.method_8503());
        }
        class_2338 blockPos = bl2 ? class_3218.field_25144 : destination.method_8598(class_2902.class_2903.field_13203, destination.method_43126());
        return CompletableFuture.completedFuture(new class_5454(new class_243((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264(), (double)blockPos.method_10260() + 0.5), this.method_18798(), this.method_36454(), this.method_36455()));
    }

    @Unique
    public CompletionStage<Optional<class_5459.class_5460>> getPortalRectAtAsync(class_3218 destination, class_2338 destPos, boolean destIsNether, class_2784 worldBorder) {
        class_4153 pointOfInterestStorage = destination.method_19494();
        int i = destIsNether ? 16 : 128;
        return ((IPOIAsyncPreload)pointOfInterestStorage).preloadChunksAtAsync(destination, destPos, i).thenComposeAsync(unused -> {
            Iterator<class_4156> iterator = pointOfInterestStorage.method_22383(registryEntry -> registryEntry.method_40225(class_7477.field_39295), destPos, i, class_4153.class_4155.field_18489).filter(poi -> worldBorder.method_11952(poi.method_19141())).sorted(Comparator.comparingDouble(poi -> poi.method_19141().method_10262((class_2382)destPos)).thenComparingInt(poi -> poi.method_19141().method_10264())).toList().iterator();
            return AsyncIterator.fromIterator(iterator).filterCompose(poi -> AsyncChunkLoadUtil.scheduleChunkLoadWithRadius(destination, new class_1923(poi.method_19141()), 0).thenApplyAsync(either -> ((class_2791)either.method_57132(RuntimeException::new)).method_8320(poi.method_19141()).method_28498((class_2769)class_2741.field_12529) ? Optional.of(poi) : Optional.empty(), (Executor)destination.method_8503())).take(1L).thenComposeAsync(poi -> {
                class_2338 blockPos = poi.method_19141();
                return AsyncChunkLoadUtil.scheduleChunkLoad(destination, new class_1923(blockPos)).thenApplyAsync(unused1 -> {
                    destination.method_14178().method_17297(class_3230.field_19280, new class_1923(blockPos), 3, (Object)blockPos);
                    class_2680 blockState = destination.method_8320(blockPos);
                    return class_5459.method_30574((class_2338)blockPos, (class_2350.class_2351)((class_2350.class_2351)blockState.method_11654((class_2769)class_2741.field_12529)), (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, posx -> destination.method_8320(posx) == blockState);
                }, (Executor)destination.method_8503());
            }, (Executor)destination.method_8503()).collect(Collectors.toCollection(() -> new ReferenceArrayList(1))).thenApply(list -> list.isEmpty() ? Optional.empty() : Optional.of((class_5459.class_5460)list.get(0)));
        }, (Executor)destination.method_8503());
    }
}

