/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.render.frapi;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import me.jellysquid.mods.sodium.client.compat.ccl.SinkingVertexBuilder;
import me.jellysquid.mods.sodium.client.model.light.data.LightDataAccess;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import org.embeddedt.embeddium.render.frapi.FRAPIRenderHandler;
import org.embeddedt.embeddium.render.type.RenderTypeExtended;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public class IndigoBlockRenderContext
extends net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderContext
implements FRAPIRenderHandler {
    private final SinkingVertexBuilder[] vertexBuilderMap = new SinkingVertexBuilder[class_1921.method_22720().size()];
    private BlockRenderContext currentContext;
    private final BlockOcclusionCache occlusionCache;
    private final LightDataAccess lightDataAccess;
    private int cullChecked;
    private int cullValue;
    private static final MethodHandle FABRIC_RENDER_HANDLE;
    private static final MethodHandle FORGIFIED_RENDER_HANDLE;

    public IndigoBlockRenderContext(BlockOcclusionCache occlusionCache, LightDataAccess lightDataAccess) {
        this.occlusionCache = occlusionCache;
        this.lightDataAccess = lightDataAccess;
    }

    protected AoCalculator createAoCalc(BlockRenderInfo blockInfo) {
        return new AoCalculator(blockInfo){

            public int light(class_2338 pos, class_2680 state) {
                int data = IndigoBlockRenderContext.this.lightDataAccess.get(pos);
                return LightDataAccess.getLightmap(data);
            }

            public float ao(class_2338 pos, class_2680 state) {
                return LightDataAccess.unpackAO(IndigoBlockRenderContext.this.lightDataAccess.get(pos));
            }
        };
    }

    public boolean isFaceCulled(@Nullable class_2350 face) {
        boolean flag;
        if (face == null) {
            return false;
        }
        int fM = 1 << face.ordinal();
        if ((this.cullChecked & fM) != 0) {
            return (this.cullValue & fM) != 0;
        }
        BlockRenderContext ctx = this.currentContext;
        boolean bl = flag = !this.occlusionCache.shouldDrawSide(ctx.state(), (class_1922)ctx.localSlice(), ctx.pos(), face);
        if (flag) {
            this.cullValue |= fM;
        }
        this.cullChecked |= fM;
        return flag;
    }

    protected class_4588 getVertexConsumer(class_1921 layer) {
        int id = ((RenderTypeExtended)layer).embeddium$getChunkLayerId();
        if (id < 0) {
            throw new UnsupportedOperationException("Unsupported render type: " + String.valueOf(layer));
        }
        SinkingVertexBuilder builder = this.vertexBuilderMap[id];
        if (builder == null) {
            this.vertexBuilderMap[id] = builder = new SinkingVertexBuilder();
        }
        return builder;
    }

    @Override
    public void reset() {
        for (SinkingVertexBuilder builder : this.vertexBuilderMap) {
            if (builder == null) continue;
            builder.reset();
        }
        this.cullChecked = 0;
        this.cullValue = 0;
    }

    private RuntimeException processException(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new IllegalStateException("Unexpected throwable", e);
    }

    @Override
    public void renderEmbeddium(BlockRenderContext ctx, class_4587 mStack, class_5819 random) {
        this.currentContext = ctx;
        mStack.method_22903();
        try {
            if (FABRIC_RENDER_HANDLE != null) {
                FABRIC_RENDER_HANDLE.invokeExact(this, ctx.localSlice(), ctx.model(), ctx.state(), ctx.pos(), mStack, null, true, random, ctx.seed(), class_4608.field_21444);
            } else if (FORGIFIED_RENDER_HANDLE != null) {
                FORGIFIED_RENDER_HANDLE.invokeExact(this, ctx.localSlice(), ctx.model(), ctx.state(), ctx.pos(), mStack, null, true, random, ctx.seed(), class_4608.field_21444, ctx.modelData(), ctx.renderLayer());
            }
        }
        catch (Throwable e) {
            throw this.processException(e);
        }
        finally {
            mStack.method_22909();
            this.currentContext = null;
        }
    }

    @Override
    public void flush(ChunkBuildBuffers buffers, Vector3fc origin) {
        for (int i = 0; i < this.vertexBuilderMap.length; ++i) {
            SinkingVertexBuilder sinkingVertexBuilder = this.vertexBuilderMap[i];
            if (sinkingVertexBuilder == null || sinkingVertexBuilder.isEmpty()) continue;
            Material material = DefaultMaterials.forRenderLayer((class_1921)class_1921.method_22720().get(i));
            ChunkModelBuilder builder = buffers.get(material);
            sinkingVertexBuilder.flush(builder, material, origin);
        }
    }

    static {
        MethodHandle fabricHandle = null;
        Object forgeHandle = null;
        Throwable forgeException = null;
        ReflectiveOperationException fabricException = null;
        try {
            fabricHandle = MethodHandles.lookup().findVirtual(net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderContext.class, "render", MethodType.methodType(Void.TYPE, class_1920.class, class_1087.class, class_2680.class, class_2338.class, class_4587.class, class_4588.class, Boolean.TYPE, class_5819.class, Long.TYPE, Integer.TYPE));
        }
        catch (ReflectiveOperationException e) {
            fabricException = e;
        }
        if (fabricHandle == null && forgeHandle == null) {
            IllegalStateException ex = new IllegalStateException("Failed to find render method on BlockRenderContext.");
            if (fabricException != null) {
                ex.addSuppressed(fabricException);
            }
            if (forgeException != null) {
                ex.addSuppressed(forgeException);
            }
            throw ex;
        }
        FABRIC_RENDER_HANDLE = fabricHandle;
        FORGIFIED_RENDER_HANDLE = forgeHandle;
    }
}

