/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.gui.frame.tab;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.embeddedt.embeddium.gui.frame.tab.Tab;

public class TabHeaderWidget
extends FlatButtonWidget {
    private static final class_2960 FALLBACK_LOCATION = new class_2960("textures/misc/unknown_pack.png");
    private static final Set<String> erroredLogos = new HashSet<String>();
    private final class_2960 logoTexture;

    public static class_5250 getLabel(String modId) {
        return (switch (modId) {
            case "sspb" -> class_2561.method_43470((String)"SSPB");
            default -> Tab.idComponent(modId);
        }).method_27694(s -> s.method_30938(Boolean.valueOf(true)));
    }

    public TabHeaderWidget(Dim2i dim, String modId) {
        super(dim, (class_2561)TabHeaderWidget.getLabel(modId), () -> {});
        Optional logoFile = erroredLogos.contains(modId) ? Optional.empty() : FabricLoader.getInstance().getModContainer(modId).flatMap(c -> c.getMetadata().getIconPath(32).flatMap(arg_0 -> ((ModContainer)c).findPath(arg_0)));
        class_2960 texture = null;
        if (logoFile.isPresent()) {
            try (InputStream is = Files.newInputStream((Path)logoFile.get(), new OpenOption[0]);){
                if (is != null) {
                    class_1011 logo = class_1011.method_4309((InputStream)is);
                    if (logo.method_4307() != logo.method_4323()) {
                        logo.close();
                        throw new IOException("Logo " + String.valueOf(logoFile.get()) + " for " + modId + " is not square");
                    }
                    texture = new class_2960("embeddium", "logo/" + modId);
                    class_310.method_1551().method_1531().method_4616(texture, (class_1044)new class_1043(logo));
                }
            }
            catch (IOException e) {
                erroredLogos.add(modId);
                SodiumClientMod.logger().error("Exception reading logo for " + modId, (Throwable)e);
            }
        }
        this.logoTexture = texture;
    }

    @Override
    protected int getLeftAlignedTextOffset() {
        int n = super.getLeftAlignedTextOffset();
        Objects.requireNonNull(class_310.method_1551().field_1772);
        return n + 9;
    }

    @Override
    protected boolean isHovered(int mouseX, int mouseY) {
        return false;
    }

    @Override
    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_25394(drawContext, mouseX, mouseY, delta);
        class_2960 icon = Objects.requireNonNullElse(this.logoTexture, FALLBACK_LOCATION);
        Objects.requireNonNull(class_310.method_1551().field_1772);
        int fontHeight = 9;
        int imgY = this.dim.getCenterY() - fontHeight / 2;
        drawContext.method_25290(icon, this.dim.x() + 5, imgY, 0.0f, 0.0f, fontHeight, fontHeight, fontHeight, fontHeight);
    }
}

