/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.gui.frame.components;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_437;
import org.embeddedt.embeddium.gui.EmbeddiumVideoOptionsScreen;
import org.embeddedt.embeddium.util.StringUtils;

public class SearchTextFieldModel {
    boolean selecting;
    String text = "";
    int maxLength = 100;
    boolean visible = true;
    boolean editable = true;
    int firstCharacterIndex;
    int selectionStart;
    int selectionEnd;
    int lastCursorPosition = this.getCursor();
    Set<Option<?>> selectedOptions;
    final Set<Option<?>> allOptions;
    final Collection<OptionPage> pages;
    int innerWidth;
    EmbeddiumVideoOptionsScreen mainScreen;

    public SearchTextFieldModel(Collection<OptionPage> pages, EmbeddiumVideoOptionsScreen mainScreen) {
        this.pages = pages;
        this.allOptions = pages.stream().flatMap(p -> p.getOptions().stream()).collect(Collectors.toUnmodifiableSet());
        this.selectedOptions = this.allOptions;
        this.mainScreen = mainScreen;
    }

    int getMaxLength() {
        return this.maxLength;
    }

    public String getSelectedText() {
        int i = Math.min(this.selectionStart, this.selectionEnd);
        int j = Math.max(this.selectionStart, this.selectionEnd);
        return this.text.substring(i, j);
    }

    public void write(String text) {
        String string2;
        String string;
        int l;
        int i = Math.min(this.selectionStart, this.selectionEnd);
        int j = Math.max(this.selectionStart, this.selectionEnd);
        int k = this.maxLength - this.text.length() - (i - j);
        if (k < (l = (string = class_3544.method_57180((String)text)).length())) {
            string = string.substring(0, k);
            l = k;
        }
        if ((string2 = new StringBuilder(this.text).replace(i, j, string).toString()) != null) {
            this.text = string2;
            this.setSelectionStart(i + l);
            this.setSelectionEnd(this.selectionStart);
            this.onChanged(this.text);
        }
    }

    public Predicate<Option<?>> getOptionPredicate() {
        return this.selectedOptions == this.allOptions ? Predicates.alwaysTrue() : this.selectedOptions::contains;
    }

    private void onChanged(String newText) {
        this.selectedOptions = this.allOptions;
        if (this.editable && !newText.trim().isEmpty()) {
            List<Option> fuzzy = StringUtils.fuzzySearch(() -> this.pages.stream().flatMap(p -> p.getOptions().stream()).iterator(), newText, 2, o -> {
                Object name = o.getName().getString();
                Control patt0$temp = o.getControl();
                if (patt0$temp instanceof CyclingControl) {
                    CyclingControl cycler = (CyclingControl)patt0$temp;
                    name = (String)name + " " + Arrays.stream(cycler.getNames()).map(class_2561::getString).collect(Collectors.joining(" "));
                }
                return name;
            });
            this.selectedOptions = new HashSet<Option>(fuzzy);
        }
        class_310.method_1551().method_18858(() -> this.mainScreen.rebuildUI());
    }

    void erase(int offset) {
        if (class_437.method_25441()) {
            this.eraseWords(offset);
        } else {
            this.eraseCharacters(offset);
        }
    }

    public void eraseWords(int wordOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.write("");
            } else {
                this.eraseCharacters(this.getWordSkipPosition(wordOffset) - this.selectionStart);
            }
        }
    }

    public void eraseCharacters(int characterOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.write("");
            } else {
                String string;
                int k;
                int i = this.getCursorPosWithOffset(characterOffset);
                int j = Math.min(i, this.selectionStart);
                if (j != (k = Math.max(i, this.selectionStart)) && (string = new StringBuilder(this.text).delete(j, k).toString()) != null) {
                    this.text = string;
                    this.setCursor(j);
                    this.onChanged(this.text);
                }
            }
        }
    }

    public int getWordSkipPosition(int wordOffset) {
        return this.getWordSkipPosition(wordOffset, this.getCursor());
    }

    private int getWordSkipPosition(int wordOffset, int cursorPosition) {
        return this.getWordSkipPosition(wordOffset, cursorPosition, true);
    }

    private int getWordSkipPosition(int wordOffset, int cursorPosition, boolean skipOverSpaces) {
        int i = cursorPosition;
        boolean bl = wordOffset < 0;
        int j = Math.abs(wordOffset);
        for (int k = 0; k < j; ++k) {
            if (!bl) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipOverSpaces && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipOverSpaces && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public int getCursor() {
        return this.selectionStart;
    }

    public void setCursor(int cursor) {
        this.setSelectionStart(cursor);
        if (!this.selecting) {
            this.setSelectionEnd(this.selectionStart);
        }
    }

    public void moveCursor(int offset) {
        this.setCursor(this.getCursorPosWithOffset(offset));
    }

    private int getCursorPosWithOffset(int offset) {
        return class_156.method_27761((String)this.text, (int)this.selectionStart, (int)offset);
    }

    public void setSelectionStart(int cursor) {
        this.selectionStart = class_3532.method_15340((int)cursor, (int)0, (int)this.text.length());
    }

    public void setCursorToStart() {
        this.setCursor(0);
    }

    public void setCursorToEnd() {
        this.setCursor(this.text.length());
    }

    public void setSelectionEnd(int index) {
        int i = this.text.length();
        this.selectionEnd = class_3532.method_15340((int)index, (int)0, (int)i);
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (textRenderer != null) {
            if (this.firstCharacterIndex > i) {
                this.firstCharacterIndex = i;
            }
            int j = this.innerWidth;
            String string = textRenderer.method_27523(this.text.substring(this.firstCharacterIndex), j);
            int k = string.length() + this.firstCharacterIndex;
            if (this.selectionEnd == this.firstCharacterIndex) {
                this.firstCharacterIndex -= textRenderer.method_27524(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.firstCharacterIndex += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.firstCharacterIndex - this.selectionEnd;
            }
            this.firstCharacterIndex = class_3532.method_15340((int)this.firstCharacterIndex, (int)0, (int)i);
        }
    }
}

