/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.gui.frame;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.function.Predicate;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.apache.commons.lang3.Validate;
import org.embeddedt.embeddium.gui.frame.AbstractFrame;
import org.jetbrains.annotations.Nullable;

public class OptionPageFrame
extends AbstractFrame {
    protected final OptionPage page;
    private long lastTime = 0L;
    private ControlElement<?> lastHoveredElement = null;
    protected final Predicate<Option<?>> optionFilter;

    public OptionPageFrame(Dim2i dim, boolean renderOutline, OptionPage page, Predicate<Option<?>> optionFilter) {
        super(dim, renderOutline);
        this.page = page;
        this.optionFilter = optionFilter;
        this.setupFrame();
        this.buildFrame();
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public void setupFrame() {
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        int y = 0;
        if (!this.page.getGroups().isEmpty()) {
            OptionGroup lastGroup = (OptionGroup)this.page.getGroups().get(this.page.getGroups().size() - 1);
            for (OptionGroup group : this.page.getGroups()) {
                int visibleOptionCount = (int)group.getOptions().stream().filter(this.optionFilter::test).count();
                y += visibleOptionCount * 18;
                if (visibleOptionCount <= 0 || group == lastGroup) continue;
                y += 4;
            }
        }
        this.dim = this.dim.withHeight(y);
    }

    @Override
    public void buildFrame() {
        if (this.page == null) {
            return;
        }
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        int y = 0;
        for (OptionGroup group : this.page.getGroups()) {
            boolean needPadding = false;
            for (Option option : group.getOptions()) {
                if (!this.optionFilter.test(option)) continue;
                Control control = option.getControl();
                Dim2i dim = new Dim2i(0, y, this.dim.width(), 18).withParentOffset(this.dim);
                ControlElement element = control.createElement(dim);
                this.children.add(element);
                y += 18;
                needPadding = true;
            }
            if (!needPadding) continue;
            y += 4;
        }
        super.buildFrame();
    }

    @Override
    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        ControlElement hoveredElement = this.controlElements.stream().filter(AbstractWidget::isHovered).findFirst().orElse(this.controlElements.stream().filter(AbstractWidget::method_25370).findFirst().orElse(null));
        super.method_25394(drawContext, mouseX, mouseY, delta);
        if (hoveredElement != null && this.lastHoveredElement == hoveredElement && (this.dim.containsCursor(mouseX, mouseY) && hoveredElement.isHovered() && hoveredElement.method_25405(mouseX, mouseY) || hoveredElement.method_25370())) {
            if (this.lastTime == 0L) {
                this.lastTime = System.currentTimeMillis();
            }
            this.renderOptionTooltip(drawContext, hoveredElement);
        } else {
            this.lastTime = 0L;
            this.lastHoveredElement = hoveredElement;
        }
    }

    private void renderOptionTooltip(class_332 drawContext, ControlElement<?> element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        if (this.lastTime + 500L > System.currentTimeMillis()) {
            return;
        }
        Dim2i dim = element.getDimensions();
        int textPadding = 3;
        int boxPadding = 3;
        int boxWidth = dim.width();
        int boxY = dim.getLimitY();
        int boxX = dim.x();
        Option<?> option = element.getOption();
        ArrayList<class_5481> tooltip = new ArrayList<class_5481>(class_310.method_1551().field_1772.method_1728((class_5348)option.getTooltip(), boxWidth - textPadding * 2));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            tooltip.add(class_2477.method_10517().method_30934((class_5348)class_2561.method_43469((String)"sodium.options.performance_impact_string", (Object[])new Object[]{impact.getLocalizedName()}).method_27692(class_124.field_1080)));
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + boxPadding)) > (boxYCutoff = this.dim.getLimitY())) {
            boxY -= boxHeight + dim.height();
        }
        if (boxY < 0) {
            boxY = dim.getLimitY();
        }
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_46416(0.0f, 0.0f, 90.0f);
        this.drawRect(drawContext, boxX, boxY, boxX + boxWidth, boxY + boxHeight, -536870912);
        this.drawBorder(drawContext, boxX, boxY, boxX + boxWidth, boxY + boxHeight, -3179338);
        for (int i = 0; i < tooltip.size(); ++i) {
            drawContext.method_51430(class_310.method_1551().field_1772, (class_5481)tooltip.get(i), boxX + textPadding, boxY + textPadding + i * 12, -1, true);
        }
        drawContext.method_51448().method_22909();
    }

    @Override
    @Nullable
    public class_8016 method_48205(class_8023 navigation) {
        return super.method_48205(navigation);
    }

    public static class Builder {
        private Dim2i dim;
        private boolean renderOutline;
        private OptionPage page;
        private Predicate<Option<?>> optionFilter = Predicates.alwaysTrue();

        public Builder setDimension(Dim2i dim) {
            this.dim = dim;
            return this;
        }

        public Builder shouldRenderOutline(boolean renderOutline) {
            this.renderOutline = renderOutline;
            return this;
        }

        public Builder setOptionPage(OptionPage page) {
            this.page = page;
            return this;
        }

        public Builder setOptionFilter(Predicate<Option<?>> optionFilter) {
            this.optionFilter = optionFilter;
            return this;
        }

        public OptionPageFrame build() {
            Validate.notNull((Object)this.dim, (String)"Dimension must be specified", (Object[])new Object[0]);
            Validate.notNull((Object)this.page, (String)"Option Page must be specified", (Object[])new Object[0]);
            return new OptionPageFrame(this.dim, this.renderOutline, this.page, this.optionFilter);
        }
    }
}

