/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.biome;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import me.jellysquid.mods.sodium.client.util.color.BoxBlur;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorSource;
import me.jellysquid.mods.sodium.client.world.biome.BiomeSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.class_1163;
import net.minecraft.class_1959;
import net.minecraft.class_3532;
import net.minecraft.class_6539;

public class BiomeColorCache {
    private static final int NEIGHBOR_BLOCK_RADIUS = 2;
    private final BiomeSlice biomeData;
    private final Reference2ReferenceOpenHashMap<class_6539, Slice[]> slices;
    private long populateStamp;
    private final int blendRadius;
    private final BoxBlur.ColorBuffer tempColorBuffer;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private final int sizeXZ;
    private final int sizeY;

    public BiomeColorCache(BiomeSlice biomeData, int blendRadius) {
        this.biomeData = biomeData;
        this.blendRadius = Math.min(7, blendRadius);
        this.sizeXZ = 16 + (2 + this.blendRadius) * 2;
        this.sizeY = 20;
        this.slices = new Reference2ReferenceOpenHashMap();
        this.populateStamp = 1L;
        this.tempColorBuffer = new BoxBlur.ColorBuffer(this.sizeXZ, this.sizeXZ);
    }

    public void update(ChunkRenderContext context) {
        this.minX = context.getOrigin().method_19527() - 2 - this.blendRadius;
        this.minY = context.getOrigin().method_19528() - 2;
        this.minZ = context.getOrigin().method_19529() - 2 - this.blendRadius;
        this.maxX = context.getOrigin().method_19530() + 2 + this.blendRadius;
        this.maxY = context.getOrigin().method_19531() + 2;
        this.maxZ = context.getOrigin().method_19532() + 2 + this.blendRadius;
        ++this.populateStamp;
    }

    public int getColor(BiomeColorSource source, int blockX, int blockY, int blockZ) {
        return switch (source) {
            default -> throw new MatchException(null, null);
            case BiomeColorSource.GRASS -> this.getColor(class_1163.field_5665, blockX, blockY, blockZ);
            case BiomeColorSource.FOLIAGE -> this.getColor(class_1163.field_5664, blockX, blockY, blockZ);
            case BiomeColorSource.WATER -> this.getColor(class_1163.field_5666, blockX, blockY, blockZ);
        };
    }

    public int getColor(class_6539 resolver, int blockX, int blockY, int blockZ) {
        int relX = class_3532.method_15340((int)blockX, (int)this.minX, (int)this.maxX) - this.minX;
        int relY = class_3532.method_15340((int)blockY, (int)this.minY, (int)this.maxY) - this.minY;
        int relZ = class_3532.method_15340((int)blockZ, (int)this.minZ, (int)this.maxZ) - this.minZ;
        if (!this.slices.containsKey((Object)resolver)) {
            this.initializeSlices(resolver);
        }
        Slice slice = ((Slice[])this.slices.get((Object)resolver))[relY];
        if (slice.lastPopulateStamp < this.populateStamp) {
            this.updateColorBuffers(relY, resolver, slice);
        }
        BoxBlur.ColorBuffer buffer = slice.getBuffer();
        return buffer.get(relX, relZ);
    }

    private void initializeSlices(class_6539 resolver) {
        Slice[] slice = new Slice[this.sizeY];
        this.slices.put((Object)resolver, (Object)slice);
        for (int y = 0; y < this.sizeY; ++y) {
            slice[y] = new Slice(this.sizeXZ);
        }
    }

    private void updateColorBuffers(int relY, class_6539 resolver, Slice slice) {
        int worldY = this.minY + relY;
        for (int worldZ = this.minZ; worldZ <= this.maxZ; ++worldZ) {
            for (int worldX = this.minX; worldX <= this.maxX; ++worldX) {
                class_1959 biome = (class_1959)this.biomeData.getBiome(worldX, worldY, worldZ).comp_349();
                int relativeX = worldX - this.minX;
                int relativeZ = worldZ - this.minZ;
                slice.buffer.set(relativeX, relativeZ, resolver.getColor(biome, (double)worldX, (double)worldZ));
            }
        }
        if (this.blendRadius > 0) {
            BoxBlur.blur(slice.buffer, this.tempColorBuffer, this.blendRadius);
        }
        slice.lastPopulateStamp = this.populateStamp;
    }

    private static class Slice {
        private final BoxBlur.ColorBuffer buffer;
        private long lastPopulateStamp;

        private Slice(int size) {
            this.buffer = new BoxBlur.ColorBuffer(size, size);
        }

        public BoxBlur.ColorBuffer getBuffer() {
            return this.buffer;
        }
    }
}

