/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.config;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.AbstractBalmConfig;
import net.blay09.mods.balm.api.config.BalmConfigData;
import net.blay09.mods.balm.api.config.Comment;
import net.blay09.mods.balm.api.config.ExpectedType;
import net.blay09.mods.balm.api.event.ConfigReloadedEvent;
import net.blay09.mods.balm.api.network.ConfigReflection;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NeoForgeBalmConfig
extends AbstractBalmConfig {
    private final Logger logger = LogManager.getLogger();
    private final Map<Class<?>, ModConfig> configs = new HashMap();
    private final Map<Class<?>, BalmConfigData> configData = new HashMap();
    private final Multimap<String, Class<?>> configsByMod = ArrayListMultimap.create();
    private final Table<Class<?>, String, ModConfigSpec.ConfigValue<?>> configProperties = HashBasedTable.create();

    private static Object parseEnumValue(Class<?> type, String value) {
        for (Object enumConstant : type.getEnumConstants()) {
            if (!enumConstant.toString().equalsIgnoreCase(value)) continue;
            return enumConstant;
        }
        return null;
    }

    private static void initializeConfigurationScreen(ModContainer modContainer) {
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    private <T extends BalmConfigData> IConfigSpec createConfigSpec(Class<T> clazz) {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        try {
            this.buildConfigSpec("", builder, clazz);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Config spec generation unexpectedly failed.", e);
        }
        return builder.build();
    }

    private void buildConfigSpec(String parentPath, ModConfigSpec.Builder builder, Class<?> clazz) throws IllegalAccessException {
        List<Field> fields = ConfigReflection.getAllFields(clazz);
        Object defaults = this.createConfigDataInstance(clazz);
        ModContainer modContainer = ModLoadingContext.get().getActiveContainer();
        String modId = modContainer.getModId();
        for (Field field : fields) {
            ModConfigSpec.ConfigValue property;
            Class<?> type = field.getType();
            Object defaultValue = field.get(defaults);
            String path = parentPath + field.getName();
            Comment comment = field.getAnnotation(Comment.class);
            if (comment != null) {
                builder.comment(comment.value());
            }
            builder.translation("config." + modId + "." + path);
            if (String.class.isAssignableFrom(type)) {
                property = builder.define(path, (Object)((String)defaultValue));
                this.configProperties.put(clazz, (Object)path, (Object)property);
                continue;
            }
            if (ResourceLocation.class.isAssignableFrom(type)) {
                property = builder.define(path, (Object)((ResourceLocation)defaultValue).toString());
                this.configProperties.put(clazz, (Object)path, (Object)property);
                continue;
            }
            if (Collection.class.isAssignableFrom(type)) {
                ExpectedType expectedType = field.getAnnotation(ExpectedType.class);
                if (expectedType == null) {
                    this.logger.warn("Config field without expected type, will not validate list content ({} in {})", (Object)field.getName(), (Object)clazz.getName());
                }
                Supplier<List> defaultSupplier = () -> expectedType != null && expectedType.value().isEnum() ? ((Collection)defaultValue).stream().map(Object::toString).toList() : new ArrayList((Collection)defaultValue);
                Predicate<Object> validator = it -> expectedType == null || expectedType.value().isAssignableFrom(it.getClass()) || expectedType.value().isEnum() && Arrays.stream(expectedType.value().getEnumConstants()).anyMatch(constant -> constant.toString().equals(it));
                if (expectedType != null && ResourceLocation.class.isAssignableFrom(expectedType.value())) {
                    defaultSupplier = () -> ((Collection)defaultValue).stream().map(it -> ((ResourceLocation)it).toString()).collect(Collectors.toList());
                    validator = it -> {
                        String stringValue;
                        return it instanceof String && ResourceLocation.tryParse((String)(stringValue = (String)it)) != null;
                    };
                }
                ModConfigSpec.ConfigValue property2 = builder.defineListAllowEmpty(List.of(path.split("\\.")), defaultSupplier, validator);
                this.configProperties.put(clazz, (Object)path, (Object)property2);
                continue;
            }
            if (Enum.class.isAssignableFrom(type)) {
                property = builder.defineEnum(path, (Enum)defaultValue);
                this.configProperties.put(clazz, (Object)path, (Object)property);
                continue;
            }
            if (Integer.TYPE.isAssignableFrom(type)) {
                property = builder.defineInRange(path, ((Integer)defaultValue).intValue(), Integer.MIN_VALUE, Integer.MAX_VALUE);
                this.configProperties.put(clazz, (Object)path, (Object)property);
                continue;
            }
            if (Float.TYPE.isAssignableFrom(type)) {
                property = builder.defineInRange(path, (double)((Float)defaultValue).floatValue(), -3.4028234663852886E38, 3.4028234663852886E38);
                this.configProperties.put(clazz, (Object)path, (Object)property);
                continue;
            }
            if (Double.TYPE.isAssignableFrom(type)) {
                property = builder.defineInRange(path, ((Double)defaultValue).doubleValue(), -1.7976931348623157E308, Double.MAX_VALUE);
                this.configProperties.put(clazz, (Object)path, (Object)property);
                continue;
            }
            if (Boolean.TYPE.isAssignableFrom(type)) {
                property = builder.define(path, ((Boolean)defaultValue).booleanValue());
                this.configProperties.put(clazz, (Object)path, (Object)property);
                continue;
            }
            if (Long.TYPE.isAssignableFrom(type)) {
                property = builder.defineInRange(path, ((Long)defaultValue).longValue(), Long.MIN_VALUE, Long.MAX_VALUE);
                this.configProperties.put(clazz, (Object)path, (Object)property);
                continue;
            }
            this.buildConfigSpec(path + ".", builder, type);
        }
    }

    private <T extends BalmConfigData> T readConfigValues(Class<T> clazz, ModConfig config) {
        BalmConfigData instance = (BalmConfigData)this.createConfigDataInstance(clazz);
        try {
            this.readConfigValues("", instance, config);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return (T)instance;
    }

    private <T> void readConfigValues(String parentPath, T instance, ModConfig config) throws IllegalAccessException {
        List<Field> fields = ConfigReflection.getAllFields(instance.getClass());
        for (Field field : fields) {
            String path = parentPath + field.getName();
            UnmodifiableConfig spec = ((ModConfigSpec)config.getSpec()).getValues();
            boolean hasValue = spec.contains(path);
            Class<?> type = field.getType();
            try {
                ModConfigSpec.DoubleValue doubleValue;
                Object value;
                if (hasValue && Integer.TYPE.isAssignableFrom(type)) {
                    value = (ModConfigSpec.IntValue)spec.get(path);
                    field.set(instance, value.get());
                    continue;
                }
                if (hasValue && Long.TYPE.isAssignableFrom(type)) {
                    value = (ModConfigSpec.LongValue)spec.get(path);
                    field.set(instance, value.get());
                    continue;
                }
                if (hasValue && Float.TYPE.isAssignableFrom(type)) {
                    value = spec.get(path);
                    if (value instanceof ModConfigSpec.DoubleValue) {
                        doubleValue = (ModConfigSpec.DoubleValue)value;
                        field.set(instance, Float.valueOf(((Double)doubleValue.get()).floatValue()));
                        continue;
                    }
                    this.logger.error("Invalid config value for {}, expected {} but got {}", (Object)path, (Object)type.getName(), value.getClass());
                    continue;
                }
                if (hasValue && Double.TYPE.isAssignableFrom(type)) {
                    value = spec.get(path);
                    if (value instanceof ModConfigSpec.DoubleValue) {
                        doubleValue = (ModConfigSpec.DoubleValue)value;
                        field.set(instance, doubleValue.getAsDouble());
                        continue;
                    }
                    this.logger.error("Invalid config value for {}, expected {} but got {}", (Object)path, (Object)type.getName(), value.getClass());
                    continue;
                }
                if (hasValue && ResourceLocation.class.isAssignableFrom(type)) {
                    value = (ModConfigSpec.ConfigValue)spec.get(path);
                    field.set(instance, ResourceLocation.parse((String)((String)value.get())));
                    continue;
                }
                if (hasValue && Collection.class.isAssignableFrom(type)) {
                    value = (ModConfigSpec.ConfigValue)spec.getRaw(path);
                    Object raw = value.get();
                    if (raw instanceof List) {
                        List list = (List)raw;
                        ExpectedType expectedType = field.getAnnotation(ExpectedType.class);
                        Function<Object, Object> mapper = it -> it;
                        if (expectedType != null && ResourceLocation.class.isAssignableFrom(expectedType.value())) {
                            mapper = it -> ResourceLocation.parse((String)((String)it));
                        } else if (expectedType != null && Enum.class.isAssignableFrom(expectedType.value())) {
                            mapper = it -> NeoForgeBalmConfig.parseEnumValue(expectedType.value(), (String)it);
                        }
                        try {
                            if (List.class.isAssignableFrom(type)) {
                                field.set(instance, list.stream().map(mapper).collect(Collectors.toList()));
                                continue;
                            }
                            if (!Set.class.isAssignableFrom(type)) continue;
                            field.set(instance, list.stream().map(mapper).collect(Collectors.toSet()));
                        }
                        catch (IllegalArgumentException e) {
                            this.logger.error("Invalid config value for " + path + ", expected " + type.getName() + " but got " + String.valueOf(raw.getClass()));
                        }
                        continue;
                    }
                    this.logger.error("Null config value for " + path + ", falling back to default");
                    continue;
                }
                if (hasValue && (type.isPrimitive() || String.class.isAssignableFrom(type))) {
                    value = spec.get(path);
                    if (value instanceof ModConfigSpec.ConfigValue) {
                        ModConfigSpec.ConfigValue stringValue = (ModConfigSpec.ConfigValue)value;
                        try {
                            field.set(instance, stringValue.get());
                        }
                        catch (IllegalArgumentException e) {
                            this.logger.error("Invalid config value for " + path + ", expected " + type.getName() + " but got " + String.valueOf(value.getClass()));
                        }
                        continue;
                    }
                    this.logger.error("Null config value for " + path + ", falling back to default");
                    continue;
                }
                if (hasValue && type.isEnum()) {
                    value = (ModConfigSpec.EnumValue)spec.get(path);
                    field.set(instance, value.get());
                    continue;
                }
                this.readConfigValues(path + ".", field.get(instance), config);
            }
            catch (Exception e) {
                this.logger.error("Unexpected error loading config value for " + path + ", falling back to default", (Throwable)e);
            }
        }
    }

    private <T extends BalmConfigData> void writeConfigValues(Class<?> clazz, T configData) {
        try {
            this.writeConfigValues("", clazz, configData);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private <T> void writeConfigValues(String parentPath, Class<?> clazz, T instance) throws IllegalAccessException {
        List<Field> fields = ConfigReflection.getAllFields(instance.getClass());
        for (Field field : fields) {
            ModConfigSpec.ConfigValue property;
            String path = parentPath + field.getName();
            Class<?> type = field.getType();
            Object value = field.get(instance);
            if (type.isPrimitive() || Enum.class.isAssignableFrom(type) || String.class.isAssignableFrom(type)) {
                property = (ModConfigSpec.ConfigValue)this.configProperties.get(clazz, (Object)path);
                if (property == null) continue;
                property.set(value);
                continue;
            }
            if (ResourceLocation.class.isAssignableFrom(type)) {
                property = (ModConfigSpec.ConfigValue)this.configProperties.get(clazz, (Object)path);
                if (property == null) continue;
                property.set((Object)((ResourceLocation)value).toString());
                continue;
            }
            if (Collection.class.isAssignableFrom(type)) {
                property = (ModConfigSpec.ConfigValue)this.configProperties.get(clazz, (Object)path);
                if (property == null) continue;
                property.set(new ArrayList((Collection)value));
                continue;
            }
            this.writeConfigValues(path + ".", field.getType(), field.get(instance));
        }
    }

    @Override
    public <T extends BalmConfigData> T initializeBackingConfig(Class<T> clazz) {
        IConfigSpec configSpec = this.createConfigSpec(clazz);
        ModContainer modContainer = ModLoadingContext.get().getActiveContainer();
        BalmConfigData initialData = (BalmConfigData)this.createConfigDataInstance(clazz);
        this.setActiveConfig(clazz, initialData);
        this.configData.put(clazz, initialData);
        this.configsByMod.put((Object)this.getConfigName(clazz), clazz);
        modContainer.getEventBus().addListener(event -> {
            this.configs.put(clazz, event.getConfig());
            Object newConfigData = this.readConfigValues(clazz, event.getConfig());
            this.configData.put(clazz, (BalmConfigData)newConfigData);
            this.setActiveConfig(clazz, newConfigData);
        });
        modContainer.getEventBus().addListener(event -> {
            this.configs.put(clazz, event.getConfig());
            Object newConfigData = this.readConfigValues(clazz, event.getConfig());
            this.configData.put(clazz, (BalmConfigData)newConfigData);
            boolean hasSyncMessage = this.getConfigSyncMessageFactory(clazz) != null;
            boolean isHostingServer = ServerLifecycleHooks.getCurrentServer() != null;
            boolean isIngame = Balm.getProxy().isIngame();
            if (!hasSyncMessage || isHostingServer || !isIngame) {
                this.setActiveConfig(clazz, newConfigData);
            }
            Balm.getEvents().fireEvent(new ConfigReloadedEvent());
        });
        modContainer.registerConfig(ModConfig.Type.COMMON, configSpec);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            NeoForgeBalmConfig.initializeConfigurationScreen(modContainer);
        }
        return this.getActive(clazz);
    }

    @Override
    public <T extends BalmConfigData> T getBackingConfig(Class<T> clazz) {
        return (T)this.configData.get(clazz);
    }

    @Override
    public <T extends BalmConfigData> void saveBackingConfig(Class<T> clazz) {
        ModConfig modConfig = this.configs.get(clazz);
        if (modConfig != null) {
            this.writeConfigValues(clazz, this.configData.get(clazz));
            ((ModConfigSpec)modConfig.getSpec()).save();
        }
    }

    @Override
    public File getConfigDir() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    @Override
    public List<? extends BalmConfigData> getConfigsByMod(String modId) {
        return this.configsByMod.get((Object)modId).stream().map(this.configData::get).toList();
    }
}

