/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.command.BalmCommands;
import net.blay09.mods.balm.common.client.IconExport;
import net.blay09.mods.balm.common.config.ConfigJsonExport;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameRules;

public class BalmCommand {
    private static final ResourceLocation PERMISSION_BALM_DEV = ResourceLocation.fromNamespaceAndPath((String)"balm", (String)"command.balm.dev");
    private static final ResourceLocation PERMISSION_BALM_EXPORT_CONFIG = ResourceLocation.fromNamespaceAndPath((String)"balm", (String)"command.balm.export.config");
    private static final ResourceLocation PERMISSION_BALM_EXPORT_ICONS = ResourceLocation.fromNamespaceAndPath((String)"balm", (String)"command.balm.export.icons");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        BalmCommands.registerPermission(PERMISSION_BALM_DEV, 2);
        BalmCommands.registerPermission(PERMISSION_BALM_EXPORT_CONFIG, 4);
        BalmCommands.registerPermission(PERMISSION_BALM_EXPORT_ICONS, 4);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"balm").then(((LiteralArgumentBuilder)Commands.literal((String)"dev").requires(BalmCommands.requirePermission(PERMISSION_BALM_DEV))).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            MinecraftServer server = source.getServer();
            GameRules gameRules = server.getGameRules();
            ((GameRules.BooleanValue)gameRules.getRule(GameRules.RULE_DAYLIGHT)).set(false, server);
            source.sendSuccess(() -> Component.literal((String)"Daylight cycle disabled"), true);
            ((GameRules.BooleanValue)gameRules.getRule(GameRules.RULE_WEATHER_CYCLE)).set(false, server);
            source.sendSuccess(() -> Component.literal((String)"Weather cycle disabled"), true);
            ((GameRules.BooleanValue)gameRules.getRule(GameRules.RULE_KEEPINVENTORY)).set(true, server);
            source.sendSuccess(() -> Component.literal((String)"Keep Inventory enabled"), true);
            ((GameRules.BooleanValue)gameRules.getRule(GameRules.RULE_DOINSOMNIA)).set(false, server);
            source.sendSuccess(() -> Component.literal((String)"Insomnia disabled"), true);
            ((GameRules.BooleanValue)gameRules.getRule(GameRules.RULE_MOBGRIEFING)).set(false, server);
            source.sendSuccess(() -> Component.literal((String)"Mob Griefing disabled"), true);
            ((GameRules.BooleanValue)gameRules.getRule(GameRules.RULE_DO_TRADER_SPAWNING)).set(false, server);
            source.sendSuccess(() -> Component.literal((String)"Trader Spawning disabled"), true);
            server.setDifficulty(Difficulty.PEACEFUL, true);
            source.sendSuccess(() -> Component.literal((String)"Difficulty set to Peaceful"), true);
            server.overworld().setWeatherParameters(99999, 0, false, false);
            source.sendSuccess(() -> Component.literal((String)"Weather cleared"), true);
            for (ServerLevel level : server.getAllLevels()) {
                level.setDayTime(1000L);
            }
            source.sendSuccess(() -> Component.literal((String)"Set the time to Daytime"), true);
            return 0;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"export").requires(BalmCommands.requireAnyPermission(PERMISSION_BALM_EXPORT_CONFIG, PERMISSION_BALM_EXPORT_ICONS))).then(((LiteralArgumentBuilder)Commands.literal((String)"config").requires(BalmCommands.requirePermission(PERMISSION_BALM_EXPORT_CONFIG))).then(Commands.argument((String)"class", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String className = (String)context.getArgument("class", String.class);
            try {
                Class<?> configDataClass = Class.forName(className);
                ConfigJsonExport.exportToFile(configDataClass, new File("exports/config/" + configDataClass.getSimpleName() + ".json"));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException("Invalid config data class: " + className, e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Error exporting config data class: " + className, e);
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Exported config for " + className)), false);
            return 0;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"icons").requires(BalmCommands.requirePermission(PERMISSION_BALM_EXPORT_ICONS))).then(Commands.argument((String)"filter", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String filter = (String)context.getArgument("filter", String.class);
            if (Balm.getProxy().isClient()) {
                try {
                    IconExport.export(filter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("Error exporting icons for " + filter, e);
                }
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Exported icons for " + filter)), false);
                return 1;
            }
            return 0;
        })))));
    }
}

