/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.handler;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.handler.TickHandler;
import com.bawnorton.neruina.util.TickingEntry;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public final class PersitanceHandler
extends SavedData {
    private static ServerLevel world;
    private static final SavedData.Factory<PersitanceHandler> type;

    public static PersitanceHandler getServerState(MinecraftServer server) {
        world = server.getLevel(Level.OVERWORLD);
        assert (world != null);
        DimensionDataStorage manager = world.getDataStorage();
        PersitanceHandler handler = (PersitanceHandler)manager.computeIfAbsent(type, "neruina");
        handler.setDirty();
        return handler;
    }

    private static PersitanceHandler fromNbt(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        return PersitanceHandler.fromNbtInternal(nbt);
    }

    private static PersitanceHandler fromNbt(CompoundTag nbt) {
        return PersitanceHandler.fromNbtInternal(nbt);
    }

    private static PersitanceHandler fromNbtInternal(CompoundTag nbt) {
        PersitanceHandler handler = new PersitanceHandler();
        TickHandler tickHandler = Neruina.getInstance().getTickHandler();
        ListTag tickingEntries = nbt.getList("tickingEntries", 10);
        for (int i = 0; i < tickingEntries.size(); ++i) {
            tickHandler.addTickingEntryUnsafe(TickingEntry.fromNbt(world, tickingEntries.getCompound(i)));
        }
        return handler;
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        return this.writeNbtInternal(nbt);
    }

    public CompoundTag writeNbt(CompoundTag nbt) {
        return this.writeNbtInternal(nbt);
    }

    private CompoundTag writeNbtInternal(CompoundTag nbt) {
        ListTag tickingEntries = new ListTag();
        Neruina.getInstance().getTickHandler().getTickingEntries().stream().filter(TickingEntry::isPersitent).forEach(entry -> tickingEntries.add((Object)entry.writeNbt()));
        nbt.put("tickingEntries", (Tag)tickingEntries);
        return nbt;
    }

    static {
        type = new SavedData.Factory(PersitanceHandler::new, PersitanceHandler::fromNbt, null);
    }
}

