/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.command;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.extend.Errorable;
import com.bawnorton.neruina.handler.MessageHandler;
import com.bawnorton.neruina.handler.TickHandler;
import com.bawnorton.neruina.report.GithubAuthManager;
import com.bawnorton.neruina.report.ReportStatus;
import com.bawnorton.neruina.util.ErroredType;
import com.bawnorton.neruina.util.TickingEntry;
import com.bawnorton.neruina.version.Texter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;

public final class NeruinaCommandHandler {
    private static final MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"neruina").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"resume").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"entity").then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).executes(NeruinaCommandHandler::executeResumeEntity)))).then(Commands.literal((String)"block_entity").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(NeruinaCommandHandler::executeResumeBlockEntity)))).then(Commands.literal((String)"block_state").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(NeruinaCommandHandler::executeResumeBlockState)))).then(Commands.literal((String)"item_stack").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.entity()).executes(NeruinaCommandHandler::executeResumeHeldItem))))).then(((LiteralArgumentBuilder)Commands.literal((String)"kill").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entities()).executes(NeruinaCommandHandler::executeKill)))).then(((LiteralArgumentBuilder)Commands.literal((String)"report").then(Commands.argument((String)"id", (ArgumentType)UuidArgument.uuid()).executes(NeruinaCommandHandler::executeReport))).then(Commands.literal((String)"test").executes(NeruinaCommandHandler::executeTestReport)))).then(Commands.literal((String)"cancel_login").executes(NeruinaCommandHandler::executeCancelLogin))).then(((LiteralArgumentBuilder)Commands.literal((String)"id").then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).executes(NeruinaCommandHandler::executeIdEntity))).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(NeruinaCommandHandler::executeIdBlock)))).then(Commands.literal((String)"info").then(Commands.argument((String)"id", (ArgumentType)UuidArgument.uuid()).executes(NeruinaCommandHandler::executeInfo)))).then(((LiteralArgumentBuilder)Commands.literal((String)"clear_tracked").requires(source -> source.hasPermission(2))).executes(NeruinaCommandHandler::executeClear))).then(Commands.literal((String)"show_suspended").executes(NeruinaCommandHandler::executeShowSuspended)));
    }

    private static int executeResumeEntity(CommandContext<CommandSourceStack> context) {
        try {
            Entity entity = EntityArgument.getEntity(context, (String)"entity");
            if (!((Errorable)entity).neruina$isErrored()) {
                ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.resume.entity.not_errored", entity.getName().getString()));
                return 0;
            }
            Neruina.getInstance().getTickHandler().removeErrored(entity);
            NeruinaCommandHandler.sendFeedback(context, messageHandler.formatText("commands.neruina.resume.entity", entity.getName().getString()));
        }
        catch (CommandSyntaxException ignored) {
            ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.resume.entity.not_found", new Object[0]));
        }
        return 1;
    }

    private static int executeResumeBlockEntity(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getBlockPos(context, (String)"pos");
        BlockEntity blockEntity = ((CommandSourceStack)context.getSource()).getLevel().getBlockEntity(pos);
        if (blockEntity == null) {
            ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.resume.block_entity.not_found", messageHandler.posAsNums(pos)));
            return 0;
        }
        ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
        LevelChunk worldChunk = world.getChunkAt(pos);
        BlockState state = worldChunk.getBlockState(pos);
        Block block = state.getBlock();
        String name = block.getName().getString();
        if (!((Errorable)blockEntity).neruina$isErrored()) {
            ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.resume.block_entity.not_errored", name, messageHandler.posAsNums(pos)));
            return 0;
        }
        Neruina.getInstance().getTickHandler().removeErrored(blockEntity);
        worldChunk.addAndRegisterBlockEntity(blockEntity);
        NeruinaCommandHandler.sendFeedback(context, messageHandler.formatText("commands.neruina.resume.block_entity", name, messageHandler.posAsNums(pos)));
        return 1;
    }

    private static int executeResumeBlockState(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getBlockPos(context, (String)"pos");
        BlockState blockState = ((CommandSourceStack)context.getSource()).getLevel().getBlockState(pos);
        String name = blockState.getBlock().getName().getString();
        if (!Neruina.getInstance().getTickHandler().isErrored(blockState, pos)) {
            ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.resume.block_state.not_errored", name, messageHandler.posAsNums(pos)));
            return 0;
        }
        Neruina.getInstance().getTickHandler().removeErrored(blockState, pos);
        NeruinaCommandHandler.sendFeedback(context, messageHandler.formatText("commands.neruina.resume.block_state", name, messageHandler.posAsNums(pos)));
        return 1;
    }

    private static int executeResumeHeldItem(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
            ItemStack stack = player.getItemInHand(player.getUsedItemHand());
            if (!((Errorable)stack).neruina$isErrored()) {
                ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.resume.item_stack.not_errored", player.getName().getString(), stack.getHoverName().getString()));
                return 0;
            }
            Neruina.getInstance().getTickHandler().removeErrored(stack);
            NeruinaCommandHandler.sendFeedback(context, messageHandler.formatText("commands.neruina.resume.item_stack", player.getName().getString(), stack.getHoverName().getString()));
        }
        catch (CommandSyntaxException ignored) {
            ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.resume.entity.not_found", new Object[0]));
        }
        return 1;
    }

    private static int executeKill(CommandContext<CommandSourceStack> context) {
        try {
            Collection entities = EntityArgument.getEntities(context, (String)"entity");
            if (entities.size() == 1) {
                Entity entity = (Entity)entities.iterator().next();
                String name = entity.getName().getString();
                if (!((Errorable)entity).neruina$isErrored()) {
                    ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.kill.not_errored", name));
                    return 0;
                }
                Neruina.getInstance().getTickHandler().killEntity(entity, messageHandler.formatText("commands.neruina.kill", name));
            } else {
                int killed = 0;
                for (Entity entity : entities) {
                    if (!((Errorable)entity).neruina$isErrored()) continue;
                    Neruina.getInstance().getTickHandler().killEntity(entity, null);
                    ++killed;
                }
                NeruinaCommandHandler.sendFeedback(context, NeruinaCommandHandler.getKilledResultMessage(entities, killed));
            }
        }
        catch (CommandSyntaxException ignored) {
            ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.kill.not_found", new Object[0]));
        }
        return 1;
    }

    private static Component getKilledResultMessage(Collection<? extends Entity> entities, int killed) {
        int missed = entities.size() - killed;
        Component message = killed == 1 && missed == 1 ? messageHandler.formatText("commands.neruina.kill.multiple.singular_singular", new Object[0]) : (killed == 1 ? messageHandler.formatText("commands.neruina.kill.multiple.singular_plural", missed) : (missed == 1 ? messageHandler.formatText("commands.neruina.kill.multiple.plural_singular", killed) : messageHandler.formatText("commands.neruina.kill.multiple", killed, missed)));
        return message;
    }

    private static int executeReport(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        UUID id = UuidArgument.getUuid(context, (String)"id");
        TickingEntry entry = Neruina.getInstance().getTickHandler().getTickingEntry(id);
        if (entry == null) {
            ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.report.not_found", id.toString()));
            return 0;
        }
        Neruina.getInstance().getAutoReportHandler().createReports(((CommandSourceStack)context.getSource()).getPlayerOrException(), entry).thenAccept(result -> {
            ReportStatus.Code reportCode = result.code();
            switch (reportCode) {
                case SUCCESS: {
                    NeruinaCommandHandler.sendFeedback(context, Texter.concatDelimited(Texter.LINE_BREAK, Texter.format(Texter.translatable("commands.neruina.report.success", new Object[0])), messageHandler.generateOpenReportAction(result.message())));
                    break;
                }
                case ALREADY_EXISTS: {
                    ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.report.already_exists", new Object[0]));
                    break;
                }
                case FAILURE: {
                    ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.report.failure", new Object[0]));
                    break;
                }
                case TIMEOUT: {
                    ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.report.timeout", new Object[0]));
                    break;
                }
                case ABORTED: {
                    ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.report.aborted", new Object[0]));
                    break;
                }
                case IN_PROGRESS: {
                    ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.report.in_progress", new Object[0]));
                    break;
                }
            }
        });
        return 1;
    }

    private static int executeTestReport(CommandContext<CommandSourceStack> context) {
        try {
            Neruina.getInstance().getAutoReportHandler().testReporting(((CommandSourceStack)context.getSource()).getPlayerOrException());
            ((CommandSourceStack)context.getSource()).sendSystemMessage(messageHandler.formatText("commands.neruina.report.test.pass", new Object[0]));
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage(messageHandler.formatText("commands.neruina.report.test.fail", new Object[0]));
        }
        return 1;
    }

    private static int executeCancelLogin(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        boolean wasLoggingIn = GithubAuthManager.cancelLogin(((CommandSourceStack)context.getSource()).getPlayerOrException());
        if (!wasLoggingIn) {
            ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.cancel.not_logging_in", new Object[0]));
            return 0;
        }
        return 1;
    }

    private static int executeIdBlock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getBlockPos(context, (String)"pos");
        BlockEntity blockEntity = ((CommandSourceStack)context.getSource()).getLevel().getBlockEntity(pos);
        Neruina.getInstance().getTickHandler().getTickingEntryId(blockEntity).ifPresentOrElse(uuid -> NeruinaCommandHandler.sendFeedback(context, Texter.withStyle(messageHandler.formatText("commands.neruina.id", uuid.toString()), style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, uuid.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Texter.translatable("commands.neruina.id.tooltip", new Object[0]))))), () -> ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.id.block.not_errored", ((CommandSourceStack)context.getSource()).getLevel().getBlockState(pos).getBlock().getName().getString(), messageHandler.posAsNums(pos))));
        return 1;
    }

    private static int executeIdEntity(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(context, (String)"entity");
        TickHandler tickHandler = Neruina.getInstance().getTickHandler();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack stack = player.getItemInHand(player.getUsedItemHand());
            tickHandler.getTickingEntryId(stack).ifPresentOrElse(uuid -> NeruinaCommandHandler.sendFeedback(context, Texter.withStyle(messageHandler.formatText("commands.neruina.id", uuid.toString()), style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, uuid.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Texter.translatable("commands.neruina.id.tooltip", new Object[0]))))), () -> ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.id.item_stack.not_errored", player.getName().getString(), stack.getHoverName().getString())));
        } else {
            tickHandler.getTickingEntryId(entity).ifPresentOrElse(uuid -> NeruinaCommandHandler.sendFeedback(context, Texter.withStyle(messageHandler.formatText("commands.neruina.id", uuid.toString()), style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, uuid.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Texter.translatable("commands.neruina.id.tooltip", new Object[0]))))), () -> ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.id.entity.not_errored", entity.getName().getString())));
        }
        return 1;
    }

    private static int executeInfo(CommandContext<CommandSourceStack> context) {
        UUID id = UuidArgument.getUuid(context, (String)"id");
        TickingEntry entry = Neruina.getInstance().getTickHandler().getTickingEntry(id);
        if (entry == null) {
            ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.info.not_found", id.toString()));
            return 0;
        }
        Object cause = entry.getCause();
        if (cause == null) {
            NeruinaCommandHandler.sendFeedback(context, Texter.pad(Texter.concatDelimited(Texter.LINE_BREAK, Texter.format(Texter.translatable("commands.neruina.info.null_cause", entry.getCauseName(), messageHandler.posAsNums(entry.pos()))), messageHandler.generateTeleportAction(ErroredType.UNKNOWN, entry.dimension(), entry.pos()), messageHandler.generateResourceActions(entry))));
        } else if (cause instanceof Entity) {
            Entity entity = (Entity)cause;
            NeruinaCommandHandler.sendFeedback(context, Texter.pad(Texter.concatDelimited(Texter.LINE_BREAK, Texter.format(Texter.translatable("commands.neruina.info.entity", entry.getCauseName(), messageHandler.posAsNums(entry.pos()))), messageHandler.generateEntityActions(entity), messageHandler.generateResourceActions(entry))));
        } else if (cause instanceof BlockEntity) {
            NeruinaCommandHandler.sendFeedback(context, Texter.pad(Texter.concatDelimited(Texter.LINE_BREAK, Texter.format(Texter.translatable("commands.neruina.info.block_entity", entry.getCauseName(), messageHandler.posAsNums(entry.pos()))), messageHandler.generateHandlingActions(ErroredType.BLOCK_ENTITY, entry.dimension(), entry.pos()), messageHandler.generateResourceActions(entry))));
        } else if (cause instanceof ItemStack) {
            NeruinaCommandHandler.sendFeedback(context, Texter.pad(Texter.concatDelimited(Texter.LINE_BREAK, Texter.format(Texter.translatable("commands.neruina.info.item_stack", entry.getCauseName())), messageHandler.generateResumeAction(ErroredType.ITEM_STACK, entry.uuid().toString()), messageHandler.generateResourceActions(entry))));
        } else {
            NeruinaCommandHandler.sendFeedback(context, Texter.pad(Texter.concatDelimited(Texter.LINE_BREAK, Texter.format(Texter.translatable("commands.neruina.info.unknown", entry.getCauseName())), messageHandler.generateResourceActions(entry))));
        }
        return 1;
    }

    private static int executeClear(CommandContext<CommandSourceStack> context) {
        int count = Neruina.getInstance().getTickHandler().clearTracked();
        if (count == 0) {
            ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.clear.none", new Object[0]));
            return 0;
        }
        NeruinaCommandHandler.sendFeedback(context, messageHandler.formatText("commands.neruina.clear", count));
        return 1;
    }

    private static int executeShowSuspended(CommandContext<CommandSourceStack> context) {
        int count = Neruina.getInstance().getTickHandler().getTickingEntries().size();
        if (count == 0) {
            ((CommandSourceStack)context.getSource()).sendFailure(messageHandler.formatText("commands.neruina.show_suspended.none", new Object[0]));
            return 0;
        }
        Component message = messageHandler.generateSuspendedInfo();
        NeruinaCommandHandler.sendFeedback(context, message);
        return 1;
    }

    private static void sendFeedback(CommandContext<CommandSourceStack> context, Component text) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> text, true);
    }
}

