/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.time_on_display.core;

import com.cursee.monolib.platform.Services;
import com.cursee.monolib.util.toml.Toml;
import com.cursee.monolib.util.toml.TomlWriter;
import forge.com.cursee.time_on_display.Constants;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TimeOnDisplayConfig {
    public static final File CONFIG_DIRECTORY = new File(Services.PLATFORM.getGameDirectory() + File.separator + "config");
    public static final String CONFIG_FILEPATH = String.valueOf(CONFIG_DIRECTORY) + File.separator + "time_on_display.toml";
    public static boolean displayEnabled = true;
    public static boolean displayOnlySystemTime = false;
    public static boolean displayClockIcons = true;
    public static boolean display24Hour = false;
    public static String displayLocation = "upper-left";
    public static String displaySystemTimeIcon = "";
    public static final Map<String, Object> comments = new HashMap<String, Object>();
    public static final Map<String, Object> defaults = new HashMap<String, Object>();

    public static void initialize() {
        comments.put("_comment1", "displaySystemTimeIcon can be 1 or 2 (in quotes) for alternate icons");
        comments.put("_comment2", "displayLocation can be lower-left,  upper-left, upper-middle, upper-right, or lower-right (in quotes) for alternate positions");
        defaults.put("displayEnabled", displayEnabled);
        defaults.put("displayOnlySystemTime", displayOnlySystemTime);
        defaults.put("displayClockIcons", displayClockIcons);
        defaults.put("display24Hour", display24Hour);
        defaults.put("displayLocation", displayLocation);
        defaults.put("displaySystemTimeIcon", displaySystemTimeIcon);
        comments.putAll(defaults);
        if (!CONFIG_DIRECTORY.isDirectory()) {
            CONFIG_DIRECTORY.mkdir();
        }
        File CONFIG_FILE = new File(CONFIG_FILEPATH);
        TimeOnDisplayConfig.handle(CONFIG_FILE);
    }

    public static void handle(File file) {
        boolean FILE_NOT_FOUND;
        boolean bl = FILE_NOT_FOUND = !file.isFile();
        if (FILE_NOT_FOUND) {
            try {
                TomlWriter writer = new TomlWriter();
                writer.write(comments, file);
            }
            catch (IOException exception) {
                Constants.LOG.error("Fatal error occurred while attempting to write time_on_display.toml");
                Constants.LOG.error("Did another process delete the config directory during writing?");
                Constants.LOG.error(exception.getMessage());
            }
        } else {
            try {
                Toml toml = new Toml().read(file);
                displayEnabled = toml.getBoolean("displayEnabled");
                displayOnlySystemTime = toml.getBoolean("displayOnlySystemTime");
                displayClockIcons = toml.getBoolean("displayClockIcons");
                display24Hour = toml.getBoolean("display24Hour");
                displayLocation = toml.getString("displayLocation");
                displaySystemTimeIcon = toml.getString("displaySystemTimeIcon");
            }
            catch (IllegalStateException exception) {
                Constants.LOG.error("Fatal error occurred while attempting to read time_on_display.toml");
                Constants.LOG.error("Did another process delete the file during reading?");
                Constants.LOG.error(exception.getMessage());
            }
        }
    }
}

