/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.logging;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.connectivity.logging.PacketLogging;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.ReflectionAccessFilterHelper;
import com.google.gson.internal.reflect.ReflectionHelper;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ReflectiveSafeTypeAdapterFactory {
    private static boolean includeField(Field f, boolean serialize) {
        return !PacketLogging.getGson().excluder().excludeClass(f.getType(), serialize) && !PacketLogging.getGson().excluder().excludeField(f, serialize);
    }

    private static List<String> getFieldNames(Field f) {
        SerializedName annotation = f.getAnnotation(SerializedName.class);
        if (annotation == null) {
            String name = PacketLogging.getGson().fieldNamingStrategy().translateName(f);
            return Collections.singletonList(name);
        }
        String serializedName = annotation.value();
        String[] alternates = annotation.alternate();
        if (alternates.length == 0) {
            return Collections.singletonList(serializedName);
        }
        ArrayList<String> fieldNames = new ArrayList<String>(alternates.length + 1);
        fieldNames.add(serializedName);
        Collections.addAll(fieldNames, alternates);
        return fieldNames;
    }

    public static <T> TypeAdapter<T> createNew(Gson gson, TypeToken<T> type) {
        try {
            Class raw = type.getRawType();
            if (!Object.class.isAssignableFrom(raw)) {
                return null;
            }
            boolean blockInaccessible = false;
            if (ReflectionHelper.isRecord((Class)raw)) {
                RecordAdapter adapter = new RecordAdapter(raw, ReflectiveSafeTypeAdapterFactory.getBoundFields(gson, type, raw, blockInaccessible, true), blockInaccessible);
                return adapter;
            }
            return new FieldReflectionAdapter(ReflectiveSafeTypeAdapterFactory.getBoundFields(gson, type, raw, blockInaccessible, false));
        }
        catch (Throwable t) {
            if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
                Connectivity.LOGGER.info("Could not create Type adapter for:" + type.getType().getTypeName(), t);
            }
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T value) throws IOException {
                    out.value("Unable to deserialize");
                }

                public T read(JsonReader in) throws IOException {
                    return null;
                }
            };
        }
    }

    private static <M extends AccessibleObject> void checkAccessible(Object object, M member) {
        if (!ReflectionAccessFilterHelper.canAccess(member, (Object)(Modifier.isStatic(((Member)((Object)member)).getModifiers()) ? null : object))) {
            String memberDescription = ReflectionHelper.getAccessibleObjectDescription(member, (boolean)true);
            throw new JsonIOException(memberDescription + " is not accessible and ReflectionAccessFilter does not permit making it accessible. Register a TypeAdapter for the declaring type, adjust the access filter or increase the visibility of the element and its declaring type.");
        }
    }

    private static BoundField createBoundField(final Gson context, Field field, final Method accessor, String name, final TypeToken<?> fieldType, boolean serialize, boolean deserialize, final boolean blockInaccessible) {
        TypeAdapter mapped;
        final boolean isPrimitive = Primitives.isPrimitive((Type)fieldType.getRawType());
        int modifiers = field.getModifiers();
        final boolean isStaticFinalField = Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
        JsonAdapter annotation = field.getAnnotation(JsonAdapter.class);
        final TypeAdapter typeAdapter = mapped = context.getAdapter(fieldType);
        return new BoundField(name, field, serialize, deserialize){

            @Override
            void write(JsonWriter writer, Object source) throws IOException, IllegalAccessException {
                Object fieldValue;
                if (!this.serialized) {
                    return;
                }
                if (blockInaccessible) {
                    if (accessor == null) {
                        ReflectiveSafeTypeAdapterFactory.checkAccessible(source, this.field);
                    } else {
                        ReflectiveSafeTypeAdapterFactory.checkAccessible(source, accessor);
                    }
                }
                if (accessor != null) {
                    try {
                        fieldValue = accessor.invoke(source, new Object[0]);
                    }
                    catch (Exception e) {
                        String accessorDescription = ReflectionHelper.getAccessibleObjectDescription((AccessibleObject)accessor, (boolean)false);
                        throw new JsonIOException("Accessor " + accessorDescription + " threw exception", e.getCause());
                    }
                } else {
                    fieldValue = this.field.get(source);
                }
                if (fieldValue == source) {
                    return;
                }
                writer.name(this.name);
                Type runtimeType = ReflectiveSafeTypeAdapterFactory.getRuntimeTypeIfMoreSpecific(fieldType.getType(), fieldValue);
                TypeAdapter runtimeTypeAdapter = context.getAdapter(TypeToken.get((Type)runtimeType));
                runtimeTypeAdapter.write(writer, fieldValue);
            }

            @Override
            void readIntoArray(JsonReader reader, int index, Object[] target) throws IOException, JsonParseException {
                Object fieldValue = typeAdapter.read(reader);
                if (fieldValue == null && isPrimitive) {
                    throw new JsonParseException("null is not allowed as value for record component '" + this.fieldName + "' of primitive type; at path " + reader.getPath());
                }
                target[index] = fieldValue;
            }

            @Override
            void readIntoField(JsonReader reader, Object target) throws IOException, IllegalAccessException {
                Object fieldValue = typeAdapter.read(reader);
                if (fieldValue != null || !isPrimitive) {
                    if (blockInaccessible) {
                        ReflectiveSafeTypeAdapterFactory.checkAccessible(target, this.field);
                    } else if (isStaticFinalField) {
                        String fieldDescription = ReflectionHelper.getAccessibleObjectDescription((AccessibleObject)this.field, (boolean)false);
                        throw new JsonIOException("Cannot set value of 'static final' " + fieldDescription);
                    }
                    this.field.set(target, fieldValue);
                }
            }
        };
    }

    private static Map<String, BoundField> getBoundFields(Gson context, TypeToken<?> type, Class<?> raw, boolean blockInaccessible, boolean isRecord) {
        LinkedHashMap<String, BoundField> result = new LinkedHashMap<String, BoundField>();
        if (raw.isInterface()) {
            return result;
        }
        Class originalRaw = raw;
        while (raw != Object.class) {
            Field[] fields = raw.getDeclaredFields();
            if (raw != originalRaw && fields.length > 0) {
                blockInaccessible = false;
            }
            for (Field field : fields) {
                try {
                    boolean serialize = ReflectiveSafeTypeAdapterFactory.includeField(field, true);
                    boolean deserialize = ReflectiveSafeTypeAdapterFactory.includeField(field, false);
                    if (!serialize && !deserialize) continue;
                    Method accessor = null;
                    if (isRecord) {
                        if (Modifier.isStatic(field.getModifiers())) {
                            deserialize = false;
                        } else {
                            accessor = ReflectionHelper.getAccessor((Class)raw, (Field)field);
                            if (!blockInaccessible) {
                                ReflectionHelper.makeAccessible((AccessibleObject)accessor);
                            }
                            if (accessor.getAnnotation(SerializedName.class) != null && field.getAnnotation(SerializedName.class) == null) {
                                String methodDescription = ReflectionHelper.getAccessibleObjectDescription((AccessibleObject)accessor, (boolean)false);
                                throw new JsonIOException("@SerializedName on " + methodDescription + " is not supported");
                            }
                        }
                    }
                    if (!blockInaccessible && accessor == null) {
                        ReflectionHelper.makeAccessible((AccessibleObject)field);
                    }
                    Type fieldType = .Gson.Types.resolve((Type)type.getType(), (Class)raw, (Type)field.getGenericType());
                    List<String> fieldNames = ReflectiveSafeTypeAdapterFactory.getFieldNames(field);
                    BoundField previous = null;
                    int size = fieldNames.size();
                    for (int i = 0; i < size; ++i) {
                        String name = fieldNames.get(i);
                        if (i != 0) {
                            serialize = false;
                        }
                        BoundField boundField = ReflectiveSafeTypeAdapterFactory.createBoundField(context, field, accessor, name, TypeToken.get((Type)fieldType), serialize, deserialize, blockInaccessible);
                        BoundField replaced = result.put(name, boundField);
                        if (previous != null) continue;
                        previous = replaced;
                    }
                    if (previous == null) continue;
                    throw new IllegalArgumentException("Class " + originalRaw.getName() + " declares multiple JSON fields named '" + previous.name + "'; conflict is caused by fields " + ReflectionHelper.fieldToString((Field)previous.field) + " and " + ReflectionHelper.fieldToString((Field)field));
                }
                catch (Throwable e) {
                    if (!((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) continue;
                    Connectivity.LOGGER.info("Could not serialize field:" + field.getName());
                }
            }
            type = TypeToken.get((Type).Gson.Types.resolve((Type)type.getType(), raw, (Type)raw.getGenericSuperclass()));
            raw = type.getRawType();
        }
        return result;
    }

    private static Type getRuntimeTypeIfMoreSpecific(Type type, Object value) {
        if (value != null && (type instanceof Class || type instanceof TypeVariable)) {
            type = value.getClass();
        }
        return type;
    }

    private static final class RecordAdapter<T>
    extends Adapter<T, Object[]> {
        static final Map<Class<?>, Object> PRIMITIVE_DEFAULTS = RecordAdapter.primitiveDefaults();
        private final Constructor<T> constructor;
        private final Object[] constructorArgsDefaults;
        private final Map<String, Integer> componentIndices = new HashMap<String, Integer>();

        RecordAdapter(Class<T> raw, Map<String, BoundField> boundFields, boolean blockInaccessible) {
            super(boundFields);
            this.constructor = ReflectionHelper.getCanonicalRecordConstructor(raw);
            if (blockInaccessible) {
                ReflectiveSafeTypeAdapterFactory.checkAccessible(null, this.constructor);
            } else {
                ReflectionHelper.makeAccessible(this.constructor);
            }
            String[] componentNames = ReflectionHelper.getRecordComponentNames(raw);
            for (int i = 0; i < componentNames.length; ++i) {
                this.componentIndices.put(componentNames[i], i);
            }
            Class<?>[] parameterTypes = this.constructor.getParameterTypes();
            this.constructorArgsDefaults = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                this.constructorArgsDefaults[i] = PRIMITIVE_DEFAULTS.get(parameterTypes[i]);
            }
        }

        private static Map<Class<?>, Object> primitiveDefaults() {
            HashMap zeroes = new HashMap();
            zeroes.put(Byte.TYPE, (byte)0);
            zeroes.put(Short.TYPE, (short)0);
            zeroes.put(Integer.TYPE, 0);
            zeroes.put(Long.TYPE, 0L);
            zeroes.put(Float.TYPE, Float.valueOf(0.0f));
            zeroes.put(Double.TYPE, 0.0);
            zeroes.put(Character.TYPE, Character.valueOf('\u0000'));
            zeroes.put(Boolean.TYPE, false);
            return zeroes;
        }

        @Override
        Object[] createAccumulator() {
            return (Object[])this.constructorArgsDefaults.clone();
        }

        @Override
        void readField(Object[] accumulator, JsonReader in, BoundField field) throws IOException {
            Integer componentIndex = this.componentIndices.get(field.fieldName);
            if (componentIndex == null) {
                throw new IllegalStateException("Could not find the index in the constructor '" + ReflectionHelper.constructorToString(this.constructor) + "' for field with name '" + field.fieldName + "', unable to determine which argument in the constructor the field corresponds to. This is unexpected behavior, as we expect the RecordComponents to have the same names as the fields in the Java class, and that the order of the RecordComponents is the same as the order of the canonical constructor parameters.");
            }
            field.readIntoArray(in, componentIndex, accumulator);
        }

        @Override
        T finalize(Object[] accumulator) {
            try {
                return this.constructor.newInstance(accumulator);
            }
            catch (IllegalAccessException e) {
                throw ReflectionHelper.createExceptionForUnexpectedIllegalAccess((IllegalAccessException)e);
            }
            catch (IllegalArgumentException | InstantiationException e) {
                throw new RuntimeException("Failed to invoke constructor '" + ReflectionHelper.constructorToString(this.constructor) + "' with args " + Arrays.toString(accumulator), e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Failed to invoke constructor '" + ReflectionHelper.constructorToString(this.constructor) + "' with args " + Arrays.toString(accumulator), e.getCause());
            }
        }
    }

    private static final class FieldReflectionAdapter<T>
    extends Adapter<T, T> {
        FieldReflectionAdapter(Map<String, BoundField> boundFields) {
            super(boundFields);
        }

        @Override
        T createAccumulator() {
            return null;
        }

        @Override
        void readField(T accumulator, JsonReader in, BoundField field) throws IllegalAccessException, IOException {
        }

        @Override
        T finalize(T accumulator) {
            return accumulator;
        }
    }

    static abstract class BoundField {
        final String name;
        final Field field;
        final String fieldName;
        final boolean serialized;
        final boolean deserialized;

        protected BoundField(String name, Field field, boolean serialized, boolean deserialized) {
            this.name = name;
            this.field = field;
            this.fieldName = field.getName();
            this.serialized = serialized;
            this.deserialized = deserialized;
        }

        abstract void write(JsonWriter var1, Object var2) throws IOException, IllegalAccessException;

        abstract void readIntoArray(JsonReader var1, int var2, Object[] var3) throws IOException, JsonParseException;

        abstract void readIntoField(JsonReader var1, Object var2) throws IOException, IllegalAccessException;
    }

    public static abstract class Adapter<T, A>
    extends TypeAdapter<T> {
        final Map<String, BoundField> boundFields;

        Adapter(Map<String, BoundField> boundFields) {
            this.boundFields = boundFields;
        }

        public void write(JsonWriter out, T value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            try {
                for (BoundField boundField : this.boundFields.values()) {
                    boundField.write(out, value);
                }
            }
            catch (IllegalAccessException e) {
                throw ReflectionHelper.createExceptionForUnexpectedIllegalAccess((IllegalAccessException)e);
            }
            out.endObject();
        }

        public T read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            A accumulator = this.createAccumulator();
            try {
                in.beginObject();
                while (in.hasNext()) {
                    String name = in.nextName();
                    BoundField field = this.boundFields.get(name);
                    if (field == null || !field.deserialized) {
                        in.skipValue();
                        continue;
                    }
                    this.readField(accumulator, in, field);
                }
            }
            catch (IllegalStateException e) {
                throw new JsonSyntaxException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw ReflectionHelper.createExceptionForUnexpectedIllegalAccess((IllegalAccessException)e);
            }
            in.endObject();
            return this.finalize(accumulator);
        }

        abstract A createAccumulator();

        abstract void readField(A var1, JsonReader var2, BoundField var3) throws IllegalAccessException, IOException;

        abstract T finalize(A var1);
    }
}

