/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps;

import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.OrderData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.ApiData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.JarGroupData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.BHOrderScreen;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.JarGroupListWidget;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.JarListWidget;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.PlayerCountStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.ProcessStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.SelectPlanTypeStep;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class SelectJarStep
extends ProcessStep {
    private JarGroupListWidget.JarGroupEntry selectedGroup = null;
    private JarListWidget.JarEntry selectedJar = null;
    private final Component nameFilter = Component.translatable((String)"step.select_jar.name_filter");
    private final Component platformFilter = Component.translatable((String)"step.select_jar.platform_filter");
    private final Component selectPack = Component.translatable((String)"step.select_jar.select_pack");
    private JarGroupListWidget jarGroupList;
    private JarListWidget jarList;
    private EditBox searchBar;
    private Button selectButton;

    public SelectJarStep(OrderData orderData) {
        super(orderData);
        orderData.jar = null;
    }

    @Override
    public void init(BHOrderScreen screen, Consumer<GuiEventListener> children) {
        int y0 = 80;
        int height = screen.height - y0 - 80;
        List<JarGroupData> jarGroupIds = ApiData.AVAILABLE_GROUPS.values().stream().sorted().filter(group -> !group.ignore).collect(Collectors.toList());
        this.jarGroupList = new JarGroupListWidget(this, screen.getMinecraft(), screen.width / 3, height, y0 + 44, jarGroupIds);
        this.jarGroupList.setX(6);
        this.jarList = new JarListWidget(this, screen.getMinecraft(), screen.width - this.jarGroupList.getWidth() - this.jarGroupList.getX() - 16, height, y0);
        this.jarList.setX(this.jarGroupList.getX() + this.jarGroupList.getWidth() + 10);
        this.searchBar = new EditBox(screen.getMinecraft().font, this.jarGroupList.getX(), this.jarGroupList.getY() - 43, this.jarGroupList.getWidth(), 15, this.searchBar, (Component)Component.literal((String)""));
        this.searchBar.setResponder(s -> this.filterJars());
        this.selectButton = Button.builder((Component)Component.translatable((String)"step.select_jar.select"), b -> screen.setStep(new SelectPlanTypeStep(this.orderData))).pos(this.jarList.getX() + (this.jarList.getWidth() - 150) / 2, this.jarList.getY() + this.jarGroupList.getHeight() + 7).build();
        children.accept((GuiEventListener)this.jarGroupList);
        children.accept((GuiEventListener)this.jarList);
        children.accept((GuiEventListener)this.searchBar);
        children.accept((GuiEventListener)this.selectButton);
        this.filterJars();
        super.init(screen, children);
    }

    @Override
    public void tick(BHOrderScreen screen) {
        this.jarGroupList.setSelected((AbstractSelectionList.Entry)this.selectedGroup);
        this.jarList.setSelected((AbstractSelectionList.Entry)this.selectedJar);
        this.selectButton.active = this.orderData.jar != null;
    }

    public void setSelectedGroup(@Nullable JarGroupListWidget.JarGroupEntry selectedGroup) {
        this.selectedGroup = selectedGroup == this.selectedGroup ? null : selectedGroup;
        this.filterJars();
    }

    public void setSelectedJar(@Nullable JarListWidget.JarEntry selectedJar) {
        this.selectedJar = selectedJar == this.selectedJar ? null : selectedJar;
        this.orderData.jar = this.selectedJar == null ? null : selectedJar.data;
    }

    public void filterJars() {
        this.jarList.setScrollAmount(0.0);
        Stream<JarGroupData.JarData> jarStream = ApiData.AVAILABLE_JARS.values().stream().sorted();
        if (this.selectedGroup != null) {
            jarStream = jarStream.filter(jar -> this.selectedGroup.data.premiumJars.containsKey(jar.premiumJarId));
        }
        if (!this.searchBar.getValue().isEmpty()) {
            jarStream = jarStream.filter(jar -> jar.name.toLowerCase(Locale.ROOT).contains(this.searchBar.getValue().toLowerCase(Locale.ROOT)));
        }
        List<JarGroupData.JarData> jars = jarStream.collect(Collectors.toList());
        this.jarList.buildJarList(jars);
        this.setSelectedJar((JarListWidget.JarEntry)this.jarList.getSelected());
    }

    @Override
    public void renderLast(BHOrderScreen screen, Font font, GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderLast(screen, font, graphics, mouseX, mouseY, partialTicks);
        graphics.drawString(font, this.nameFilter, this.searchBar.getX() + (this.searchBar.getWidth() - font.width((FormattedText)this.nameFilter)) / 2, this.searchBar.getY() - 15, 0xFFFFFF);
        graphics.drawString(font, this.platformFilter, this.jarGroupList.getX() + (this.jarGroupList.getWidth() - font.width((FormattedText)this.platformFilter)) / 2, this.jarGroupList.getY() - 15, 0xFFFFFF);
        graphics.drawString(font, this.selectPack, this.jarList.getX() + (this.jarList.getWidth() - font.width((FormattedText)this.selectPack)) / 2, this.jarList.getY() - 15, 0xFFFFFF);
    }

    @Override
    public void onClose(BHOrderScreen screen) {
        if (!this.searchBar.getValue().isEmpty()) {
            this.searchBar.setValue("");
        } else if (this.selectedGroup != null) {
            this.selectedGroup = null;
        } else {
            screen.setStep(new PlayerCountStep(this.orderData));
        }
    }
}

