/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.automessage.neocommon.capability;

import neoforge.com.cursee.automessage.config.Config;
import neoforge.com.cursee.automessage.neonetwork.Networking;
import neoforge.com.cursee.automessage.neonetwork.messages.MessageSyncAutoMessageSettings;
import neoforge.com.cursee.automessage.neoregistry.AutoMessageDataStorage;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class AutoMessageProperties
implements INBTSerializable<CompoundTag> {
    public int playtime = 0;
    public long[] soft_counts = new long[Config.messages.size()];
    public long[] hard_counts = new long[Config.messages.size()];

    public void clone(AutoMessageProperties settings) {
        this.playtime = settings.playtime;
        this.soft_counts = settings.soft_counts;
        this.hard_counts = settings.hard_counts;
    }

    public void sync(ServerPlayer player) {
        Networking.sendTo(player, new MessageSyncAutoMessageSettings(this.playtime, this.soft_counts, this.hard_counts));
    }

    public static void syncFor(ServerPlayer player) {
        ((AutoMessageProperties)player.getData(AutoMessageDataStorage.PROPERTIES)).sync(player);
    }

    public void incrementPlaytime() {
        ++this.playtime;
    }

    public int getPlaytime() {
        return this.playtime;
    }

    public long[] getSoftCounts() {
        return this.soft_counts;
    }

    public long[] getHardCounts() {
        return this.hard_counts;
    }

    public void incrementSoftCountAtIndex(int index) {
        int n = index;
        this.soft_counts[n] = this.soft_counts[n] + 1L;
    }

    public void incrementHardCountAtIndex(int index) {
        int n = index;
        this.hard_counts[n] = this.hard_counts[n] + 1L;
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("playtime", this.playtime);
        nbt.putLongArray("soft_counts", this.soft_counts);
        nbt.putLongArray("hard_counts", this.hard_counts);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.playtime = nbt.getInt("playtime");
        this.soft_counts = nbt.getLongArray("soft_counts");
        this.hard_counts = nbt.getLongArray("hard_counts");
    }
}

