/*
 * Decompiled with CFR 0.152.
 */
package com.structureessentials.mixin;

import com.structureessentials.IGeneratorNearbyStructureHolder;
import com.structureessentials.StructureEssentials;
import com.structureessentials.config.CommonConfiguration;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Structure.class})
public abstract class StructureStartMinDistMixin {
    @Shadow
    public abstract Structure.StructureSettings getModifiedStructureSettings();

    @Inject(method={"generate"}, at={@At(value="RETURN")}, cancellable=true)
    private void checkOtherStructuresNearby(RegistryAccess registryAccess, ChunkGenerator generator, BiomeSource biomeSource, RandomState p_226600_, StructureTemplateManager p_226601_, long p_226602_, ChunkPos p_226603_, int p_226604_, LevelHeightAccessor p_226605_, Predicate<Holder<Biome>> p_226606_, CallbackInfoReturnable<StructureStart> cir) {
        if (cir.getReturnValue() == StructureStart.INVALID_START || !((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).minimumStructureDistanceEnabled) {
            return;
        }
        if (!(generator instanceof IGeneratorNearbyStructureHolder)) {
            if (((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).minimumStructureDistanceLogging) {
                StructureEssentials.LOGGER.warn("Skipping structure minimum distance check, invalid generator: " + String.valueOf(generator));
            }
            return;
        }
        IGeneratorNearbyStructureHolder nearbyStructureHolder = (IGeneratorNearbyStructureHolder)generator;
        int distance = ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).minimumStructureDistance;
        int xzOffset = 3000000 * distance;
        int yOffset = this.getModifiedStructureSettings().step() == GenerationStep.Decoration.SURFACE_STRUCTURES ? 2000 : 500;
        for (StructurePiece piece : ((StructureStart)cir.getReturnValue()).getPieces()) {
            BlockPos center = piece.getLocatorPosition();
            String nearby = nearbyStructureHolder.getNearby(BlockPos.asLong((int)((center.getX() + xzOffset) / distance), (int)((center.getY() + yOffset) / distance), (int)((center.getZ() + xzOffset) / distance)));
            if (nearby == null && (piece.getBoundingBox().getXSpan() > 8 || piece.getBoundingBox().getYSpan() > 8 || piece.getBoundingBox().getZSpan() > 8)) {
                BlockPos pos;
                Iterator<BlockPos> iterator = StructureStartMinDistMixin.getBoundingBoxCorners(piece.getBoundingBox()).iterator();
                while (iterator.hasNext() && (nearby = nearbyStructureHolder.getNearby(BlockPos.asLong((int)(((pos = iterator.next()).getX() + xzOffset) / distance), (int)((pos.getY() + yOffset) / distance), (int)((pos.getZ() + xzOffset) / distance)))) == null) {
                }
            }
            if (nearby == null) continue;
            if (((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).minimumStructureDistanceLogging) {
                StructureEssentials.LOGGER.warn("Prevented structure overlap for: " + String.valueOf(((Registry)registryAccess.registry(Registries.STRUCTURE).get()).getKey((Object)((Structure)this))) + " at: " + String.valueOf(center) + " existing structure: " + nearby);
            }
            cir.setReturnValue((Object)StructureStart.INVALID_START);
            return;
        }
        ResourceLocation regID = ((Registry)registryAccess.registry(Registries.STRUCTURE).get()).getKey((Object)((Structure)this));
        Object name = regID != null ? regID.toString() : "unknown:" + String.valueOf(this);
        for (StructurePiece piece : ((StructureStart)cir.getReturnValue()).getPieces()) {
            BlockPos center = piece.getLocatorPosition();
            nearbyStructureHolder.setNearby(BlockPos.asLong((int)((center.getX() + xzOffset) / distance), (int)((center.getY() + 2000) / distance), (int)((center.getZ() + xzOffset) / distance)), (String)name);
            if (piece.getBoundingBox().getXSpan() <= 8 && piece.getBoundingBox().getYSpan() <= 8 && piece.getBoundingBox().getZSpan() <= 8) continue;
            for (BlockPos pos : StructureStartMinDistMixin.getBoundingBoxCorners(piece.getBoundingBox())) {
                nearbyStructureHolder.setNearby(BlockPos.asLong((int)((pos.getX() + xzOffset) / distance), (int)((pos.getY() + 2000) / distance), (int)((pos.getZ() + xzOffset) / distance)), (String)name);
            }
        }
    }

    @Unique
    private static List<BlockPos> getBoundingBoxCorners(BoundingBox box) {
        return List.of(new BlockPos(box.minX(), box.minY(), box.minZ()), new BlockPos(box.minX(), box.minY(), box.maxZ()), new BlockPos(box.minX(), box.maxY(), box.minZ()), new BlockPos(box.minX(), box.maxY(), box.maxZ()), new BlockPos(box.maxX(), box.minY(), box.minZ()), new BlockPos(box.maxX(), box.minY(), box.maxZ()), new BlockPos(box.maxX(), box.maxY(), box.minZ()), new BlockPos(box.maxX(), box.maxY(), box.maxZ()));
    }
}

