/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.elementalmaces.items;

import dev.foxgirl.elementalmaces.items.AbstractElementalMaceItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;

public class WitheringMaceItem
extends AbstractElementalMaceItem {
    public WitheringMaceItem() {
        super(properties -> properties.component(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"item.elementalmaces.withering_mace").withStyle(ChatFormatting.DARK_GRAY)).component(DataComponents.LORE, (Object)ItemLore.EMPTY.withLineAdded((Component)Component.translatable((String)"item.elementalmaces.withering_mace.lore.line1")).withLineAdded((Component)Component.translatable((String)"item.elementalmaces.withering_mace.lore.line2"))), attributes -> attributes.withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 8.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)-3.4f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
    }

    @Override
    protected void onTick(ItemStack stack, ServerPlayer player, int slot, boolean isSelected, boolean isInHands) {
        if (isSelected || isInHands) {
            player.removeEffect(MobEffects.WITHER);
        }
    }

    @Override
    protected boolean onSmashAttack(ItemStack stack, ServerPlayer player, LivingEntity target) {
        WitheringMaceItem.getNearbyTargets(player, target, 4.0).forEach(entity -> entity.addEffect(new MobEffectInstance(MobEffects.WITHER, 160, 1)));
        AreaEffectCloud effectCloud = new AreaEffectCloud(player.level(), player.getX(), target.getY(), player.getZ());
        effectCloud.setOwner((LivingEntity)player);
        effectCloud.setRadius(4.0f);
        effectCloud.setRadiusOnUse(-0.5f);
        effectCloud.setWaitTime(0);
        effectCloud.setDuration(100);
        effectCloud.setRadiusPerTick(0.0f);
        effectCloud.addEffect(new MobEffectInstance(MobEffects.WITHER, 160, 1));
        player.level().addFreshEntity((Entity)effectCloud);
        player.level().playSound(null, player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ(), SoundEvents.WITHER_AMBIENT, SoundSource.PLAYERS, 3.0f, 1.0f);
        return true;
    }
}

