/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.elementalmaces.items;

import dev.foxgirl.elementalmaces.items.AbstractElementalMaceItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.block.Blocks;

public class SmoulderingMaceItem
extends AbstractElementalMaceItem {
    public SmoulderingMaceItem() {
        super(properties -> properties.component(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"item.elementalmaces.smouldering_mace").withStyle(ChatFormatting.RED)).component(DataComponents.LORE, (Object)ItemLore.EMPTY.withLineAdded((Component)Component.translatable((String)"item.elementalmaces.smouldering_mace.lore.line1")).withLineAdded((Component)Component.translatable((String)"item.elementalmaces.smouldering_mace.lore.line2"))), attributes -> attributes.withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 2.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)-3.4f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
    }

    @Override
    protected void onTick(ItemStack stack, ServerPlayer player, int slot, boolean isSelected, boolean isInHands) {
        if (isSelected || isInHands) {
            player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 70));
        }
    }

    @Override
    protected boolean onSmashAttack(ItemStack stack, ServerPlayer player, LivingEntity target) {
        SmoulderingMaceItem.getNearbyTargets(player, target, 4.0).forEach(entity -> entity.igniteForSeconds(5.0f));
        BlockPos playerPos = player.blockPosition();
        for (int x = playerPos.getX() - 5; x <= playerPos.getX() + 5; ++x) {
            block1: for (int z = playerPos.getZ() - 5; z <= playerPos.getZ() + 5; ++z) {
                if (player.distanceToSqr((double)x + 0.5, player.getY(), (double)z + 0.5) > 12.25) continue;
                for (int y = playerPos.getY() + 5; y >= playerPos.getY() - 10; --y) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    if (!player.level().getBlockState(blockPos).isAir() || !player.level().getBlockState(blockPos.below()).isSolid()) continue;
                    player.level().setBlockAndUpdate(blockPos, Blocks.FIRE.defaultBlockState());
                    continue block1;
                }
            }
        }
        player.level().playSound(null, player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ(), SoundEvents.BLAZE_AMBIENT, SoundSource.PLAYERS, 3.0f, 1.0f);
        return true;
    }
}

