/*
 * Decompiled with CFR 0.152.
 */
package com.leaky.mixin;

import com.leaky.INearbyItemAwareEntity;
import com.leaky.Leaky;
import com.leaky.config.CommonConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class}, priority=999)
public abstract class ItemUpdateMixin
extends Entity
implements INearbyItemAwareEntity {
    @Shadow
    private int age;
    @Unique
    private int updateRate = 1;
    @Unique
    private int nearbyItems = 0;
    @Unique
    private boolean waterState = false;
    @Unique
    private Player closePlayer = null;
    @Unique
    private BlockPos previousPos = null;
    @Unique
    private int delay = 0;

    public ItemUpdateMixin(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;noCollision(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;)Z"), require=0)
    private boolean checkCollisions(Level instance, Entity entity, AABB aabb) {
        if (this.tickCount < 100 || (this.tickCount + this.getId()) % this.updateRate == 0) {
            return this.level().noCollision((Entity)this, this.getBoundingBox().deflate(1.0E-7));
        }
        return !this.noPhysics;
    }

    @ModifyConstant(method={"tick"}, constant={@Constant(intValue=4, ordinal=0)})
    private int adaptUpdates(int constant) {
        return constant + this.updateRate;
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        if (this.tickCount < 20 || (this.tickCount + this.getId()) % this.updateRate == 0) {
            this.waterState = super.updateInWaterStateAndDoFluidPushing();
            return this.waterState;
        }
        return this.waterState;
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void checkRate(CallbackInfo ci) {
        if (this.tickCount <= 1) {
            this.closePlayer = this.level().getNearestPlayer((Entity)this, 32.0);
        }
        if ((this.tickCount + this.getId()) % 20 == 0) {
            this.calculateUpdateRate();
        }
    }

    @Inject(method={"playerTouch"}, at={@At(value="HEAD")})
    private void onInteract(Player p_32040_, CallbackInfo ci) {
        this.updateRate = 1;
        this.delay = 300;
    }

    @Unique
    private void calculateUpdateRate() {
        this.updateRate = 1;
        if (this.tickCount < 300) {
            return;
        }
        if (this.delay > 0) {
            this.delay -= 20;
            return;
        }
        if (!((CommonConfiguration)Leaky.config.getCommonConfig()).improveItemPerformance) {
            return;
        }
        this.updateRate = (int)((double)this.updateRate + (double)this.tickCount / 200.0);
        if (this.closePlayer != null && this.closePlayer.blockPosition().distSqr((Vec3i)this.blockPosition()) > 1024.0) {
            this.updateRate += 5;
            this.age += 5;
        }
        if (this.nearbyItems > 0) {
            this.updateRate += this.nearbyItems / 10;
            this.age += this.nearbyItems / 15;
        }
        if (this.previousPos != null && this.previousPos != this.blockPosition() && !this.previousPos.equals((Object)this.blockPosition())) {
            this.updateRate = 1;
            this.delay = 300;
        }
        this.previousPos = this.blockPosition();
    }

    @Override
    public int getNearbyItems() {
        return this.nearbyItems;
    }

    @Override
    public void setNearbyItems(int items) {
        this.nearbyItems = Math.max(this.nearbyItems, items);
    }
}

