/*
 * Decompiled with CFR 0.152.
 */
package com.leaky;

import com.cupboard.config.CupboardConfig;
import com.cupboard.config.ICommonConfig;
import com.leaky.INearbyItemAwareEntity;
import com.leaky.config.CommonConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="leaky")
public class Leaky {
    public static final String MODID = "leaky";
    public static final Logger LOGGER = LogManager.getLogger();
    public static CupboardConfig<CommonConfiguration> config = new CupboardConfig("leaky", (ICommonConfig)new CommonConfiguration());
    public static Random rand = new Random();
    private static Map<BlockPos, Long> reportedLocations = new HashMap<BlockPos, Long>();

    public Leaky(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        config.load();
        LOGGER.info("leaky mod initialized");
    }

    public static void detectedItemLeak(ItemEntity entity, List<ItemEntity> items, int range) {
        int size = items.size();
        for (ItemEntity itemEntity : items) {
            if (!(itemEntity instanceof INearbyItemAwareEntity)) continue;
            INearbyItemAwareEntity nearbyItemAware = (INearbyItemAwareEntity)itemEntity;
            nearbyItemAware.setNearbyItems(size);
        }
        if (range > 2) {
            size /= 2;
        }
        if (size < ((CommonConfiguration)Leaky.config.getCommonConfig()).reportThreshold) {
            return;
        }
        for (Map.Entry entry : reportedLocations.entrySet()) {
            if (!(((BlockPos)entry.getKey()).distSqr((Vec3i)entity.blockPosition()) < 100.0) || entity.level().getGameTime() - (Long)entry.getValue() >= (long)(((CommonConfiguration)Leaky.config.getCommonConfig()).reportInterval * 20)) continue;
            return;
        }
        reportedLocations.put(entity.blockPosition(), entity.level().getGameTime());
        MutableComponent component = Component.literal((String)("Detected: " + items.size() + " stacked items at:")).append((Component)Component.literal((String)("[" + entity.blockPosition().toShortString() + "]")).withStyle(ChatFormatting.YELLOW).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + entity.getBlockX() + " " + entity.getBlockY() + " " + entity.getBlockZ())))).append((Component)Component.literal((String)(" in " + entity.level().dimension().location().toString())));
        if (size > ((CommonConfiguration)Leaky.config.getCommonConfig()).autoremovethreshold && items.get(0).getAge() > 600) {
            component.append((Component)Component.literal((String)". Cleaned items automatically to prevent lag"));
            items.forEach(Entity::discard);
        }
        if (((CommonConfiguration)Leaky.config.getCommonConfig()).chatnotification.equalsIgnoreCase("PLAYER")) {
            double d = Double.MAX_VALUE;
            Player closest = null;
            for (Player player : entity.level().players()) {
                if (!(player.position().distanceTo(entity.position()) < d)) continue;
                d = player.position().distanceTo(entity.position());
                closest = player;
            }
            if (closest != null) {
                closest.sendSystemMessage((Component)component);
            }
        } else if (((CommonConfiguration)Leaky.config.getCommonConfig()).chatnotification.equalsIgnoreCase("EVERYONE")) {
            for (Player player : entity.level().getServer().getPlayerList().getPlayers()) {
                player.sendSystemMessage((Component)component);
            }
        } else {
            component.append((Component)Component.literal((String)(" Chatnotification mode:NONE(" + ((CommonConfiguration)Leaky.config.getCommonConfig()).chatnotification + ")")));
        }
        LOGGER.warn(component.getString());
    }
}

