/*
 * Decompiled with CFR 0.152.
 */
package com.betterfpsdist.event;

import com.betterfpsdist.BetterfpsdistMod;
import com.betterfpsdist.config.CommonConfiguration;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;

public class ClientEventHandler {
    public static final OptionInstance<Double> chunkrenderdist = new OptionInstance("options.verticalstretch", OptionInstance.noTooltip(), ClientEventHandler::percentValueLabel, (OptionInstance.ValueSet)new OptionInstance.IntRange(2, 40).xmap(value -> (double)value / 4.0, value -> (int)(value * 4.0)), Codec.doubleRange((double)0.5, (double)5.0), (Object)1.0, value -> {
        ((CommonConfiguration)BetterfpsdistMod.config.getCommonConfig()).verticalScaling = value;
        BetterfpsdistMod.config.save();
    });
    public static final OptionInstance<Double> chunkrenderdistxz = new OptionInstance("options.horizontalstretch", OptionInstance.noTooltip(), ClientEventHandler::percentValueLabel, (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 100).xmap(value -> (double)value / 100.0, value -> (int)(value * 100.0)), Codec.doubleRange((double)0.0, (double)100.0), (Object)1.0, value -> {
        ((CommonConfiguration)BetterfpsdistMod.config.getCommonConfig()).horizontalScaling = 1.0 + value;
        BetterfpsdistMod.config.save();
    });
    public static float xStretch;
    public static float yStretch;
    public static float cosAngle;
    public static float sinAngle;
    public static int maxSqDist;
    public static HashSet<BlockPos> hiddenSections;
    public static long nextUpdate;

    private static void onClientTick(ClientTickEvent.Post event) {
        if (Minecraft.getInstance().player == null) {
            xStretch = 1.0f;
            yStretch = 1.0f;
            return;
        }
        cosAngle = (float)Math.cos((double)(-Minecraft.getInstance().player.getViewYRot(1.0f)) * (Math.PI / 180));
        sinAngle = (float)Math.sin((double)(-Minecraft.getInstance().player.getViewYRot(1.0f)) * (Math.PI / 180));
        xStretch = (float)(((CommonConfiguration)BetterfpsdistMod.config.getCommonConfig()).horizontalScaling * ((CommonConfiguration)BetterfpsdistMod.config.getCommonConfig()).horizontalScaling);
        yStretch = (float)(((CommonConfiguration)BetterfpsdistMod.config.getCommonConfig()).verticalScaling * ((CommonConfiguration)BetterfpsdistMod.config.getCommonConfig()).verticalScaling);
        maxSqDist = (Integer)Minecraft.getInstance().options.renderDistance().get() * 16 * ((Integer)Minecraft.getInstance().options.renderDistance().get() * 16) + 1;
        if (((CommonConfiguration)BetterfpsdistMod.config.getCommonConfig()).debugMode && Minecraft.getInstance().player.level().getGameTime() > nextUpdate) {
            nextUpdate = Minecraft.getInstance().player.level().getGameTime() + 40L;
            BetterfpsdistMod.LOGGER.warn("Hidden Sections:" + hiddenSections.size());
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)("Hidden chunk sections:" + hiddenSections.size())), true);
        }
        hiddenSections.clear();
    }

    public static double adjustedDistance(BlockPos from, BlockPos to) {
        return ClientEventHandler.adjustedDistance(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ());
    }

    public static double adjustedDistance(int x1, int y1, int z1, double x2, double y2, double z2) {
        double x2New = (x2 - (double)x1) * (double)cosAngle - (z2 - (double)z1) * (double)sinAngle + (double)x1;
        double z2New = (x2 - (double)x1) * (double)sinAngle + (z2 - (double)z1) * (double)cosAngle + (double)z1;
        double d0 = (double)x1 - x2New;
        double d1 = (double)y1 - y2;
        double d2 = (double)z1 - z2New;
        return (double)xStretch * d0 * d0 + (double)yStretch * (d1 * d1) + d2 * d2;
    }

    private static Component percentValueLabel(Component p_231898_, double p_231899_) {
        return Component.translatable((String)"options.percent_value", (Object[])new Object[]{p_231898_, (int)(p_231899_ * 100.0)});
    }

    static {
        NeoForge.EVENT_BUS.addListener(ClientEventHandler::onClientTick);
        chunkrenderdist.set((Object)((CommonConfiguration)BetterfpsdistMod.config.getCommonConfig()).verticalScaling);
        chunkrenderdistxz.set((Object)(((CommonConfiguration)BetterfpsdistMod.config.getCommonConfig()).horizontalScaling - 1.0));
        xStretch = 1.0f;
        yStretch = 1.0f;
        cosAngle = 1.0f;
        sinAngle = 1.0f;
        maxSqDist = 0;
        hiddenSections = new HashSet();
        nextUpdate = 0L;
    }
}

