/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.joml.Matrix4f;

public class TickableTextList {
    protected final Font font;
    protected final List<TickableText> texts;
    protected int ticks;
    protected int maxWidth;
    protected int lineSpacing;
    protected int width = 0;

    public TickableTextList(Font font, int maxWidth) {
        this.font = font;
        this.texts = new ArrayList<TickableText>();
        this.ticks = 0;
        this.maxWidth = maxWidth;
        Objects.requireNonNull(font);
        this.lineSpacing = 9 + 3;
    }

    public void addLine(FormattedText text, float tickRate) {
        this.texts.add(new TickableText(text, Math.max(0.01f, tickRate)));
        this.width = this.computeWidth();
    }

    public void addLine(FormattedText text) {
        this.addLine(text, 1.0f);
    }

    public void continueLine(FormattedText text, float tickRate) {
        if (this.texts.isEmpty()) {
            this.addLine(text, tickRate);
        } else {
            TickableText last = this.texts.removeLast();
            this.addLine(FormattedText.composite((FormattedText[])new FormattedText[]{last.text, text}), tickRate);
        }
    }

    public void setLine(int index, FormattedText text, float tickRate) {
        this.texts.set(index, new TickableText(text, Math.max(0.01f, tickRate)));
        this.width = this.computeWidth();
    }

    public void render(float x, float y, int color, boolean dropShadow, Matrix4f matrix, MultiBufferSource buffer, Font.DisplayMode mode, int bgColor, int packedLight) {
        int line = 0;
        MutableFloat timeLeft = new MutableFloat((float)this.ticks);
        for (TickableText tickable : this.texts) {
            for (FormattedCharSequence seq : this.font.split(tickable.text, this.maxWidth)) {
                seq = this.wrap(seq, tickable.tickRate, timeLeft);
                this.font.drawInBatch(seq, x, y + (float)(this.lineSpacing * line), color, dropShadow, matrix, buffer, mode, bgColor, packedLight);
                ++line;
            }
        }
    }

    public void render(GuiGraphics gfx, float x, float y, int color, boolean dropShadow) {
        this.render(x, y, color, dropShadow, gfx.pose().last().pose(), (MultiBufferSource)gfx.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public void render(GuiGraphics gfx, float x, float y) {
        this.render(gfx, x, y, -1, false);
    }

    public void clear() {
        this.texts.clear();
        this.ticks = 0;
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public void tick() {
        ++this.ticks;
    }

    public int getWidth() {
        return this.width;
    }

    private FormattedCharSequence wrap(FormattedCharSequence text, float tickRate, MutableFloat timeLeft) {
        return sink -> text.accept((FormattedCharSink)new TimeLimitedCharSink(this, sink, tickRate, timeLeft));
    }

    private int computeWidth() {
        int width = 0;
        for (TickableText text : this.texts) {
            width = Math.clamp((long)this.font.width(text.text), width, this.maxWidth);
        }
        return width;
    }

    private record TickableText(FormattedText text, float tickRate) {
    }

    private class TimeLimitedCharSink
    implements FormattedCharSink {
        private final FormattedCharSink wrapped;
        private final float tickRate;
        private final MutableFloat timeLeft;

        public TimeLimitedCharSink(TickableTextList tickableTextList, FormattedCharSink wrapped, float tickRate, MutableFloat timeLeft) {
            this.wrapped = wrapped;
            this.tickRate = tickRate;
            this.timeLeft = timeLeft;
        }

        public boolean accept(int positionInCurrentSequence, Style style, int codePoint) {
            this.timeLeft.subtract(1.0f / this.tickRate);
            if (this.timeLeft.getValue().floatValue() >= 0.0f) {
                this.wrapped.accept(positionInCurrentSequence, style, codePoint);
                return true;
            }
            return false;
        }
    }
}

