/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.registry;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.block_entity.TickingBlockEntityType;
import dev.shadowsoffire.placebo.menu.MenuUtil;
import dev.shadowsoffire.placebo.util.DeferredSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import org.jetbrains.annotations.ApiStatus;

public class DeferredHelper {
    protected static final ResourceKey<? extends Registry<?>> ROOT_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)Registries.ROOT_REGISTRY_NAME);
    protected static final ResourceKey<Registry<DataMapType<?, ?>>> DATA_MAP_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"data_map_type"));
    protected final String modid;
    protected final Map<ResourceKey<? extends Registry<?>>, List<Registrar<?>>> objects;
    protected final Map<ResourceKey<? extends Registry<?>>, List<Holder<?>>> resolvedObjects;

    public static DeferredHelper create(String modid) {
        return new DeferredHelper(modid);
    }

    protected DeferredHelper(String modid) {
        this.modid = modid;
        this.objects = new IdentityHashMap();
        this.resolvedObjects = new IdentityHashMap();
    }

    public <T> Registry<T> registry(String registryPath, UnaryOperator<RegistryBuilder<T>> config) {
        ResourceKey registryKey = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)registryPath));
        Registry registry = ((RegistryBuilder)config.apply(new RegistryBuilder(registryKey))).create();
        this.registerRegistry(registryKey, registry);
        return registry;
    }

    public <T extends Block> DeferredBlock<T> block(String path, Supplier<T> factory) {
        this.register(path, Registries.BLOCK, factory);
        return DeferredBlock.createBlock((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path));
    }

    public <T extends Block> DeferredBlock<T> block(String path, Function<BlockBehaviour.Properties, T> ctor, UnaryOperator<BlockBehaviour.Properties> properties) {
        return this.block(path, () -> (Block)ctor.apply((BlockBehaviour.Properties)properties.apply(BlockBehaviour.Properties.of())));
    }

    public <T extends Fluid> DeferredHolder<Fluid, T> fluid(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.FLUID, factory);
    }

    public <T extends Item> DeferredItem<T> item(String path, Supplier<T> factory) {
        this.register(path, Registries.ITEM, factory);
        return DeferredItem.createItem((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path));
    }

    public <T extends Item> DeferredItem<T> item(String path, Function<Item.Properties, T> ctor, UnaryOperator<Item.Properties> properties) {
        return this.item(path, () -> (Item)ctor.apply((Item.Properties)properties.apply(new Item.Properties())));
    }

    public <T extends Item> DeferredItem<T> item(String path, Function<Item.Properties, T> ctor) {
        return this.item(path, ctor, UnaryOperator.identity());
    }

    public <T extends BlockItem> DeferredItem<T> blockItem(String path, Holder<Block> block, BiFunction<Block, Item.Properties, T> ctor, UnaryOperator<Item.Properties> properties) {
        return this.item(path, () -> (BlockItem)ctor.apply((Block)block.value(), (Item.Properties)properties.apply(new Item.Properties())));
    }

    public DeferredItem<BlockItem> blockItem(String path, Holder<Block> block, UnaryOperator<Item.Properties> properties) {
        return this.blockItem(path, block, BlockItem::new, properties);
    }

    public DeferredItem<BlockItem> blockItem(String path, Holder<Block> block) {
        return this.blockItem(path, block, UnaryOperator.identity());
    }

    public <T extends MobEffect> DeferredHolder<MobEffect, T> effect(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.MOB_EFFECT, factory);
    }

    public <T extends SoundEvent> DeferredHolder<SoundEvent, T> sound(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.SOUND_EVENT, factory);
    }

    public Holder<SoundEvent> sound(String path) {
        return this.sound(path, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path)));
    }

    public <T extends Potion> DeferredHolder<Potion, T> potion(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.POTION, factory);
    }

    public DeferredHolder<Potion, Potion> singlePotion(String path, Supplier<MobEffectInstance> factory) {
        return this.registerDH(path, Registries.POTION, () -> {
            MobEffectInstance inst = (MobEffectInstance)factory.get();
            ResourceLocation key = inst.getEffect().getKey().location();
            return new Potion(key.toLanguageKey(), new MobEffectInstance[]{inst});
        });
    }

    public DeferredHolder<Potion, Potion> multiPotion(String path, Supplier<List<MobEffectInstance>> factory) {
        String key = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path).toLanguageKey("potion");
        return this.registerDH(path, Registries.POTION, () -> new Potion(key, ((List)factory.get()).toArray(new MobEffectInstance[0])));
    }

    public <U extends Entity, T extends EntityType<U>> DeferredHolder<EntityType<?>, T> entity(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.ENTITY_TYPE, factory);
    }

    public <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> entity(String path, EntityType.EntityFactory<T> factory, MobCategory category, UnaryOperator<EntityType.Builder<T>> op) {
        String key = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path).toLanguageKey("entity");
        return this.entity(path, () -> ((EntityType.Builder)op.apply(EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)category))).build(key));
    }

    public <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> blockEntity(String path, BlockEntityType.BlockEntitySupplier<T> factory, Supplier<Set<Block>> validBlocks) {
        return this.registerDH(path, Registries.BLOCK_ENTITY_TYPE, () -> new BlockEntityType(factory, (Set)validBlocks.get(), null));
    }

    @SafeVarargs
    public final <T extends BlockEntity> BlockEntityType<T> blockEntity(String path, BlockEntityType.BlockEntitySupplier<T> factory, Holder<Block> ... validBlocks) {
        DeferredHelper.unfreezeBETypeRegistry();
        BlockEntityType type = new BlockEntityType(factory, new DeferredSet(() -> Arrays.stream(validBlocks).map(Holder::value).collect(Collectors.toSet())), null);
        this.register(path, Registries.BLOCK_ENTITY_TYPE, () -> {
            type.getValidBlocks();
            return type;
        });
        return type;
    }

    @SafeVarargs
    public final <T extends BlockEntity> TickingBlockEntityType<T> tickingBlockEntity(String path, BlockEntityType.BlockEntitySupplier<T> factory, TickingBlockEntityType.TickSide side, Holder<Block> ... validBlocks) {
        DeferredHelper.unfreezeBETypeRegistry();
        TickingBlockEntityType type = new TickingBlockEntityType(factory, new DeferredSet<Block>(() -> Arrays.stream(validBlocks).map(Holder::value).collect(Collectors.toSet())), side);
        this.register(path, Registries.BLOCK_ENTITY_TYPE, () -> {
            type.getValidBlocks();
            return type;
        });
        return type;
    }

    public <U extends ParticleOptions, T extends ParticleType<U>> DeferredHolder<ParticleType<?>, T> particle(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.PARTICLE_TYPE, factory);
    }

    public DeferredHolder<ParticleType<?>, SimpleParticleType> simpleParticle(String path, boolean overrideLimit) {
        return this.particle(path, () -> new SimpleParticleType(overrideLimit));
    }

    public <T extends ParticleOptions> DeferredHolder<ParticleType<?>, ParticleType<T>> particle(String path, boolean overrideLimit, final Function<ParticleType<T>, MapCodec<T>> codec, final Function<ParticleType<T>, StreamCodec<? super RegistryFriendlyByteBuf, T>> streamCodec) {
        return this.particle(path, () -> new ParticleType<T>(this, overrideLimit){

            public MapCodec<T> codec() {
                return (MapCodec)codec.apply(this);
            }

            public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec() {
                return (StreamCodec)streamCodec.apply(this);
            }
        });
    }

    public <U extends AbstractContainerMenu, T extends MenuType<U>> T menuType(String path, T type) {
        this.register(path, Registries.MENU, () -> type);
        return type;
    }

    public <T extends AbstractContainerMenu> MenuType<T> menu(String path, MenuType.MenuSupplier<T> factory) {
        return this.menuType(path, MenuUtil.type(factory));
    }

    public <T extends AbstractContainerMenu> MenuType<T> menuWithPos(String path, MenuUtil.PosFactory<T> factory) {
        return this.menuType(path, MenuUtil.posType(factory));
    }

    public <T extends AbstractContainerMenu> MenuType<T> menuWithData(String path, IContainerFactory<T> factory) {
        return this.menuType(path, MenuUtil.bufType(factory));
    }

    public <C extends RecipeInput, U extends Recipe<C>, T extends RecipeType<U>> DeferredHolder<RecipeType<?>, T> recipe(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.RECIPE_TYPE, factory);
    }

    public <C extends RecipeInput, U extends Recipe<C>> RecipeType<U> recipe(String path) {
        RecipeType type = RecipeType.simple((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path));
        this.recipe(path, () -> type);
        return type;
    }

    public <C extends RecipeInput, U extends Recipe<C>, T extends RecipeSerializer<U>> DeferredHolder<RecipeSerializer<?>, T> recipeSerializer(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.RECIPE_SERIALIZER, factory);
    }

    public <T extends Attribute> DeferredHolder<Attribute, T> attribute(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.ATTRIBUTE, factory);
    }

    public DeferredHolder<Attribute, RangedAttribute> rangedAttribute(String path, double defaultValue, double min, double max) {
        String key = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path).toLanguageKey("attribute");
        return this.attribute(path, () -> new RangedAttribute(key, defaultValue, min, max));
    }

    public <S, U extends StatType<S>, T extends StatType<U>> DeferredHolder<StatType<?>, T> stat(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.STAT_TYPE, factory);
    }

    public Holder<ResourceLocation> customStat(String path, StatFormatter formatter) {
        return this.registerDH(path, Registries.CUSTOM_STAT, () -> {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path);
            Stats.CUSTOM.get((Object)id, formatter);
            return id;
        });
    }

    public <U extends FeatureConfiguration, T extends Feature<U>> DeferredHolder<Feature<?>, T> feature(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.FEATURE, factory);
    }

    public DeferredHolder<CreativeModeTab, CreativeModeTab> creativeTab(String path, UnaryOperator<CreativeModeTab.Builder> operator) {
        return this.registerDH(path, Registries.CREATIVE_MODE_TAB, () -> ((CreativeModeTab.Builder)operator.apply(CreativeModeTab.builder())).build());
    }

    public <T> DataComponentType<T> enchantmentEffect(String path, UnaryOperator<DataComponentType.Builder<T>> operator) {
        DataComponentType type = ((DataComponentType.Builder)operator.apply(DataComponentType.builder())).build();
        this.register(path, Registries.ENCHANTMENT_EFFECT_COMPONENT_TYPE, () -> type);
        return type;
    }

    public <T> DataComponentType<T> component(String path, UnaryOperator<DataComponentType.Builder<T>> operator) {
        DataComponentType type = ((DataComponentType.Builder)operator.apply(DataComponentType.builder())).build();
        this.register(path, Registries.DATA_COMPONENT_TYPE, () -> type);
        return type;
    }

    public <T> AttachmentType<T> attachment(String path, Supplier<T> defaultValue, UnaryOperator<AttachmentType.Builder<T>> operator) {
        AttachmentType type = ((AttachmentType.Builder)operator.apply(AttachmentType.builder(defaultValue))).build();
        this.register(path, NeoForgeRegistries.Keys.ATTACHMENT_TYPES, () -> type);
        return type;
    }

    public <T> AttachmentType<T> attachment(String path, Function<IAttachmentHolder, T> defaultValue, UnaryOperator<AttachmentType.Builder<T>> operator) {
        AttachmentType type = ((AttachmentType.Builder)operator.apply(AttachmentType.builder(defaultValue))).build();
        this.register(path, NeoForgeRegistries.Keys.ATTACHMENT_TYPES, () -> type);
        return type;
    }

    public LootPoolEntryType lootPoolEntry(String path, LootPoolEntryType type) {
        this.register(path, Registries.LOOT_POOL_ENTRY_TYPE, () -> type);
        return type;
    }

    public <T extends IGlobalLootModifier> MapCodec<T> lootModifier(String path, MapCodec<T> codec) {
        this.register(path, NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, () -> codec);
        return codec;
    }

    public LootItemConditionType lootCondition(String path, MapCodec<? extends LootItemCondition> codec) {
        LootItemConditionType type = new LootItemConditionType(codec);
        this.register(path, Registries.LOOT_CONDITION_TYPE, () -> type);
        return type;
    }

    public <T extends ICustomIngredient> IngredientType<T> ingredient(String path, IngredientType<T> type) {
        this.register(path, NeoForgeRegistries.Keys.INGREDIENT_TYPES, () -> type);
        return type;
    }

    public <T extends CriterionTrigger<?>> T criteriaTrigger(String path, T trigger) {
        this.register(path, Registries.TRIGGER_TYPE, () -> trigger);
        return trigger;
    }

    public <T extends ItemSubPredicate> ItemSubPredicate.Type<T> itemSubPredicate(String path, Codec<T> codec) {
        ItemSubPredicate.Type type = new ItemSubPredicate.Type(codec);
        this.register(path, Registries.ITEM_SUB_PREDICATE_TYPE, () -> type);
        return type;
    }

    public <T extends StructureProcessor> StructureProcessorType<T> structureProcessor(String path, MapCodec<T> codec) {
        StructureProcessorType type = () -> codec;
        this.register(path, Registries.STRUCTURE_PROCESSOR, () -> type);
        return type;
    }

    public <K, V> DataMapType<K, V> dataMap(String path, ResourceKey<? extends Registry<K>> targetRegistry, Codec<V> codec, UnaryOperator<DataMapType.Builder<V, K>> config) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path);
        ResourceKey registryKey = ResourceKey.create(DATA_MAP_KEY, (ResourceLocation)id);
        DataMapType dataMapType = ((DataMapType.Builder)config.apply(DataMapType.builder((ResourceLocation)id, targetRegistry, codec))).build();
        this.registerDataMap(registryKey, dataMapType);
        return dataMapType;
    }

    public <R, T extends R> DeferredHolder<R, T> custom(String path, ResourceKey<? extends Registry<R>> registry, Supplier<T> factory) {
        return this.registerDH(path, registry, factory);
    }

    public <R, T extends R> T custom(String path, ResourceKey<? extends Registry<R>> registry, T object) {
        this.register(path, registry, () -> object);
        return object;
    }

    @ApiStatus.Experimental
    public <R> List<Holder<R>> getRegisteredObjects(ResourceKey<? extends Registry<R>> key) {
        return Collections.unmodifiableList(this.resolvedObjects.getOrDefault(key, List.of()));
    }

    protected <R, T extends R> void register(String path, ResourceKey<? extends Registry<R>> regKey, Supplier<T> factory) {
        List registrars = this.objects.computeIfAbsent(regKey, k -> new ArrayList());
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path);
        registrars.add(new Registrar<T>(id, factory));
    }

    protected <R, T extends R> DeferredHolder<R, T> registerDH(String path, ResourceKey<? extends Registry<R>> regKey, Supplier<T> factory) {
        this.register(path, regKey, factory);
        return DeferredHolder.create(regKey, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path));
    }

    protected <T> void registerRegistry(ResourceKey<? extends Registry<T>> key, Registry<T> registry) {
        List registrars = this.objects.computeIfAbsent(ROOT_REGISTRY_KEY, k -> new ArrayList());
        ResourceLocation id = key.location();
        registrars.add(new Registrar<Registry>(id, () -> registry));
    }

    protected <K, V> void registerDataMap(ResourceKey<? extends DataMapType<?, ?>> key, DataMapType<K, V> type) {
        List registrars = this.objects.computeIfAbsent(DATA_MAP_KEY, k -> new ArrayList());
        ResourceLocation id = key.location();
        registrars.add(new Registrar<DataMapType>(id, () -> type));
    }

    @SubscribeEvent
    public void register(RegisterEvent e) {
        Registry registry = e.getRegistry();
        for (Registrar registrar : this.objects.getOrDefault(e.getRegistryKey(), Collections.emptyList())) {
            try {
                Object obj = registrar.factory.get();
                Registry.register((Registry)registry, (ResourceLocation)registrar.id, obj);
                this.resolvedObjects.computeIfAbsent(e.getRegistryKey(), k -> new ArrayList()).add(registry.wrapAsHolder(obj));
            }
            catch (Throwable ex) {
                Placebo.LOGGER.error("Exception thrown during registration of {}", (Object)registrar.id);
                throw ex;
            }
        }
        this.objects.remove(e.getRegistryKey());
    }

    @SubscribeEvent
    public void registerRegistries(NewRegistryEvent e) {
        for (Registrar registrar : this.objects.getOrDefault(ROOT_REGISTRY_KEY, Collections.emptyList())) {
            try {
                Registry obj = (Registry)registrar.factory.get();
                e.register(obj);
            }
            catch (Throwable ex) {
                Placebo.LOGGER.error("Exception thrown during registration of registry {}", (Object)registrar.id);
                throw ex;
            }
        }
        this.objects.remove(ROOT_REGISTRY_KEY);
    }

    @SubscribeEvent
    public void registerDataMaps(RegisterDataMapTypesEvent e) {
        for (Registrar registrar : this.objects.getOrDefault(DATA_MAP_KEY, Collections.emptyList())) {
            try {
                DataMapType obj = (DataMapType)registrar.factory.get();
                e.register(obj);
            }
            catch (Throwable ex) {
                Placebo.LOGGER.error("Exception thrown during registration of data map type {}", (Object)registrar.id);
                throw ex;
            }
        }
        this.objects.remove(DATA_MAP_KEY);
    }

    private static void unfreezeBETypeRegistry() {
        ((MappedRegistry)BuiltInRegistries.BLOCK_ENTITY_TYPE).unfreeze();
    }

    protected record Registrar<T>(ResourceLocation id, Supplier<T> factory) {
    }
}

