/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass;

import com.supermartijn642.connectedglass.CGColoredGlassBlock;
import com.supermartijn642.connectedglass.CGColoredPaneBlock;
import com.supermartijn642.connectedglass.CGColoredTintedGlassBlock;
import com.supermartijn642.connectedglass.CGGlassBlock;
import com.supermartijn642.connectedglass.CGPaneBlock;
import com.supermartijn642.connectedglass.CGTintedGlassBlock;
import com.supermartijn642.connectedglass.ConnectedGlass;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.registry.Registries;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;

public enum CGGlassType {
    BORDERLESS_GLASS(false, true, "Connecting"),
    CLEAR_GLASS(false, true, "Clear"),
    SCRATCHED_GLASS(false, true, "Scratched"),
    TINTED_BORDERLESS_GLASS(true, false, "Connecting Tinted");

    private final String identifier;
    public final boolean isTinted;
    public final boolean hasPanes;
    public final String translation;
    public CGGlassBlock block;
    public final List<CGGlassBlock> blocks = new ArrayList<CGGlassBlock>();
    public final EnumMap<class_1767, CGColoredGlassBlock> colored_blocks = new EnumMap(class_1767.class);
    public CGPaneBlock pane;
    public final List<CGPaneBlock> panes = new ArrayList<CGPaneBlock>();
    public final EnumMap<class_1767, CGColoredPaneBlock> colored_panes = new EnumMap(class_1767.class);

    private CGGlassType(boolean isTinted, boolean hasPanes, String translation) {
        this.identifier = this.name().toLowerCase(Locale.ROOT);
        this.isTinted = isTinted;
        this.hasPanes = hasPanes;
        this.translation = translation;
    }

    public String getRegistryName() {
        return this.identifier;
    }

    public String getRegistryName(class_1767 color) {
        return color == null ? this.getRegistryName() : this.getRegistryName() + "_" + color.method_7792().toLowerCase(Locale.ROOT);
    }

    public String getPaneRegistryName() {
        return this.getRegistryName() + "_pane";
    }

    public String getPaneRegistryName(class_1767 color) {
        return color == null ? this.getPaneRegistryName() : this.getRegistryName(color) + "_pane";
    }

    public void registerBlocks(RegistrationHandler.Helper<class_2248> helper) {
        this.block = (CGGlassBlock)((Object)helper.register(this.getRegistryName(), (Object)(this.isTinted ? new CGTintedGlassBlock(this.name().toLowerCase(Locale.ROOT), true) : new CGGlassBlock(this.name().toLowerCase(Locale.ROOT), true))));
        this.blocks.add(this.block);
        if (this.hasPanes) {
            this.pane = (CGPaneBlock)((Object)helper.register(this.getPaneRegistryName(), (Object)new CGPaneBlock(this.block)));
            this.panes.add(this.pane);
        }
        for (class_1767 color : class_1767.values()) {
            CGColoredGlassBlock block = (CGColoredGlassBlock)((Object)helper.register(this.getRegistryName(color), (Object)(this.isTinted ? new CGColoredTintedGlassBlock(this.name().toLowerCase(Locale.ROOT) + "_" + color.name().toLowerCase(Locale.ROOT), true, color) : new CGColoredGlassBlock(this.name().toLowerCase(Locale.ROOT) + "_" + color.name().toLowerCase(Locale.ROOT), true, color))));
            this.blocks.add(block);
            this.colored_blocks.put(color, block);
            if (!this.hasPanes) continue;
            CGColoredPaneBlock pane = (CGColoredPaneBlock)((Object)helper.register(this.getPaneRegistryName(color), (Object)new CGColoredPaneBlock(block)));
            this.panes.add(pane);
            this.colored_panes.put(color, pane);
        }
    }

    public void registerItems(RegistrationHandler.Helper<class_1792> helper) {
        this.blocks.forEach(block -> {
            class_2960 identifier = Registries.BLOCKS.getIdentifier((Object)block);
            helper.register(identifier.method_12832(), (Object)new BaseBlockItem((class_2248)block, ItemProperties.create().group((class_1761)ConnectedGlass.GROUP)));
        });
        this.panes.forEach(pane -> {
            class_2960 identifier = Registries.BLOCKS.getIdentifier((Object)pane);
            helper.register(identifier.method_12832(), (Object)new BaseBlockItem((class_2248)pane, ItemProperties.create().group((class_1761)ConnectedGlass.GROUP)));
        });
    }

    public CGGlassBlock getBlock() {
        return this.block;
    }

    public CGGlassBlock getBlock(class_1767 color) {
        if (color == null) {
            return this.block;
        }
        return this.colored_blocks.get(color);
    }

    public CGPaneBlock getPane() {
        return this.pane;
    }

    public CGPaneBlock getPane(class_1767 color) {
        if (color == null) {
            return this.pane;
        }
        return this.colored_panes.get(color);
    }
}

