/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.client.LanguageMap;
import forge.net.mca.client.OnlineSpeechManager;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.chatAI.ChatAI;
import forge.net.mca.entity.ai.chatAI.GPT3;
import forge.net.mca.entity.ai.relationship.Personality;
import forge.net.mca.network.s2c.OpenGuiRequest;
import forge.net.mca.server.ServerInteractionManager;
import forge.net.mca.server.world.data.PlayerSaveData;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class Command {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mca").then(Command.register("help", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::displayHelp)))).then(Command.register("propose").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(Command::propose)))).then(Command.register("accept").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(Command::accept)))).then(Command.register("proposals", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::displayProposal)))).then(Command.register("procreate", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::procreate)))).then(Command.register("separate", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::separate)))).then(Command.register("reject").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(Command::reject)))).then(Command.register("editor", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::editor)))).then(Command.register("destiny", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::destiny)))).then(Command.register("mail", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::mail)))).then(Command.register("verify").then(Commands.m_82129_((String)"email", (ArgumentType)StringArgumentType.greedyString()).executes(Command::verify)))).then(Command.register("chatAI").requires(p -> p.m_6761_(2) || p.m_81377_().m_129792_()).executes(Command::chatAIHelp).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"model", (ArgumentType)StringArgumentType.string()).executes(c -> Command.chatAI((String)c.getArgument("model", String.class), new Config().villagerChatAIEndpoint, ""))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"endpoint", (ArgumentType)StringArgumentType.string()).executes(c -> Command.chatAI((String)c.getArgument("model", String.class), (String)c.getArgument("endpoint", String.class), ""))).then(Commands.m_82129_((String)"token", (ArgumentType)StringArgumentType.string()).executes(c -> Command.chatAI((String)c.getArgument("model", String.class), (String)c.getArgument("endpoint", String.class), (String)c.getArgument("token", String.class)))))))).then(Command.register("tts").requires(p -> p.m_81377_().m_129792_()).then(Commands.m_82127_((String)"enable").then(Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(Command::ttsEnable))).then(Commands.m_82127_((String)"scan").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"language", (ArgumentType)StringArgumentType.string()).requires(p -> p.m_230896_() != null && p.m_230896_().m_6302_().contains("Player"))).executes(Command::ttsScan))))).then(Command.register("inworldAI").requires(p -> p.m_6761_(2) || p.m_81377_().m_129792_()).then(Command.register("keys").then(Commands.m_82129_((String)"api_key", (ArgumentType)StringArgumentType.string()).executes(c -> Command.inworldAIKey((String)c.getArgument("api_key", String.class))))).then(Command.register("addCharacter").then(Commands.m_82129_((String)"villager_name", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"character_endpoint", (ArgumentType)StringArgumentType.string()).executes(c -> Command.inworldAICharacter((CommandContext<CommandSourceStack>)c, (String)c.getArgument("villager_name", String.class), (String)c.getArgument("character_endpoint", String.class))))))));
    }

    private static int chatAIHelp(CommandContext<CommandSourceStack> context) {
        MutableComponent styled = Component.m_237115_((String)"mca.ai_help").m_130938_(s -> s.m_131140_(ChatFormatting.GOLD).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Luke100000/minecraft-comes-alive/wiki/GPT3-based-conversations")));
        Command.sendMessage(context, (Component)styled);
        return Command.chatAI(new Config().villagerChatAIModel, new Config().villagerChatAIEndpoint, new Config().villagerChatAIToken);
    }

    private static int inworldAIKey(String apiKey) {
        Config.getInstance().inworldAIToken = apiKey;
        Config.getInstance().save();
        return 0;
    }

    private static int inworldAICharacter(CommandContext<CommandSourceStack> context, String name, String endpoint) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        Optional<VillagerEntityMCA> optionalVillager = ChatAI.findVillagerInArea(player, name);
        optionalVillager.ifPresent(v -> {
            Config.getInstance().inworldAIResourceNames.put(v.m_20148_(), endpoint);
            ChatAI.clearStrategy(v.m_20148_());
            Config.getInstance().save();
        });
        return 0;
    }

    private static int chatAI(String model, String endpoint, String token) {
        Config.getInstance().enableVillagerChatAI = true;
        Config.getInstance().villagerChatAIModel = model;
        Config.getInstance().villagerChatAIEndpoint = endpoint;
        Config.getInstance().villagerChatAIToken = token;
        Config.getInstance().save();
        return 0;
    }

    private static int ttsEnable(CommandContext<CommandSourceStack> ctx) {
        Config.getInstance().enableOnlineTTS = BoolArgumentType.getBool(ctx, (String)"enabled");
        Config.getInstance().save();
        return 0;
    }

    private static boolean couldBePersonalityRelated(String phrase) {
        for (Personality value : Personality.values()) {
            if (!phrase.contains(value.name().toLowerCase(Locale.ROOT))) continue;
            return true;
        }
        return false;
    }

    private static int ttsScan(CommandContext<CommandSourceStack> ctx) {
        String language = (String)ctx.getArgument("language", String.class);
        for (Map.Entry definition : Minecraft.m_91087_().m_91102_().m_264450_().entrySet()) {
            String ttsLang = LanguageMap.LANGUAGE_MAP.getOrDefault(definition.getKey(), "");
            if (ttsLang.isEmpty() || !language.equals("all") && !ttsLang.equals(language)) continue;
            Minecraft.m_91087_().m_91102_().m_264110_((String)definition.getKey());
            try {
                Minecraft.m_91087_().m_91391_().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            for (Map.Entry<String, String> text : MCA.translations.entrySet()) {
                String key = text.getKey();
                if (!key.contains("dialogue.") && !key.contains("interaction.") && !key.contains("villager.") || Command.couldBePersonalityRelated(key)) continue;
                String hash = OnlineSpeechManager.INSTANCE.getHash(text.getValue());
                OnlineSpeechManager.INSTANCE.downloadAudio(ttsLang, "male_9", text.getValue(), hash, true);
            }
        }
        return 0;
    }

    private static int editor(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
        if (player == null) {
            return 1;
        }
        if (((CommandSourceStack)ctx.getSource()).m_6761_(2) || Config.getInstance().allowFullPlayerEditor) {
            NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.VILLAGER_EDITOR, (Entity)player), player);
            return 0;
        }
        if (Config.getInstance().allowLimitedPlayerEditor) {
            NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.LIMITED_VILLAGER_EDITOR, (Entity)player), player);
            return 0;
        }
        Command.sendMessage(ctx, (Component)Component.m_237115_((String)"command.no_permission").m_130940_(ChatFormatting.RED));
        return 1;
    }

    private static int destiny(CommandContext<CommandSourceStack> ctx) {
        if (((CommandSourceStack)ctx.getSource()).m_6761_(2) || Config.getInstance().allowDestinyCommandOnce) {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
            if (player != null && !PlayerSaveData.get(player).isEntityDataSet() || Config.getInstance().allowDestinyCommandMoreThanOnce) {
                ServerInteractionManager.launchDestiny(player);
                return 0;
            }
            Command.sendMessage(ctx, (Component)Component.m_237115_((String)"command.only_one_destiny").m_130940_(ChatFormatting.RED));
            return 1;
        }
        Command.sendMessage(ctx, (Component)Component.m_237115_((String)"command.no_permission").m_130940_(ChatFormatting.RED));
        return 1;
    }

    private static int mail(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
        if (player == null) {
            return 1;
        }
        PlayerSaveData data = PlayerSaveData.get(player);
        if (data.hasMail()) {
            while (data.hasMail()) {
                player.m_150109_().m_150079_(data.getMail());
            }
        } else {
            Command.sendMessage(ctx, (Component)Component.m_237115_((String)"command.no_mail"));
        }
        return 0;
    }

    private static int verify(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
        CompletableFuture.runAsync(() -> {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("email", StringArgumentType.getString((CommandContext)ctx, (String)"email"));
            assert (player != null);
            params.put("player", player.m_7755_().getString());
            String encodedURL = params.keySet().stream().map(key -> key + "=" + URLEncoder.encode((String)params.get(key), StandardCharsets.UTF_8)).collect(Collectors.joining("&", Config.getInstance().villagerChatAIEndpoint.replace("v1/mca/chat", "v1/mca/verify") + "?", ""));
            GPT3.Answer request = GPT3.request(encodedURL);
            if (request.answer().equals("success")) {
                Command.sendMessage(ctx, (Component)Component.m_237115_((String)"command.verify.success").m_130940_(ChatFormatting.GREEN));
            } else if (request.answer().equals("failed")) {
                Command.sendMessage(ctx, (Component)Component.m_237115_((String)"command.verify.failed").m_130940_(ChatFormatting.RED));
            } else {
                Command.sendMessage(ctx, (Component)Component.m_237115_((String)"command.verify.crashed").m_130940_(ChatFormatting.RED));
            }
        });
        return 0;
    }

    private static int displayHelp(CommandContext<CommandSourceStack> ctx) {
        Command.sendMessage(ctx, ChatFormatting.DARK_RED + "--- " + ChatFormatting.GOLD + "PLAYER COMMANDS" + ChatFormatting.DARK_RED + " ---");
        Command.sendMessage(ctx, ChatFormatting.WHITE + " /mca editor" + ChatFormatting.GOLD + " - Choose your genetics and stuff.");
        Command.sendMessage(ctx, ChatFormatting.WHITE + " /mca propose <PlayerName>" + ChatFormatting.GOLD + " - Proposes marriage to the given player.");
        Command.sendMessage(ctx, ChatFormatting.WHITE + " /mca proposals " + ChatFormatting.GOLD + " - Shows all active proposals.");
        Command.sendMessage(ctx, ChatFormatting.WHITE + " /mca accept <PlayerName>" + ChatFormatting.GOLD + " - Accepts the player's marriage request.");
        Command.sendMessage(ctx, ChatFormatting.WHITE + " /mca reject <PlayerName>" + ChatFormatting.GOLD + " - Rejects the player's marriage request.");
        Command.sendMessage(ctx, ChatFormatting.WHITE + " /mca procreate " + ChatFormatting.GOLD + " - Starts procreation.");
        Command.sendMessage(ctx, ChatFormatting.WHITE + " /mca separate " + ChatFormatting.GOLD + " - Ends your marriage.");
        Command.sendMessage(ctx, ChatFormatting.DARK_RED + "--- " + ChatFormatting.GOLD + "GLOBAL COMMANDS" + ChatFormatting.DARK_RED + " ---");
        Command.sendMessage(ctx, ChatFormatting.WHITE + " /mca help " + ChatFormatting.GOLD + " - Shows this list of commands.");
        return 0;
    }

    private static int propose(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"target");
        ServerInteractionManager.getInstance().sendProposal(((CommandSourceStack)ctx.getSource()).m_230896_(), target);
        return 0;
    }

    private static int accept(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"target");
        ServerInteractionManager.getInstance().acceptProposal(((CommandSourceStack)ctx.getSource()).m_230896_(), target);
        return 0;
    }

    private static int displayProposal(CommandContext<CommandSourceStack> ctx) {
        ServerInteractionManager.getInstance().listProposals(((CommandSourceStack)ctx.getSource()).m_230896_());
        return 0;
    }

    private static int procreate(CommandContext<CommandSourceStack> ctx) {
        ServerInteractionManager.getInstance().procreate(((CommandSourceStack)ctx.getSource()).m_230896_());
        return 0;
    }

    private static int separate(CommandContext<CommandSourceStack> ctx) {
        ServerInteractionManager.getInstance().endMarriage(((CommandSourceStack)ctx.getSource()).m_230896_());
        return 0;
    }

    private static int reject(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"target");
        ServerInteractionManager.getInstance().rejectProposal(((CommandSourceStack)ctx.getSource()).m_230896_(), target);
        return 0;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> register(String name, com.mojang.brigadier.Command<CommandSourceStack> cmd) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)name).requires(cs -> cs.m_6761_(0))).executes(cmd);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> register(String name) {
        return Commands.m_82127_((String)name).requires(cs -> cs.m_6761_(0));
    }

    private static void sendMessage(CommandContext<CommandSourceStack> ctx, String message) {
        Command.sendMessage(ctx, (Component)Component.m_237113_((String)message));
    }

    private static void sendMessage(CommandContext<CommandSourceStack> ctx, Component message) {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
        if (player != null) {
            player.m_213846_(message);
        }
    }
}

