/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server;

import forge.net.mca.Config;
import forge.net.mca.ducks.IVillagerEntity;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.VillagerFactory;
import forge.net.mca.entity.ZombieVillagerEntityMCA;
import forge.net.mca.entity.ZombieVillagerFactory;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.server.world.data.Nationality;
import forge.net.mca.util.WorldUtils;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class SpawnQueue {
    private static final SpawnQueue INSTANCE = new SpawnQueue();
    private final ConcurrentLinkedQueue<Villager> villagerSpawnQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<ZombieVillager> zombieVillagerSpawnQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Zombie> zombieSpawnList = new ConcurrentLinkedQueue();
    public static final TicketType<BlockPos> SPAWN = TicketType.m_9465_((String)"mca:spawner", Vec3i::compareTo, (int)1);

    public static SpawnQueue getInstance() {
        return INSTANCE;
    }

    private void lock(Entity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            ServerChunkCache chunkManager = world.m_7726_();
            ChunkPos chunkPos = new ChunkPos(entity.m_20183_());
            chunkManager.m_8387_(SPAWN, chunkPos, 8, (Object)entity.m_20183_());
        }
    }

    private void unlock(Entity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            ServerChunkCache chunkManager = world.m_7726_();
            ChunkPos chunkPos = new ChunkPos(entity.m_20183_());
            chunkManager.m_8438_(SPAWN, chunkPos, 8, (Object)entity.m_20183_());
        }
    }

    public void tick() {
        Zombie ze;
        ZombieVillager zve;
        Villager ve = this.villagerSpawnQueue.poll();
        if (ve != null) {
            this.lock((Entity)ve);
            if (WorldUtils.isChunkLoaded(ve.m_9236_(), (Vec3i)ve.m_20183_())) {
                ve.m_146870_();
                VillagerEntityMCA villager = VillagerFactory.newVillager(ve.m_9236_()).withName(ve.m_8077_() ? ve.m_7755_().getString() : null).withGender(Gender.getRandom()).withAge(ve.m_146764_()).withPosition((Entity)ve).withType(ve.m_7141_().m_35560_()).withProfession(ve.m_7141_().m_35571_(), ve.m_7141_().m_35576_(), ve.m_6616_()).spawn(((IVillagerEntity)ve).getSpawnReason());
                this.copyPastaIntensifies((PathfinderMob)villager, (PathfinderMob)ve);
            } else {
                this.villagerSpawnQueue.add(ve);
            }
            this.unlock((Entity)ve);
        }
        if ((zve = this.zombieVillagerSpawnQueue.poll()) != null) {
            this.lock((Entity)zve);
            if (WorldUtils.isChunkLoaded(zve.m_9236_(), (Vec3i)zve.m_20183_())) {
                zve.m_146870_();
                ZombieVillagerEntityMCA villager = ZombieVillagerFactory.newVillager(zve.m_9236_()).withName(zve.m_8077_() ? zve.m_7755_().getString() : null).withGender(Gender.getRandom()).withPosition((Entity)zve).withType(zve.m_7141_().m_35560_()).withProfession(zve.m_7141_().m_35571_(), zve.m_7141_().m_35576_()).spawn(((IVillagerEntity)zve).getSpawnReason());
                this.copyPastaIntensifies((PathfinderMob)villager, (PathfinderMob)zve);
            } else {
                this.zombieVillagerSpawnQueue.add(zve);
            }
            this.unlock((Entity)zve);
        }
        if ((ze = this.zombieSpawnList.poll()) != null) {
            this.lock((Entity)ze);
            if (WorldUtils.isChunkLoaded(ze.m_9236_(), (Vec3i)ze.m_20183_())) {
                ze.m_146870_();
                ZombieVillagerEntityMCA villager = ZombieVillagerFactory.newVillager(ze.m_9236_()).withName(ze.m_8077_() ? ze.m_7755_().getString() : null).withGender(Gender.getRandom()).withPosition((Entity)ze).withType(VillagerType.m_204073_((Holder)ze.m_9236_().m_204166_(ze.m_20183_()))).withProfession(BuiltInRegistries.f_256735_.m_213642_(ze.m_217043_()).map(Holder::m_203334_).orElse(VillagerProfession.f_35585_)).spawn(MobSpawnType.NATURAL);
                this.copyPastaIntensifies((PathfinderMob)villager, (PathfinderMob)ze);
            } else {
                this.zombieSpawnList.add(ze);
            }
            this.unlock((Entity)ze);
        }
    }

    private void copyPastaIntensifies(PathfinderMob villager, PathfinderMob entity) {
        if (entity.m_21532_()) {
            villager.m_21530_();
        }
        if (entity.m_20147_()) {
            villager.m_20331_(true);
        }
        if (entity.m_21525_()) {
            villager.m_21557_(true);
        }
        for (String tag : entity.m_19880_()) {
            villager.m_20049_(tag);
        }
    }

    public static boolean shouldGetConverted(Entity entity) {
        if (Config.getInstance().fractionOfVanillaVillages <= 0.0f) {
            return true;
        }
        int i = Nationality.get((ServerLevel)entity.m_9236_()).getRegionId(entity.m_20183_());
        return (double)Math.floorMod(i, 100) >= (double)Config.getInstance().fractionOfVanillaVillages * 100.0;
    }

    public boolean addVillager(Entity entity) {
        IVillagerEntity villagerEntity;
        if (entity instanceof IVillagerEntity && !this.handlesSpawnReason((villagerEntity = (IVillagerEntity)entity).getSpawnReason())) {
            return false;
        }
        if (Config.getInstance().villagerDimensionBlacklist.contains(entity.m_20193_().m_46472_().m_135782_().toString())) {
            return false;
        }
        if (Config.getInstance().overwriteOriginalVillagers && (entity.getClass().equals(Villager.class) || Config.getInstance().moddedVillagerWhitelist.contains(BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_()).toString()) && entity instanceof Villager) && SpawnQueue.shouldGetConverted(entity) && !this.villagerSpawnQueue.contains(entity)) {
            return this.villagerSpawnQueue.add((Villager)entity);
        }
        if (Config.getInstance().overwriteOriginalZombieVillagers && (entity.getClass().equals(ZombieVillager.class) || Config.getInstance().moddedZombieVillagerWhitelist.contains(BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_()).toString()) && entity instanceof ZombieVillager) && Config.getInstance().fractionOfVanillaZombies < ((ZombieVillager)entity).m_217043_().m_188501_() && !this.zombieVillagerSpawnQueue.contains(entity)) {
            return this.zombieVillagerSpawnQueue.add((ZombieVillager)entity);
        }
        if (Config.getInstance().overwriteAllZombiesWithZombieVillagers && entity.getClass().equals(Zombie.class) && !this.zombieSpawnList.contains(entity)) {
            return this.zombieSpawnList.add((Zombie)entity);
        }
        return false;
    }

    private boolean handlesSpawnReason(MobSpawnType reason) {
        return Config.getInstance().allowedSpawnReasons.contains(reason.name().toLowerCase(Locale.ROOT));
    }

    public void convert(Villager villager) {
        this.villagerSpawnQueue.add(villager);
    }
}

