/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.server;

import fabric.net.mca.Config;
import fabric.net.mca.ducks.IVillagerEntity;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.VillagerFactory;
import fabric.net.mca.entity.ZombieVillagerEntityMCA;
import fabric.net.mca.entity.ZombieVillagerFactory;
import fabric.net.mca.entity.ai.relationship.Gender;
import fabric.net.mca.server.world.data.Nationality;
import fabric.net.mca.util.WorldUtils;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3730;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class SpawnQueue {
    private static final SpawnQueue INSTANCE = new SpawnQueue();
    private final ConcurrentLinkedQueue<class_1646> villagerSpawnQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<class_1641> zombieVillagerSpawnQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<class_1642> zombieSpawnList = new ConcurrentLinkedQueue();
    public static final class_3230<class_2338> SPAWN = class_3230.method_20628((String)"mca:spawner", class_2382::method_10265, (int)1);

    public static SpawnQueue getInstance() {
        return INSTANCE;
    }

    private void lock(class_1297 entity) {
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            class_3215 chunkManager = world.method_14178();
            class_1923 chunkPos = new class_1923(entity.method_24515());
            chunkManager.method_17297(SPAWN, chunkPos, 8, (Object)entity.method_24515());
        }
    }

    private void unlock(class_1297 entity) {
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            class_3215 chunkManager = world.method_14178();
            class_1923 chunkPos = new class_1923(entity.method_24515());
            chunkManager.method_17300(SPAWN, chunkPos, 8, (Object)entity.method_24515());
        }
    }

    public void tick() {
        class_1642 ze;
        class_1641 zve;
        class_1646 ve = this.villagerSpawnQueue.poll();
        if (ve != null) {
            this.lock((class_1297)ve);
            if (WorldUtils.isChunkLoaded(ve.method_37908(), (class_2382)ve.method_24515())) {
                ve.method_31472();
                VillagerEntityMCA villager = VillagerFactory.newVillager(ve.method_37908()).withName(ve.method_16914() ? ve.method_5477().getString() : null).withGender(Gender.getRandom()).withAge(ve.method_5618()).withPosition((class_1297)ve).withType(ve.method_7231().method_16919()).withProfession(ve.method_7231().method_16924(), ve.method_7231().method_16925(), ve.method_8264()).spawn(((IVillagerEntity)ve).getSpawnReason());
                this.copyPastaIntensifies((class_1314)villager, (class_1314)ve);
            } else {
                this.villagerSpawnQueue.add(ve);
            }
            this.unlock((class_1297)ve);
        }
        if ((zve = this.zombieVillagerSpawnQueue.poll()) != null) {
            this.lock((class_1297)zve);
            if (WorldUtils.isChunkLoaded(zve.method_37908(), (class_2382)zve.method_24515())) {
                zve.method_31472();
                ZombieVillagerEntityMCA villager = ZombieVillagerFactory.newVillager(zve.method_37908()).withName(zve.method_16914() ? zve.method_5477().getString() : null).withGender(Gender.getRandom()).withPosition((class_1297)zve).withType(zve.method_7231().method_16919()).withProfession(zve.method_7231().method_16924(), zve.method_7231().method_16925()).spawn(((IVillagerEntity)zve).getSpawnReason());
                this.copyPastaIntensifies((class_1314)villager, (class_1314)zve);
            } else {
                this.zombieVillagerSpawnQueue.add(zve);
            }
            this.unlock((class_1297)zve);
        }
        if ((ze = this.zombieSpawnList.poll()) != null) {
            this.lock((class_1297)ze);
            if (WorldUtils.isChunkLoaded(ze.method_37908(), (class_2382)ze.method_24515())) {
                ze.method_31472();
                ZombieVillagerEntityMCA villager = ZombieVillagerFactory.newVillager(ze.method_37908()).withName(ze.method_16914() ? ze.method_5477().getString() : null).withGender(Gender.getRandom()).withPosition((class_1297)ze).withType(class_3854.method_16930((class_6880)ze.method_37908().method_23753(ze.method_24515()))).withProfession(class_7923.field_41195.method_10240(ze.method_6051()).map(class_6880::comp_349).orElse(class_3852.field_17051)).spawn(class_3730.field_16459);
                this.copyPastaIntensifies((class_1314)villager, (class_1314)ze);
            } else {
                this.zombieSpawnList.add(ze);
            }
            this.unlock((class_1297)ze);
        }
    }

    private void copyPastaIntensifies(class_1314 villager, class_1314 entity) {
        if (entity.method_5947()) {
            villager.method_5971();
        }
        if (entity.method_5655()) {
            villager.method_5684(true);
        }
        if (entity.method_5987()) {
            villager.method_5977(true);
        }
        for (String tag : entity.method_5752()) {
            villager.method_5780(tag);
        }
    }

    public static boolean shouldGetConverted(class_1297 entity) {
        if (Config.getInstance().fractionOfVanillaVillages <= 0.0f) {
            return true;
        }
        int i = Nationality.get((class_3218)entity.method_37908()).getRegionId(entity.method_24515());
        return (double)Math.floorMod(i, 100) >= (double)Config.getInstance().fractionOfVanillaVillages * 100.0;
    }

    public boolean addVillager(class_1297 entity) {
        IVillagerEntity villagerEntity;
        if (entity instanceof IVillagerEntity && !this.handlesSpawnReason((villagerEntity = (IVillagerEntity)entity).getSpawnReason())) {
            return false;
        }
        if (Config.getInstance().villagerDimensionBlacklist.contains(entity.method_5770().method_27983().method_29177().toString())) {
            return false;
        }
        if (Config.getInstance().overwriteOriginalVillagers && (entity.getClass().equals(class_1646.class) || Config.getInstance().moddedVillagerWhitelist.contains(class_7923.field_41177.method_10221((Object)entity.method_5864()).toString()) && entity instanceof class_1646) && SpawnQueue.shouldGetConverted(entity) && !this.villagerSpawnQueue.contains(entity)) {
            return this.villagerSpawnQueue.add((class_1646)entity);
        }
        if (Config.getInstance().overwriteOriginalZombieVillagers && (entity.getClass().equals(class_1641.class) || Config.getInstance().moddedZombieVillagerWhitelist.contains(class_7923.field_41177.method_10221((Object)entity.method_5864()).toString()) && entity instanceof class_1641) && Config.getInstance().fractionOfVanillaZombies < ((class_1641)entity).method_6051().method_43057() && !this.zombieVillagerSpawnQueue.contains(entity)) {
            return this.zombieVillagerSpawnQueue.add((class_1641)entity);
        }
        if (Config.getInstance().overwriteAllZombiesWithZombieVillagers && entity.getClass().equals(class_1642.class) && !this.zombieSpawnList.contains(entity)) {
            return this.zombieSpawnList.add((class_1642)entity);
        }
        return false;
    }

    private boolean handlesSpawnReason(class_3730 reason) {
        return Config.getInstance().allowedSpawnReasons.contains(reason.name().toLowerCase(Locale.ROOT));
    }

    public void convert(class_1646 villager) {
        this.villagerSpawnQueue.add(villager);
    }
}

