/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.worldgen;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import jeresources.api.conditionals.Conditional;
import jeresources.api.drop.LootDrop;
import jeresources.config.Settings;
import jeresources.entry.WorldGenEntry;
import jeresources.util.Font;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.class_1799;
import net.minecraft.class_1893;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class WorldGenWrapper
implements IRecipeCategoryExtension,
IRecipeSlotTooltipCallback {
    protected static final int X_OFFSET = 29;
    protected static final int Y_OFFSET = 52;
    protected static final int X_AXIS_SIZE = 128;
    protected static final int Y_AXIS_SIZE = 40;
    protected static final String ORE_SLOT_NAME = "oreSlot";
    private final WorldGenEntry worldGenEntry;

    public WorldGenWrapper(WorldGenEntry worldGenEntry) {
        this.worldGenEntry = worldGenEntry;
    }

    public int getLineColor() {
        return this.worldGenEntry.getColour();
    }

    public List<class_1799> getBlocks() {
        LinkedList<class_1799> blocks = new LinkedList<class_1799>();
        blocks.add(this.worldGenEntry.getBlock());
        if (this.worldGenEntry.hasDeepSlateVariant()) {
            blocks.add(this.worldGenEntry.getDeepSlateBlock());
        }
        return blocks;
    }

    public List<class_1799> getDrops() {
        return this.worldGenEntry.getDrops();
    }

    public void drawInfo(int recipeWidth, int recipeHeight, @NotNull class_332 guiGraphics, double mouseX, double mouseY) {
        float[] array = this.worldGenEntry.getChances();
        double max = 0.0;
        float[] fArray = array;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            double d = fArray[i];
            if (!(d > max)) continue;
            max = d;
        }
        double xPrev = 29.0;
        double yPrev = 52.0;
        double space = 128.0 / ((double)(array.length - 1) * 1.0);
        for (int i = 0; i < array.length; ++i) {
            double value = array[i];
            double y = 52.0 - value / max * 40.0;
            if (i > 0) {
                double x = xPrev + space;
                RenderHelper.drawLine(guiGraphics, (int)xPrev, (int)yPrev, (int)x, (int)y, this.getLineColor());
                xPrev = x;
            }
            yPrev = y;
        }
        int xPercents = 27;
        int yPercents = 48;
        String minPercent = "0%";
        int minPercentWidth = Font.small.getStringWidth("0%");
        Font.small.print(guiGraphics, "0%", 27 - minPercentWidth, 48);
        String maxPercent = String.format("%.2f", max * 100.0) + "%";
        int maxPercentWidth = Font.small.getStringWidth(maxPercent);
        Font.small.print(guiGraphics, maxPercent, 27 - maxPercentWidth, 8);
        int yLabels = 54;
        int xLabels = 29;
        int minLabel = this.worldGenEntry.getMinY();
        int minLabelWidth = Font.small.getStringWidth(String.valueOf(minLabel));
        int minLabelOffset = 29 - minLabelWidth / 2;
        Font.small.print(guiGraphics, minLabel, minLabelOffset, 54);
        int maxLabel = this.worldGenEntry.getMaxY();
        int maxLabelWidth = Font.small.getStringWidth(String.valueOf(maxLabel));
        int maxLabelOffset = 157 - maxLabelWidth / 2;
        Font.small.print(guiGraphics, maxLabel, maxLabelOffset, 54);
        int midLabel = (maxLabel + minLabel) / 2;
        int midLabelWidth = Font.small.getStringWidth(String.valueOf(midLabel));
        int midLabelOffset = 93 - midLabelWidth / 2;
        Font.small.print(guiGraphics, midLabel, midLabelOffset, 54);
        Font.small.print(guiGraphics, TranslationHelper.translateAndFormat("jer.worldgen.drops", new Object[0]), 6, 59);
        String dimension = TranslationHelper.tryDimensionTranslate(this.worldGenEntry.getDimension());
        int x = (recipeWidth - Font.normal.getStringWidth(dimension)) / 2;
        Font.normal.print(guiGraphics, dimension, x, 0);
    }

    public List<class_2561> getTooltipStrings(double mouseX, double mouseY) {
        List<class_2561> tooltip = new LinkedList<class_2561>();
        if (this.onGraph(mouseX, mouseY)) {
            tooltip = this.getLineTooltip(mouseX, tooltip);
        }
        return tooltip;
    }

    public void onTooltip(IRecipeSlotView recipeSlotView, List<class_2561> tooltip) {
        tooltip.addAll(this.getItemStackTooltip(recipeSlotView.getSlotName().orElse(null), (class_1799)((ITypedIngredient)recipeSlotView.getDisplayedIngredient().get()).getIngredient()));
    }

    private List<class_2561> getItemStackTooltip(String slotName, class_1799 itemStack) {
        LinkedList<Object> tooltip = new LinkedList<Object>();
        if (itemStack != null && slotName != null && slotName.equals(ORE_SLOT_NAME)) {
            List<String> biomes;
            if (this.worldGenEntry.isSilkTouchNeeded()) {
                tooltip.add(Conditional.silkTouch.toString());
            }
            if ((biomes = this.worldGenEntry.getBiomeRestrictions()).size() > 0) {
                tooltip.add(TranslationHelper.translateAndFormat("jer.worldgen.biomes", new Object[0]) + ":");
                tooltip.addAll(biomes);
            }
            if (Settings.showDevData) {
                tooltip.add(TranslationHelper.translateAndFormat("jer.worldgen.averageChunk", new Object[0]) + ":");
                tooltip.add("" + this.worldGenEntry.getAverageBlockCountPerChunk());
            }
        } else {
            tooltip.add(TranslationHelper.translateAndFormat("jer.worldgen.average", new Object[0]));
            for (LootDrop dropItem : this.worldGenEntry.getLootDrops(itemStack)) {
                Object line = " - ";
                line = dropItem.fortuneLevel > 0 ? (String)line + class_1893.field_9130.method_8179(dropItem.fortuneLevel).getString() : (String)line + TranslationHelper.translateAndFormat("jer.worldgen.base", new Object[0]);
                if (dropItem.chance < 1.0f) {
                    line = (String)line + " " + TranslationHelper.translateAndFormat("jer.worldgen.chance", dropItem.formatChance() + "%");
                }
                line = dropItem.minDrop == dropItem.maxDrop ? (String)line + ": " + dropItem.minDrop : (String)line + ": " + dropItem.minDrop + " - " + dropItem.maxDrop;
                if (dropItem.isAffectedBy(Conditional.affectedByFortune)) {
                    line = (String)line + " " + TranslationHelper.translateAndFormat("jer.worldgen.affectedByFortune", new Object[0]);
                }
                tooltip.add(line);
            }
        }
        return tooltip.stream().map(class_2561::method_43470).collect(Collectors.toList());
    }

    private List<class_2561> getLineTooltip(double mouseX, List<class_2561> tooltip) {
        double exactMouseX = WorldGenWrapper.getExactMouseX(mouseX);
        float[] chances = this.worldGenEntry.getChances();
        double space = 128.0 / ((double)chances.length * 1.0);
        int index = (int)((exactMouseX - 29.0 + 1.0) / space);
        int yValue = index + this.worldGenEntry.getMinY();
        if (index >= 0 && index < chances.length) {
            float chance = chances[index] * 100.0f;
            String percent = chance > 0.01f || chance == 0.0f ? String.format(" (%.2f%%)", Float.valueOf(chance)) : " <0.01%";
            tooltip.add((class_2561)class_2561.method_43470((String)("Y: " + yValue + percent)));
        }
        return tooltip;
    }

    private static double getExactMouseX(double mouseX) {
        class_310 mc = class_310.method_1551();
        int scaledWidth = mc.method_22683().method_4486();
        double mouseXExact = mc.field_1729.method_1603() * (double)scaledWidth / (double)mc.method_22683().method_4489();
        double mouseXFraction = mouseXExact - Math.floor(mouseXExact);
        return mouseX + mouseXFraction;
    }

    private boolean onGraph(double mouseX, double mouseY) {
        return mouseX >= 28.0 && mouseX < 157.0 && mouseY >= 11.0 && mouseY < 52.0;
    }
}

