/*
 * Decompiled with CFR 0.152.
 */
package jeresources.fabric.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import jeresources.config.Settings;
import jeresources.util.LogHelper;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigFileHandler {
    public static void readFromConfig() {
        JsonObject root = new JsonObject();
        Gson gson = new Gson();
        try (FileReader file = new FileReader(ConfigFileHandler.getConfigFile());){
            root = JsonParser.parseReader((Reader)file).getAsJsonObject();
        }
        catch (IOException e) {
            LogHelper.error(e.getMessage(), new Object[0]);
        }
        if (root.has("itemsPerColumn")) {
            Settings.ITEMS_PER_COLUMN = root.get("itemsPerColumn").getAsInt();
        }
        if (root.has("itemsPerRow")) {
            Settings.ITEMS_PER_ROW = root.get("itemsPerRow").getAsInt();
        }
        if (root.has("diyData")) {
            Settings.useDIYdata = root.get("diyData").getAsBoolean();
        }
        if (root.has("showDevData")) {
            Settings.showDevData = root.get("showDevData").getAsBoolean();
        }
        if (root.has("enchantsBlacklist")) {
            Settings.excludedEnchants = (String[])gson.fromJson((JsonElement)root.getAsJsonArray("enchantsBlacklist"), String[].class);
        }
        if (root.has("hiddenTabs")) {
            Settings.hiddenCategories = (String[])gson.fromJson((JsonElement)root.getAsJsonArray("hiddenTabs"), String[].class);
        }
        if (root.has("dimensionsBlacklist")) {
            Settings.excludedDimensions = Arrays.asList((Integer[])gson.fromJson((JsonElement)root.getAsJsonArray("dimensionsBlacklist"), Integer[].class));
        }
        if (root.has("disableLootManagerReloading")) {
            Settings.disableLootManagerReloading = root.get("disableLootManagerReloading").getAsBoolean();
        }
    }

    public static void writeToConfig() {
        JsonObject root = new JsonObject();
        Gson gson = new Gson();
        root.addProperty("itemsPerColumn", (Number)Settings.ITEMS_PER_COLUMN);
        root.addProperty("itemsPerRow", (Number)Settings.ITEMS_PER_ROW);
        root.addProperty("diyData", Boolean.valueOf(Settings.useDIYdata));
        root.addProperty("showDevData", Boolean.valueOf(Settings.showDevData));
        root.add("enchantsBlacklist", gson.toJsonTree((Object)Settings.excludedEnchants));
        root.add("hiddenTabs", gson.toJsonTree((Object)Settings.hiddenCategories));
        root.add("dimensionsBlacklist", gson.toJsonTree(Settings.excludedDimensions));
        root.addProperty("disableLootManagerReloading", Boolean.valueOf(Settings.disableLootManagerReloading));
        try (FileWriter file = new FileWriter(ConfigFileHandler.getConfigFile());){
            file.write(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)root));
            file.flush();
        }
        catch (IOException e) {
            LogHelper.error(e.getMessage(), new Object[0]);
        }
    }

    public static File getConfigFile() {
        return FabricLoader.getInstance().getConfigDir().resolve("jeresources.json").toFile();
    }
}

