/*
 * Decompiled with CFR 0.152.
 */
package net.ugi.sculk_depths.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_4184;
import net.minecraft.class_5321;
import net.minecraft.class_5636;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_746;
import net.minecraft.class_758;
import net.ugi.sculk_depths.tags.ModTags;
import net.ugi.sculk_depths.world.biome.ModBiomes;
import net.ugi.sculk_depths.world.dimension.ModDimensions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_758.class})
public class BackgroundRendererMixin {
    @Inject(at={@At(value="TAIL")}, method={"applyFog"})
    private static void afterSetupFog(class_4184 camera, class_758.class_4596 fogType, float viewDistance, boolean thickFog, float tickDelta, CallbackInfo ci) {
        boolean mobEffect;
        class_5636 cameraSubmersionType = camera.method_19334();
        class_1297 entity = camera.method_19331();
        boolean bl = mobEffect = entity instanceof class_1309 && (((class_1309)entity).method_6059(class_1294.field_5919) || ((class_1309)entity).method_6059(class_1294.field_38092));
        if (cameraSubmersionType == class_5636.field_27886) {
            if (entity.method_5777(ModTags.Fluids.KRYSLUM)) {
                BackgroundRendererMixin.overrideWaterToKryslum(viewDistance, entity);
            }
        } else if (cameraSubmersionType == class_5636.field_27888 && entity.method_5770().method_44013() == ModDimensions.SCULK_DEPTHS_TYPE) {
            class_2338 pos = entity.method_24515();
            float y = pos.method_10264();
            float mul = 1.0f;
            int countInfestedColumns = 0;
            int remainder = 0;
            int radius = 10;
            for (int i = pos.method_10263() - radius; i < pos.method_10263() + radius + 1; ++i) {
                for (int j = pos.method_10260() - radius; j < pos.method_10260() + radius + 1; ++j) {
                    class_2338 pos2 = new class_2338(i, pos.method_10264(), j);
                    class_5321 biome = (class_5321)entity.method_5770().method_23753(pos2).method_40230().get();
                    if (biome.equals(ModBiomes.INFECTED_COLUMNS)) {
                        ++countInfestedColumns;
                        continue;
                    }
                    ++remainder;
                }
            }
            mul = (1.0f * (float)remainder + 0.6666667f * (float)countInfestedColumns) / (float)((radius * 2 + 1) * (radius * 2 + 1));
            if (y <= -200.0f) {
                y = -200.0f;
            }
            float start = (y + 256.0f) * (viewDistance / 426.0f) * 0.1f * mul;
            float end = start * 10.0f * mul;
            BackgroundRendererMixin.overrideFog(viewDistance, start, end);
        }
    }

    private static void overrideWaterToKryslum(float viewDistance, class_1297 entity) {
        float fogStart = viewDistance * -20.0f * 0.01f;
        float fogEnd = viewDistance * 40.0f * 0.01f;
        if (entity instanceof class_746) {
            class_746 clientPlayerEntity = (class_746)entity;
            class_6880 biomeHolder = clientPlayerEntity.method_37908().method_23753(clientPlayerEntity.method_24515());
            if (biomeHolder.method_40220(class_6908.field_37378)) {
                fogEnd = viewDistance * 0.01f * 0.01f;
            }
            fogEnd *= Math.max(0.25f, clientPlayerEntity.method_3140());
        }
        RenderSystem.setShaderFogStart((float)fogStart);
        RenderSystem.setShaderFogEnd((float)fogEnd);
    }

    private static void overrideFog(float viewDistance, float start, float end) {
        float fogStart = start;
        float fogEnd = end;
        RenderSystem.setShaderFogStart((float)fogStart);
        RenderSystem.setShaderFogEnd((float)fogEnd);
    }
}

