/*
 * Decompiled with CFR 0.152.
 */
package net.ugi.sculk_depths.item.crystal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.ugi.sculk_depths.SculkDepths;
import net.ugi.sculk_depths.block.enums.CrystalType;
import net.ugi.sculk_depths.item.ModItems;
import net.ugi.sculk_depths.tags.ModTags;

public class CrystalUpgrade
extends class_1792 {
    static int[] crystalUpgradeColorArray = new int[]{0xFFFFFF, 65526, 0xFF7700, 1703680};
    static List<String> crystalItemNbtList = Arrays.asList("\"white\"", "\"blue\"", "\"orange\"", "\"lime\"");

    static class_1304 getEquipmentSlot(class_1792 item) {
        if (item == ModItems.QUAZARITH_SHOVEL || item == ModItems.QUAZARITH_AXE || item == ModItems.QUAZARITH_PICKAXE || item == ModItems.QUAZARITH_HOE || item == ModItems.QUAZARITH_SWORD) {
            return class_1304.field_6173;
        }
        if (item == ModItems.QUAZARITH_HELMET) {
            return class_1304.field_6169;
        }
        if (item == ModItems.QUAZARITH_CHESTPLATE) {
            return class_1304.field_6174;
        }
        if (item == ModItems.QUAZARITH_LEGGINGS) {
            return class_1304.field_6172;
        }
        if (item == ModItems.QUAZARITH_BOOTS) {
            return class_1304.field_6166;
        }
        return null;
    }

    public CrystalUpgrade(class_1792.class_1793 settings) {
        super(settings);
    }

    public static class_1269 createCrystalUpgrade(class_1799 stack, class_1657 player, CrystalType crystal) {
        CrystalUpgrade.addNbtToCrystalUpgrade(stack, player, crystal);
        CrystalUpgrade.addAttributeToCrystalUpgrade(stack, player, crystal);
        return class_1269.field_5812;
    }

    public static void addAttributeToCrystalUpgrade(class_1799 stack, class_1657 player, CrystalType crystal) {
        class_1304 slot = class_1304.field_6173;
        Multimap modifiers = stack.method_7926(slot);
        SculkDepths.LOGGER.info(modifiers.toString());
        Multimap<class_1320, class_1322> modifiers2 = HashMultimap.create();
        if (stack.method_7909() == ModItems.QUAZARITH_SHOVEL && crystal == CrystalType.WHITE) {
            modifiers.put((Object)class_5134.field_23719, (Object)new class_1322(UUID.randomUUID(), "Attack Damage", 2.0, class_1322.class_1323.field_6328));
        }
        if (stack.method_7909() == ModItems.QUAZARITH_AXE && crystal == CrystalType.WHITE) {
            modifiers.put((Object)class_5134.field_23721, (Object)new class_1322("Attack Damage", 2.0, class_1322.class_1323.field_6328));
        }
        if (stack.method_7909() == ModItems.QUAZARITH_PICKAXE && crystal == CrystalType.WHITE) {
            modifiers.put((Object)class_5134.field_23721, (Object)new class_1322("Attack Damage", 2.0, class_1322.class_1323.field_6328));
        }
        if (stack.method_7909() == ModItems.QUAZARITH_HOE && crystal == CrystalType.WHITE) {
            modifiers.put((Object)class_5134.field_23721, (Object)new class_1322("Attack Damage", 2.0, class_1322.class_1323.field_6328));
        }
        if (stack.method_7909() == ModItems.QUAZARITH_SWORD) {
            if (crystal == CrystalType.WHITE) {
                modifiers2 = CrystalUpgrade.addAttribute((Multimap<class_1320, class_1322>)modifiers, modifiers2, class_5134.field_23721, class_1792.field_8006, "Attack Damage", 20.0, class_1322.class_1323.field_6328);
                modifiers2 = CrystalUpgrade.addAttribute((Multimap<class_1320, class_1322>)modifiers, modifiers2, class_5134.field_23723, class_1792.field_8001, "Attack Speed", 2.0, class_1322.class_1323.field_6328);
                modifiers2 = CrystalUpgrade.addAttribute((Multimap<class_1320, class_1322>)modifiers, modifiers2, class_5134.field_23719, UUID.randomUUID(), "Movement Speed", 20.0, class_1322.class_1323.field_6328);
            }
            if (crystal == CrystalType.ORANGE) {
                modifiers2 = CrystalUpgrade.addAttribute((Multimap<class_1320, class_1322>)modifiers, modifiers2, class_5134.field_23719, UUID.randomUUID(), "Movement Speed", 20.0, class_1322.class_1323.field_6328);
            }
        }
        if (stack.method_7909() == ModItems.QUAZARITH_HELMET && crystal == CrystalType.WHITE) {
            modifiers.put((Object)class_5134.field_23721, (Object)new class_1322("Attack Damage", 2.0, class_1322.class_1323.field_6328));
        }
        if (stack.method_7909() == ModItems.QUAZARITH_CHESTPLATE && crystal == CrystalType.WHITE) {
            modifiers.put((Object)class_5134.field_23721, (Object)new class_1322("Attack Damage", 2.0, class_1322.class_1323.field_6328));
        }
        if (stack.method_7909() == ModItems.QUAZARITH_LEGGINGS && crystal == CrystalType.WHITE) {
            modifiers.put((Object)class_5134.field_23721, (Object)new class_1322("Attack Damage", 2.0, class_1322.class_1323.field_6328));
        }
        if (stack.method_7909() == ModItems.QUAZARITH_BOOTS && crystal == CrystalType.WHITE) {
            modifiers.put((Object)class_5134.field_23721, (Object)new class_1322("Attack Damage", 2.0, class_1322.class_1323.field_6328));
        }
        Multimap<class_1320, class_1322> finalModifiers = modifiers2;
        modifiers.forEach((entityAttribute, entityAttributeModifier) -> {
            int[] check = new int[]{0};
            finalModifiers.forEach((entityAttribute2, entityAttributeModifier2) -> {
                SculkDepths.LOGGER.info(entityAttribute.toString() + ", " + entityAttributeModifier.toString());
                if (entityAttributeModifier2.method_6189().equals(entityAttributeModifier.method_6189())) {
                    check[0] = 1;
                }
            });
            if (check[0] == 0) {
                finalModifiers.put(entityAttribute, entityAttributeModifier);
            }
        });
        class_1304 slot2 = CrystalUpgrade.getEquipmentSlot(stack.method_7909());
        finalModifiers.forEach((entityAttribute, entityAttributeModifier) -> stack.method_7916(entityAttribute, new class_1322(entityAttributeModifier.method_6189(), entityAttributeModifier.method_6185(), entityAttributeModifier.method_6186(), entityAttributeModifier.method_6182()), slot2));
    }

    public static Multimap<class_1320, class_1322> addAttribute(Multimap<class_1320, class_1322> modifiers, Multimap<class_1320, class_1322> modifiers2, class_1320 attribute, UUID uuid, String name, double value, class_1322.class_1323 operation) {
        int[] check = new int[]{0};
        modifiers.forEach((entityAttribute, entityAttributeModifier) -> {
            if (entityAttributeModifier.method_6189().equals(uuid)) {
                double originalValue;
                check[0] = 1;
                if (operation == class_1322.class_1323.field_6328) {
                    originalValue = entityAttributeModifier.method_6186();
                    modifiers2.put((Object)attribute, (Object)new class_1322(uuid, name, originalValue + value, operation));
                }
                if (operation == class_1322.class_1323.field_6331) {
                    originalValue = entityAttributeModifier.method_6186();
                    modifiers2.put((Object)attribute, (Object)new class_1322(uuid, name, originalValue * value, operation));
                }
            }
        });
        if (check[0] == 0) {
            modifiers2.put((Object)attribute, (Object)new class_1322(uuid, name, value, operation));
        }
        return modifiers2;
    }

    public static void addNbtToCrystalUpgrade(class_1799 stack, class_1657 player, CrystalType crystal) {
        class_2487 nbtData = stack.method_7969();
        nbtData.method_10582("sculk_depths.crystal", crystal.toString());
        stack.method_7980(nbtData);
    }

    public static void tooltipAdd() {
        ItemTooltipCallback.EVENT.register((stack, context, tooltip) -> {
            class_2520 nbtData;
            if (stack.method_31573(ModTags.Items.CRYSTAL_UPGRADE_ITEMS) && (nbtData = stack.method_7969().method_10580("sculk_depths.crystal")) != null) {
                int i = crystalItemNbtList.indexOf(nbtData.toString());
                int crystalUpgradeColor = crystalUpgradeColorArray[i];
                tooltip.add(1, class_2561.method_43471((String)"tooltip.sculk_depths.crystal_upgrade.tooltip").method_27692(class_124.field_1080));
                class_5250 crystalTooltipText = class_2561.method_43471((String)("tooltip.sculk_depths.crystal_upgrade.crystal." + nbtData));
                crystalTooltipText.method_10862(crystalTooltipText.method_10866().method_36139(crystalUpgradeColor));
                tooltip.add(2, crystalTooltipText);
            }
        });
    }
}

