/*
 * Decompiled with CFR 0.152.
 */
package net.ugi.sculk_depths.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import net.ugi.sculk_depths.SculkDepths;
import net.ugi.sculk_depths.config.ConfigHandler;

public class Config {
    public static void loadConfig() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "sculk_depths_config.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (configFile.exists()) {
            try {
                FileReader fileReader = new FileReader(configFile);
                SculkDepths.CONFIG = (ConfigHandler)gson.fromJson((Reader)fileReader, ConfigHandler.class);
                fileReader.close();
                Config.saveConfig();
            }
            catch (IOException e) {
                SculkDepths.LOGGER.warn("the config was not loaded: " + e.getLocalizedMessage());
            }
        } else {
            SculkDepths.CONFIG = new ConfigHandler();
            Config.saveConfig();
        }
    }

    public static void saveConfig() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "sculk_depths_config.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!configFile.getParentFile().exists()) {
            configFile.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(configFile);
            fileWriter.write(gson.toJson((Object)SculkDepths.CONFIG));
            fileWriter.close();
        }
        catch (IOException e) {
            SculkDepths.LOGGER.warn("the config was not saved: " + e.getLocalizedMessage());
        }
    }
}

