/*
 * Decompiled with CFR 0.152.
 */
package net.ugi.sculk_depths.block.custom;

import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.ugi.sculk_depths.block.ModBlocks;
import net.ugi.sculk_depths.block.custom.ModCauldron.FlumrockCauldronBlock;
import net.ugi.sculk_depths.block.custom.ModCauldron.SporeFlumrockCauldronBlock;
import net.ugi.sculk_depths.block.custom.PenebriumShroomBlock;
import net.ugi.sculk_depths.particle.ModParticleTypes;
import net.ugi.sculk_depths.state.property.ModProperties;
import org.jetbrains.annotations.Nullable;

public class SporeBlock
extends PenebriumShroomBlock {
    private static final class_265 DRIP_COLLISION_SHAPE = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public SporeBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        int i = pos.method_10263();
        int j = pos.method_10264();
        int k = pos.method_10260();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int l = 0; l < 14; ++l) {
            mutable.method_10103(i + class_3532.method_15395((class_5819)random, (int)-10, (int)10), j - random.method_43048(10), k + class_3532.method_15395((class_5819)random, (int)-10, (int)10));
            class_2680 blockState = world.method_8320((class_2338)mutable);
            if (blockState.method_26234((class_1922)world, (class_2338)mutable)) continue;
            world.method_8406((class_2394)ModParticleTypes.PENEBRIUM_SPORES, (double)mutable.method_10263() + random.method_43058(), (double)mutable.method_10264() + random.method_43058(), (double)mutable.method_10260() + random.method_43058(), 0.0, 0.0, 0.0);
        }
    }

    public boolean method_9542(class_2680 state) {
        return true;
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2338 pos2 = SporeBlock.getCauldronPos((class_1937)world, pos);
        if (pos2 == null) {
            return;
        }
        class_2680 CauldronBlockstate = world.method_8320(pos2);
        if (CauldronBlockstate == null) {
            return;
        }
        if (class_3532.method_15395((class_5819)random, (int)0, (int)(Math.abs(pos.method_10264() - pos2.method_10264()) + 1)) >= 2) {
            return;
        }
        if (CauldronBlockstate.method_26204() instanceof FlumrockCauldronBlock) {
            class_2680 newCauldronBlockState = ModBlocks.SPORE_FLUMROCK_CAULDRON.method_9564();
            world.method_8501(pos2, newCauldronBlockState);
            return;
        }
        if (CauldronBlockstate.method_26204() instanceof SporeFlumrockCauldronBlock) {
            if ((Integer)CauldronBlockstate.method_11654((class_2769)SporeFlumrockCauldronBlock.LEVEL) >= ModProperties.SPORE_LEVEL.method_11898().size()) {
                return;
            }
            class_2680 newCauldronBlockState = (class_2680)CauldronBlockstate.method_11657((class_2769)SporeFlumrockCauldronBlock.LEVEL, (Comparable)Integer.valueOf((Integer)CauldronBlockstate.method_11654((class_2769)SporeFlumrockCauldronBlock.LEVEL) + 1));
            world.method_8501(pos2, newCauldronBlockState);
        }
    }

    @Nullable
    private static class_2338 getCauldronPos(class_1937 world, class_2338 pos2) {
        BiPredicate<class_2338, class_2680> biPredicate = (pos, state) -> SporeBlock.canDripThrough((class_1922)world, pos, state);
        return SporeBlock.searchInDirection((class_1936)world, pos2, class_2350.field_11033.method_10171(), biPredicate, 11).orElse(null);
    }

    private static boolean canDripThrough(class_1922 world, class_2338 pos, class_2680 state) {
        if (state.method_26215()) {
            return true;
        }
        if (state.method_26216(world, pos)) {
            return false;
        }
        if (!state.method_26227().method_15769()) {
            return false;
        }
        class_265 voxelShape = state.method_26220(world, pos);
        return !class_259.method_1074((class_265)DRIP_COLLISION_SHAPE, (class_265)voxelShape, (class_247)class_247.field_16896);
    }

    private static Optional<class_2338> searchInDirection(class_1936 world, class_2338 pos, class_2350.class_2352 direction, BiPredicate<class_2338, class_2680> continuePredicate, int range) {
        class_2350 direction2 = class_2350.method_10156((class_2350.class_2352)direction, (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_2338.class_2339 mutable = pos.method_25503();
        for (int i = 1; i < range; ++i) {
            mutable.method_10098(direction2);
            class_2680 blockState = world.method_8320((class_2338)mutable);
            if (blockState.method_26204() instanceof FlumrockCauldronBlock || blockState.method_26204() instanceof SporeFlumrockCauldronBlock) {
                return Optional.of(mutable.method_10062());
            }
            if (!world.method_31601(mutable.method_10264()) && continuePredicate.test((class_2338)mutable, blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }
}

