/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.loadingbackgrounds;

import com.google.common.collect.Iterators;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.foxgirl.loadingbackgrounds.LoadingBackgrounds;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import net.minecraft.class_1060;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3304;
import net.minecraft.class_332;
import net.minecraft.class_3902;
import net.minecraft.class_437;
import net.minecraft.class_5944;
import net.minecraft.class_7417;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoadingBackgroundsImpl
extends class_437
implements LoadingBackgrounds {
    private static final Logger LOGGER = LogManager.getLogger((String)"loadingbackgrounds");
    private static LoadingBackgroundsImpl INSTANCE;
    private Config config = Config.DEFAULT;
    private boolean shouldLoadResources = true;
    private Iterator<class_2960> textures;
    private class_2960 texturePrevious;
    private class_2960 textureCurrent;
    private double stateSecondsStarted = LoadingBackgroundsImpl.seconds();
    private boolean stateIsFading = false;
    private final Set<String> loadingMessageTranslationKeys = new HashSet<String>(Arrays.asList("menu.generatingLevel", "menu.generatingTerrain", "menu.loadingForcedChunks", "menu.loadingLevel", "menu.preparingSpawn", "menu.savingChunks", "menu.savingLevel", "menu.working", "multiplayer.downloadingStats", "multiplayer.downloadingTerrain", "selectWorld.data_read", "selectWorld.loading_list", "selectWorld.resource_load", "resourcepack.downloading", "resourcepack.progress", "download.pack.title"));
    private static final long secondsStart;
    private static final Pattern PROFILE_NAME_PATTERN;

    public static LoadingBackgroundsImpl getInstance() {
        return INSTANCE;
    }

    public LoadingBackgroundsImpl() {
        super((class_2561)class_2561.method_43473());
        INSTANCE = this;
    }

    @Override
    public void init(@NotNull Path configDirectory, boolean shouldLoadResources) {
        LOGGER.info("Setting up Loading Backgrounds...");
        this.config = Config.read(configDirectory);
        this.shouldLoadResources = shouldLoadResources;
    }

    public boolean isLoadingMessage(@Nullable class_2561 message) {
        class_7417 content;
        if (message != null && (content = message.method_10851()) instanceof class_2588) {
            return this.loadingMessageTranslationKeys.contains(((class_2588)content).method_11022());
        }
        return false;
    }

    @NotNull
    public Position getPosition() {
        return this.config.position();
    }

    private void initFromScreen(class_437 screen) {
        this.field_22787 = LoadingBackgroundsImpl.getClient();
        this.field_22789 = screen.field_22789;
        this.field_22790 = screen.field_22790;
    }

    public void draw(class_332 context, class_437 screen) {
        double secondsNow = LoadingBackgroundsImpl.seconds();
        double secondsDiff = secondsNow - this.stateSecondsStarted;
        if (secondsDiff > Math.max(this.config.secondsStay(), this.config.secondsFade()) + 5.0 || this.textures == null) {
            secondsDiff = 0.0;
            this.stateSecondsStarted = secondsNow;
            this.stateIsFading = false;
            this.textures = this.getBackgroundTextures();
            if (this.textures == null) {
                this.drawDefaultBackground(context, screen);
                return;
            }
            this.texturePrevious = this.textures.next();
            this.textureCurrent = this.textures.next();
        }
        if (this.stateIsFading) {
            this.drawCustomBackground(context, screen, this.texturePrevious, this.config.brightness(), 1.0f);
            this.drawCustomBackground(context, screen, this.textureCurrent, this.config.brightness(), (float)Math.min(secondsDiff / this.config.secondsFade(), 1.0));
            if (secondsDiff > this.config.secondsFade()) {
                this.stateSecondsStarted = secondsNow;
                this.stateIsFading = false;
            }
        } else {
            this.drawCustomBackground(context, screen, this.textureCurrent, this.config.brightness(), 1.0f);
            if (secondsDiff > this.config.secondsStay()) {
                this.stateSecondsStarted = secondsNow;
                this.stateIsFading = true;
                this.texturePrevious = this.textureCurrent;
                this.textureCurrent = this.textures.next();
            }
        }
    }

    public void drawCustomBackground(class_332 context, class_437 screen, class_2960 texture, float brightness, float opacity) {
        this.initFromScreen(screen);
        TextureInfo textureInfo = (TextureInfo)LoadingBackgroundsImpl.getTextureManager().method_4619(texture);
        textureInfo.loadingbackgrounds$init();
        float textureWidth = textureInfo.loadingbackgrounds$getWidth();
        float textureHeight = textureInfo.loadingbackgrounds$getHeight();
        float screenWidth = screen.field_22789;
        float screenHeight = screen.field_22790;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        scaleX = screenWidth / textureWidth;
        scaleY = screenHeight / textureHeight;
        if (scaleX < scaleY) {
            scaleX = scaleY;
            offsetX = 0.0f - (screenWidth - textureWidth * scaleX) * 0.5f;
        } else {
            scaleY = scaleX;
            offsetY = 0.0f - (screenHeight - textureHeight * scaleY) * 0.5f;
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        class_5944 oldShader = RenderSystem.getShader();
        float[] oldShaderColor = RenderSystem.getShaderColor();
        int oldShaderTexture = RenderSystem.getShaderTexture((int)0);
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)opacity);
        context.method_25291(texture, 0, 0, 0, offsetX, offsetY, (int)screenWidth, (int)screenHeight, (int)(textureWidth * scaleX), (int)(textureHeight * scaleY));
        RenderSystem.setShader(() -> oldShader);
        RenderSystem.setShaderColor((float)oldShaderColor[0], (float)oldShaderColor[1], (float)oldShaderColor[2], (float)oldShaderColor[3]);
        RenderSystem.setShaderTexture((int)0, (int)oldShaderTexture);
        RenderSystem.disableBlend();
    }

    public void drawDefaultBackground(class_332 context, class_437 screen) {
        this.initFromScreen(screen);
        this.drawDefaultBackgroundActual(context, screen);
    }

    private void drawDefaultBackgroundActual(class_332 context, class_437 screen) {
        context.method_51422(0.25f, 0.25f, 0.25f, 1.0f);
        context.method_25291(field_44669, 0, 0, 0, 0.0f, 0.0f, this.field_22789, this.field_22790, 32, 32);
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static double seconds() {
        return (double)(System.nanoTime() - secondsStart) * 1.0E-9;
    }

    private static class_310 getClient() {
        return class_310.method_1551();
    }

    private static class_3300 getResourceManager() {
        return LoadingBackgroundsImpl.getClient().method_1478();
    }

    private static class_3283 getResourcePackManager() {
        return LoadingBackgroundsImpl.getClient().method_1520();
    }

    private static class_1060 getTextureManager() {
        return LoadingBackgroundsImpl.getClient().method_1531();
    }

    private static String getProfileID(class_3288 profile) {
        return profile.method_14463();
    }

    private static boolean matchesProfileNamePattern(String name) {
        return PROFILE_NAME_PATTERN.matcher(name).find();
    }

    private static boolean matchesProfileNamePattern(class_3288 profile) {
        return LoadingBackgroundsImpl.matchesProfileNamePattern(LoadingBackgroundsImpl.getProfileID(profile)) || LoadingBackgroundsImpl.matchesProfileNamePattern(profile.method_14457().getString());
    }

    private void reloadResourcePacks() {
        if (!this.shouldLoadResources) {
            return;
        }
        class_3304 resourceManager = (class_3304)LoadingBackgroundsImpl.getResourceManager();
        class_3283 resourcePackManager = LoadingBackgroundsImpl.getResourcePackManager();
        Collection profiles = resourcePackManager.method_14441();
        Collection profilesEnabled = resourcePackManager.method_14444();
        boolean reload = false;
        for (class_3288 profile : profiles) {
            if (profilesEnabled.contains(profile) || !LoadingBackgroundsImpl.matchesProfileNamePattern(profile)) continue;
            LOGGER.info("Enabling resource pack " + LoadingBackgroundsImpl.getProfileID(profile));
            resourcePackManager.method_49427(LoadingBackgroundsImpl.getProfileID(profile));
            reload = true;
        }
        if (reload) {
            resourceManager.method_18232((Executor)LoadingBackgroundsImpl.getClient(), (Executor)LoadingBackgroundsImpl.getClient(), CompletableFuture.completedFuture(class_3902.field_17274), resourcePackManager.method_29211());
        }
    }

    private Map<class_2960, class_3298> getBackgroundTextureResources() {
        return LoadingBackgroundsImpl.getResourceManager().method_14488("textures/gui/backgrounds", filename -> filename.method_12832().endsWith(".png"));
    }

    private Iterator<class_2960> getBackgroundTextures() {
        Map<class_2960, class_3298> resources = this.getBackgroundTextureResources();
        if (resources.isEmpty()) {
            this.reloadResourcePacks();
            resources = this.getBackgroundTextureResources();
            if (resources.isEmpty()) {
                return null;
            }
        }
        List<Object> textures = Arrays.asList(resources.keySet().toArray());
        Collections.shuffle(textures);
        return Iterators.cycle(textures);
    }

    static {
        secondsStart = System.nanoTime();
        PROFILE_NAME_PATTERN = Pattern.compile("load(ing)?[\\W_-]{0,3}(background|image|pic)", 2);
    }

    public record Config(double secondsStay, double secondsFade, float brightness, @NotNull Position position) {
        private static final Config DEFAULT = new Config(3.0, 0.75, 0.66f, Position.BOTTOM_RIGHT);
        private static final String DEFAULT_JSON = "{\n  // Amount of time that each background is displayed for\n  \"secondsStay\": 5.0,\n  // Amount of time it takes to fade between backgrounds\n  \"secondsFade\": 0.5,\n  // Background brightness, between 0.0 and 1.0\n  \"brightness\": 1.0,\n  // Level loading indicator position\n  // One of \"CENTER\", \"BOTTOM_LEFT\", \"BOTTOM_RIGHT\", \"TOP_LEFT\", or \"TOP_RIGHT\"\n  \"position\": \"BOTTOM_RIGHT\"\n}\n";
        private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().serializeNulls().setPrettyPrinting().setLenient().create();

        @NotNull
        public static Config read(@NotNull Path pathConfigDirectory) {
            Path pathFile = pathConfigDirectory.resolve("loadingbackgrounds-config.json");
            Path pathTemp = pathConfigDirectory.resolve("loadingbackgrounds-config.json.tmp");
            try {
                return (Config)GSON.fromJson((Reader)Files.newBufferedReader(pathFile), Config.class);
            }
            catch (NoSuchFileException cause) {
                LOGGER.error("Failed to read config, file not found");
            }
            catch (IOException cause) {
                LOGGER.error("Failed to read config, IO error", (Throwable)cause);
            }
            catch (JsonParseException cause) {
                LOGGER.error("Failed to read config, JSON error", (Throwable)cause);
            }
            catch (Exception cause) {
                LOGGER.error("Failed to read config", (Throwable)cause);
            }
            try {
                Files.writeString(pathTemp, (CharSequence)DEFAULT_JSON, new OpenOption[0]);
                Files.move(pathTemp, pathFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException cause) {
                LOGGER.error("Failed to write new config, IO error", (Throwable)cause);
            }
            catch (Exception cause) {
                LOGGER.error("Failed to write new config", (Throwable)cause);
            }
            return DEFAULT;
        }
    }

    public static enum Position {
        CENTER,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }

    public static interface TextureInfo {
        public void loadingbackgrounds$init();

        public int loadingbackgrounds$getWidth();

        public int loadingbackgrounds$getHeight();
    }
}

