/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.config;

import com.google.gson.annotations.SerializedName;
import eu.pb4.common.protection.api.CommonProtection;
import eu.pb4.graves.config.annotations.ConfigCategory;
import eu.pb4.graves.config.annotations.ConfigHidden;
import eu.pb4.graves.config.data.IconData;
import eu.pb4.graves.config.data.Variant;
import eu.pb4.graves.config.data.WrappedDateFormat;
import eu.pb4.graves.config.data.WrappedText;
import eu.pb4.graves.other.GenericCost;
import eu.pb4.graves.other.GravesXPCalculation;
import eu.pb4.graves.registry.IconItem;
import eu.pb4.predicate.api.BuiltinPredicates;
import eu.pb4.predicate.api.MinecraftPredicate;
import eu.pb4.predicate.api.PredicateContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class Config {
    public String _comment = "Before changing anything, see https://github.com/Patbox/UniversalGraves#configuration";
    @ConfigHidden
    @SerializedName(value="config_version")
    public int version = 3;
    @ConfigCategory
    @SerializedName(value="protection")
    public Protection protection = new Protection();
    @ConfigCategory
    @SerializedName(value="interactions")
    public Interactions interactions = new Interactions();
    @ConfigCategory
    @SerializedName(value="storage")
    public Storage storage = new Storage();
    @ConfigCategory
    @SerializedName(value="placement")
    public Placement placement = new Placement();
    @ConfigCategory
    @SerializedName(value="teleportation")
    public Teleportation teleportation = new Teleportation();
    @ConfigCategory
    @SerializedName(value="model")
    public Model model = new Model();
    @ConfigCategory
    @SerializedName(value="ui")
    public Ui ui = new Ui();
    @ConfigCategory
    @SerializedName(value="text")
    public Texts texts = new Texts();

    public String getGraveModel(class_3222 player) {
        PredicateContext context = PredicateContext.of((class_3222)player);
        for (Model.CheckedModel model : this.model.alternative) {
            if (!model.predicate.test(context).success()) continue;
            return model.model;
        }
        return this.model.defaultModelId;
    }

    private static List<String> getDefaultProtectedGui() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("${position} <gray>(${world})");
        list.add("<yellow>${death_cause}");
        list.add("<gray><lang:'text.graves.items_xp':'<white>${item_count}':'<white>${xp}'>");
        list.add("<blue><lang:'text.graves.protected_time':'<white>${protection_time}'>");
        list.add("<red><lang:'text.graves.break_time':'<white>${break_time}'>");
        return list;
    }

    private static List<String> getDefaultGui() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("${position} <gray>(${world})");
        list.add("<yellow>${death_cause}");
        list.add("<gray><lang:'text.graves.items_xp':'<white>${item_count}':'<white>${xp}'>");
        list.add("<blue><lang:'text.graves.not_protected'>");
        list.add("<red><lang:'text.graves.break_time':'<white>${break_time}'>");
        return list;
    }

    private static List<String> getDefaultProtectedGuiWithName() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("<dark_gray>[<white>${player}</>]</> ${position} <gray>(${world})");
        list.add("<yellow>${death_cause}");
        list.add("<gray><lang:'text.graves.items_xp':'<white>${item_count}':'<white>${xp}'>");
        list.add("<blue><lang:'text.graves.protected_time':'<white>${protection_time}'>");
        list.add("<red><lang:'text.graves.break_time':'<white>${break_time}'>");
        return list;
    }

    private static List<String> getDefaultGuiWithName() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("<dark_gray>[<white>${player}</>]</> ${position} <gray>(${world})");
        list.add("<yellow>${death_cause}");
        list.add("<gray><lang:'text.graves.items_xp':'<white>${item_count}':'<white>${xp}'>");
        list.add("<blue><lang:'text.graves.not_protected'>");
        list.add("<red><lang:'text.graves.break_time':'<white>${break_time}'>");
        return list;
    }

    public void fillMissing() {
        for (class_2960 id : CommonProtection.getProviderIds()) {
            if (id.method_12836().equals("universal_graves") || this.placement.blockInProtection.containsKey(id.toString())) continue;
            this.placement.blockInProtection.put(id, false);
        }
    }

    public String getFormattedTime(long time) {
        if (time < 0L) {
            return "0" + this.texts.secondsText;
        }
        long seconds = time % 60L;
        long minutes = time / 60L % 60L;
        long hours = time / 3600L % 24L;
        long days = time / 86400L % 365L;
        long years = time / 31536000L;
        StringBuilder builder = new StringBuilder();
        if (years > 0L) {
            builder.append(years).append(this.texts.yearsText);
        }
        if (days > 0L) {
            builder.append(days).append(this.texts.daysText);
        }
        if (hours > 0L) {
            builder.append(hours).append(this.texts.hoursText);
        }
        if (minutes > 0L) {
            builder.append(minutes).append(this.texts.minutesText);
        }
        if (seconds > 0L || time <= 0L) {
            builder.append(seconds).append(this.texts.secondsText);
        }
        return builder.toString();
    }

    public static WrappedText ofText(String s) {
        return WrappedText.of(s);
    }

    public static class Protection {
        @SerializedName(value="non_owner_protection_time")
        public int protectionTime = 900;
        @SerializedName(value="self_destruction_time")
        public int breakingTime = 1800;
        @SerializedName(value="drop_items_on_expiration")
        public boolean dropItemsAfterExpiring = true;
        @SerializedName(value="attackers_bypass_protection")
        public boolean allowAttackersToTakeItems = false;
        @SerializedName(value="use_real_time")
        public boolean useRealTime = false;
    }

    public static class Interactions {
        @SerializedName(value="unlocking_cost")
        public GenericCost<?> cost = new GenericCost<Object>(GenericCost.Type.FREE, null, 0);
        @SerializedName(value="give_death_compass")
        public boolean giveGraveCompass = true;
        @SerializedName(value="enable_use_death_compass_to_open_gui")
        public boolean useDeathCompassToOpenGui = true;
        @SerializedName(value="enable_click_to_open_gui")
        public boolean clickGraveToOpenGui = true;
        @SerializedName(value="shift_and_use_quick_pickup")
        public boolean shiftClickTakesItems = true;
        @SerializedName(value="allow_remote_protection_removal")
        public boolean allowRemoteProtectionRemoval = true;
        @SerializedName(value="allow_remote_breaking")
        public boolean allowRemoteGraveBreaking = true;
        @SerializedName(value="allow_remote_unlocking")
        public boolean allowRemoteGraveUnlocking;
    }

    public static class Storage {
        @SerializedName(value="experience_type")
        public GravesXPCalculation xpStorageType = GravesXPCalculation.PERCENT_POINTS;
        @SerializedName(value="experience_percent:setting_value")
        public double xpPercentTypeValue = 100.0;
        @SerializedName(value="can_store_only_xp")
        public boolean canStoreOnlyXp = false;
        @SerializedName(value="alternative_experience_entity")
        public boolean useAlternativeXPEntity = FabricLoader.getInstance().isModLoaded("origins") || FabricLoader.getInstance().isModLoaded("bewitchment");
        @SerializedName(value="blocked_enchantments")
        public Set<class_2960> skippedEnchantments = new HashSet<class_2960>();
    }

    public static class Placement {
        @SerializedName(value="player_grave_limit")
        public int maxGraveCount = -1;
        @SerializedName(value="replace_any_block")
        public boolean replaceAnyBlock = false;
        @SerializedName(value="max_distance_from_source_location")
        public int maxPlacementDistance = 8;
        @SerializedName(value="shift_location_on_failure")
        public boolean shiftLocationOnFailure = true;
        @SerializedName(value="max_shift_tries")
        public int maxShiftCount = 5;
        @SerializedName(value="max_shift_distance")
        public int shiftDistance = 40;
        @SerializedName(value="generate_on_top_of_fluids")
        public boolean generateOnTopOfFluids = false;
        @SerializedName(value="generate_on_ground")
        public boolean generateOnGround = false;
        @SerializedName(value="create_gravestone_after_emptying")
        public boolean createVisualGrave = false;
        @SerializedName(value="restore_replaced_block_after_player_breaking")
        public boolean restoreBlockAfterPlayerBreaking = true;
        @SerializedName(value="cancel_creation_for_damage_types")
        public HashMap<class_2960, WrappedText> ignoredDamageTypes = new HashMap();
        @SerializedName(value="cancel_creation_for_ignored_attacker_types")
        public HashMap<class_1299<?>, WrappedText> ignoredAttackers = new HashMap();
        @SerializedName(value="blocking_predicates")
        public ArrayList<PredicateBlocker> predicates = new ArrayList();
        @SerializedName(value="block_in_protected_area")
        public Map<class_2960, Boolean> blockInProtection = new HashMap<class_2960, Boolean>();
        @SerializedName(value="blacklisted_worlds")
        public Set<class_2960> blacklistedWorlds = new HashSet<class_2960>();
        @SerializedName(value="blacklisted_areas")
        public Map<class_2960, List<Arena>> blacklistedAreas = new HashMap<class_2960, List<Arena>>();
        @SerializedName(value="creation_default_failure_text")
        public WrappedText messageCreationFailed = Config.ofText("<red><lang:'text.graves.creation_failed':'<gold>${position}':'<yellow>${world}'>");
        @SerializedName(value="creation_claim_failure_text")
        public WrappedText messageCreationFailedClaim = Config.ofText("<red><lang:'text.graves.creation_failed_claim':'<gold>${position}':'<yellow>${world}'>");

        public static class PredicateBlocker {
            @SerializedName(value="require")
            public MinecraftPredicate predicate;
            @SerializedName(value="message")
            public WrappedText text;
        }
    }

    public static class Teleportation {
        @SerializedName(value="cost")
        public GenericCost<?> cost = new GenericCost<Object>(GenericCost.Type.CREATIVE, null, 1);
        @SerializedName(value="required_time")
        public int teleportTime = 5;
        @SerializedName(value="y_offset")
        public double teleportHeight = 1.0;
        @SerializedName(value="invincibility_time")
        public int invincibleTime = 2;
        @SerializedName(value="allow_movement_while_waiting")
        public boolean allowMovingDuringTeleportation = false;
        @SerializedName(value="text")
        public Texts text = new Texts();

        public static class Texts {
            @SerializedName(value="timer")
            public WrappedText teleportTimerText = Config.ofText("<lang:'text.graves.teleport.teleport_timer':'${time}'>");
            @SerializedName(value="timer_allow_moving")
            public WrappedText teleportTimerTextAllowMoving = Config.ofText("<lang:'text.graves.teleport.teleport_timer_moving':'${time}'>");
            @SerializedName(value="location")
            public WrappedText teleportLocationText = Config.ofText("<lang:'text.graves.teleport.teleport_location':'${position}'>");
            @SerializedName(value="canceled")
            public WrappedText teleportCancelledText = Config.ofText("<red><lang:'text.graves.teleport.teleport_cancelled'>");
        }
    }

    public static class Model {
        @SerializedName(value="default")
        public String defaultModelId = "default";
        @SerializedName(value="alternative")
        public List<CheckedModel> alternative = new ArrayList<CheckedModel>();
        @SerializedName(value="enable_geyser_workaround")
        public boolean geyserWorkaround = true;
        @SerializedName(value="gravestone_item_base")
        public class_1792 gravestoneItemBase = class_1802.field_8398;
        @SerializedName(value="gravestone_item_nbt")
        public class_2487 gravestoneItemNbt = new class_2487();

        public class CheckedModel {
            @SerializedName(value="require")
            public MinecraftPredicate predicate = BuiltinPredicates.operatorLevel((int)0);
            @SerializedName(value="model")
            public String model = "default";
        }
    }

    public static class Ui {
        @SerializedName(value="title")
        public WrappedText graveTitle = Config.ofText("<lang:'text.graves.players_grave':'${player}'>");
        @SerializedName(value="admin_title")
        public WrappedText adminGraveListTitle = Config.ofText("<lang:'text.graves.admin_graves'>");
        @SerializedName(value="list_grave_icon")
        public Variant<IconData> listGraveIcon = Variant.of(IconData.of(class_1802.field_8106, Config.getDefaultProtectedGui()), IconData.of(class_1802.field_8247, Config.getDefaultGui()));
        @SerializedName(value="admin_list_grave_icon")
        public Variant<IconData> listAllGraveIcon = Variant.of(IconData.of(class_1802.field_8106, Config.getDefaultProtectedGuiWithName()), IconData.of(class_1802.field_8247, Config.getDefaultGuiWithName()));
        @SerializedName(value="grave_info")
        public Variant<IconData> graveInfoIcon = Variant.of(IconData.of(class_1802.field_8788, Config.getDefaultProtectedGui()), IconData.of(class_1802.field_8788, Config.getDefaultGui()));
        @SerializedName(value="unlock_grave")
        public Variant<IconData> unlockButton = Variant.of(IconData.of(class_1802.field_8695, "<#ffd257><lang:'text.graves.gui.unlock_grave'>", "<white><lang:'text.graves.gui.cost'> <#cfcfcf>${cost}"), IconData.of(class_1802.field_8695, "<dark_gray><lang:'text.graves.gui.unlock_grave'>", "<white><lang:'text.graves.gui.cost'> <#cfcfcf>${cost} <gray>(<red><lang:'text.graves.gui.cost.not_enough'></red>)"));
        @SerializedName(value="previous_button")
        public Variant<IconData> previousButton = Variant.of(IconData.of(IconItem.Texture.PREVIOUS_PAGE, "<lang:'text.graves.gui.previous_page'>"), IconData.of(IconItem.Texture.PREVIOUS_PAGE_BLOCKED, "<dark_gray><lang:'text.graves.gui.previous_page'>"));
        @SerializedName(value="next_button")
        public Variant<IconData> nextButton = Variant.of(IconData.of(IconItem.Texture.NEXT_PAGE, "<lang:'text.graves.gui.next_page'>"), IconData.of(IconItem.Texture.NEXT_PAGE_BLOCKED, "<dark_gray><lang:'text.graves.gui.next_page'>"));
        @SerializedName(value="remove_protection_button")
        public Variant<IconData> removeProtectionButton = Variant.of(IconData.of(IconItem.Texture.REMOVE_PROTECTION, "<red><lang:'text.graves.gui.remove_protection'>"), IconData.of(IconItem.Texture.REMOVE_PROTECTION, List.of("<red><lang:'text.graves.gui.remove_protection'>", "<dark_red><bold><lang:'text.graves.gui.cant_reverse'>", "", "<white><lang:'text.graves.gui.click_to_confirm'>")));
        @SerializedName(value="break_grave_button")
        public Variant<IconData> breakGraveButton = Variant.of(IconData.of(IconItem.Texture.BREAK_GRAVE, "<red><lang:'text.graves.gui.break_grave'>"), IconData.of(IconItem.Texture.BREAK_GRAVE, List.of("<red><lang:'text.graves.gui.break_grave'>", "<dark_red><bold><lang:'text.graves.gui.cant_reverse'>", "", "<white><lang:'text.graves.gui.click_to_confirm'>")));
        @SerializedName(value="quick_pickup_button")
        public IconData quickPickupButton = IconData.of(IconItem.Texture.QUICK_PICKUP, "<red><lang:'text.graves.gui.quick_pickup'>");
        @SerializedName(value="fetch_button")
        public Variant<IconData> fetchButton = Variant.of(IconData.of(class_1802.field_8719, "<yellow><lang:'text.graves.gui.fetch'>"), IconData.of(class_1802.field_8719, "<yellow><lang:'text.graves.gui.fetch'>"));
        @SerializedName(value="teleport_button")
        public Variant<IconData> teleportButton = Variant.of(IconData.of(class_1802.field_8634, "<#a52dfa><lang:'text.graves.gui.teleport'>", "<white><lang:'text.graves.gui.cost'> <#cfcfcf>${cost}"), IconData.of(class_1802.field_8634, "<dark_gray><lang:'text.graves.gui.teleport'>", "<white><lang:'text.graves.gui.cost'> <#cfcfcf>${cost} <gray>(<red><lang:'text.graves.gui.cost.not_enough'></red>)"));
        @SerializedName(value="back_button")
        public IconData backButton = IconData.of(class_1802.field_8615, "<red><lang:'text.graves.gui.quick_pickup'>");
        @SerializedName(value="bar")
        public IconData barButton = IconData.of(class_1802.field_8736, "");
    }

    public static class Texts {
        @SerializedName(value="grave_created")
        public WrappedText messageGraveCreated = Config.ofText("<white><lang:'text.graves.created_at_expire':'<yellow>${position}':'<gray>${world}':'<red>${break_time}'>");
        @SerializedName(value="protection_ended")
        public WrappedText messageProtectionEnded = Config.ofText("<red><lang:'text.graves.no_longer_protected':'<gold>${position}':'<white>${world}':'<yellow>${item_count}'>");
        @SerializedName(value="grave_expired")
        public WrappedText messageGraveExpired = Config.ofText("<red><lang:'text.graves.expired':'<gold>${position}':'<white>${world}':'<yellow>${item_count}'>");
        @SerializedName(value="grave_broken")
        public WrappedText messageGraveBroken = Config.ofText("<gray><lang:'text.graves.somebody_broke':'<white>${position}':'<white>${world}':'<white>${item_count}'>");
        @SerializedName(value="grave_access_payment_no_access")
        public WrappedText cantPayForThisGrave = Config.ofText("<red><lang:'text.graves.grave_unlock_payment.no_access'>");
        @SerializedName(value="grave_payment_accepted")
        public WrappedText graveUnlocked = Config.ofText("<white><lang:'text.graves.grave_unlock_payment.accepted'>");
        @SerializedName(value="grave_payment_failed")
        public WrappedText graveNotEnoughCost = Config.ofText("<red><lang:'text.graves.grave_unlock_payment.failed':'<yellow>${cost}'>");
        @SerializedName(value="years_suffix")
        public String yearsText = "y";
        @SerializedName(value="days_suffix")
        public String daysText = "d";
        @SerializedName(value="hours_suffix")
        public String hoursText = "h";
        @SerializedName(value="minutes_suffix")
        public String minutesText = "m";
        @SerializedName(value="seconds_suffix")
        public String secondsText = "s";
        @SerializedName(value="infinity")
        public String infinityText = "\u221e";
        @SerializedName(value="date_format")
        public WrappedDateFormat fullDateFormat = WrappedDateFormat.of("dd.MM.yyyy, HH:mm");
        @SerializedName(value="world_names")
        public Map<class_2960, WrappedText> worldNameOverrides = new HashMap<class_2960, WrappedText>();
    }

    public class Arena {
        public int x1;
        public int y1;
        public int z1;
        public int x2;
        public int y2;
        public int z2;

        public boolean contains(int x, int y, int z) {
            return this.x1 < x && this.x2 > x && this.y1 < y && this.y2 > y && this.z1 < z && this.z2 > z;
        }
    }
}

