/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.debug;

import com.mojang.blaze3d.systems.RenderSystem;
import com.sonicether.soundphysics.SoundPhysicsMod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;

public class RaycastRenderer {
    private static final List<Ray> rays = Collections.synchronizedList(new ArrayList());
    private static final class_310 mc = class_310.method_1551();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderRays(class_4587 poseStack, class_4597.class_4598 bufferSource, double x, double y, double z) {
        if (RaycastRenderer.mc.field_1687 == null) {
            return;
        }
        if (!SoundPhysicsMod.CONFIG.renderSoundBounces.get().booleanValue() && !SoundPhysicsMod.CONFIG.renderOcclusion.get().booleanValue()) {
            List<Ray> list = rays;
            synchronized (list) {
                rays.clear();
            }
            return;
        }
        long gameTime = RaycastRenderer.mc.field_1687.method_8510();
        List<Ray> list = rays;
        synchronized (list) {
            rays.removeIf(ray -> gameTime - ray.tickCreated > ray.lifespan || gameTime - ray.tickCreated < 0L);
            for (Ray ray2 : rays) {
                RaycastRenderer.renderRay(ray2, poseStack, bufferSource, x, y, z);
            }
        }
    }

    public static void addSoundBounceRay(class_243 start, class_243 end, int color) {
        if (!SoundPhysicsMod.CONFIG.renderSoundBounces.get().booleanValue()) {
            return;
        }
        RaycastRenderer.addRay(start, end, color, false);
    }

    public static void addOcclusionRay(class_243 start, class_243 end, int color) {
        if (!SoundPhysicsMod.CONFIG.renderOcclusion.get().booleanValue()) {
            return;
        }
        RaycastRenderer.addRay(start, end, color, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRay(class_243 start, class_243 end, int color, boolean throughWalls) {
        if (RaycastRenderer.mc.field_1724.method_19538().method_1022(start) > 32.0 && RaycastRenderer.mc.field_1724.method_19538().method_1022(end) > 32.0) {
            return;
        }
        List<Ray> list = rays;
        synchronized (list) {
            rays.add(new Ray(start, end, color, throughWalls));
        }
    }

    public static void renderRay(Ray ray, class_4587 poseStack, class_4597.class_4598 bufferSource, double x, double y, double z) {
        poseStack.method_22903();
        int red = RaycastRenderer.getRed(ray.color);
        int green = RaycastRenderer.getGreen(ray.color);
        int blue = RaycastRenderer.getBlue(ray.color);
        if (ray.throughWalls) {
            RenderSystem.disableDepthTest();
        }
        class_4588 consumer = bufferSource.getBuffer(class_1921.method_49043((double)1.0));
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        consumer.method_22918(matrix4f, (float)(ray.start.field_1352 - x), (float)(ray.start.field_1351 - y), (float)(ray.start.field_1350 - z)).method_1336(red, green, blue, 255).method_1344();
        consumer.method_22918(matrix4f, (float)(ray.end.field_1352 - x), (float)(ray.end.field_1351 - y), (float)(ray.end.field_1350 - z)).method_1336(red, green, blue, 255).method_1344();
        poseStack.method_22909();
    }

    private static int getRed(int argb) {
        return argb >> 16 & 0xFF;
    }

    private static int getGreen(int argb) {
        return argb >> 8 & 0xFF;
    }

    private static int getBlue(int argb) {
        return argb & 0xFF;
    }

    private static class Ray {
        private final class_243 start;
        private final class_243 end;
        private final int color;
        private final long tickCreated;
        private final long lifespan;
        private final boolean throughWalls;

        public Ray(class_243 start, class_243 end, int color, boolean throughWalls) {
            this.start = start;
            this.end = end;
            this.color = color;
            this.throughWalls = throughWalls;
            this.tickCreated = RaycastRenderer.mc.field_1687.method_8510();
            this.lifespan = 40L;
        }
    }
}

