/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.config;

import com.sonicether.soundphysics.SoundPhysics;
import com.sonicether.soundphysics.SoundPhysicsMod;
import com.sonicether.soundphysics.config.SoundTypes;
import com.sonicether.soundphysics.configbuilder.CommentedPropertyConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2498;

public class OcclusionConfig
extends CommentedPropertyConfig {
    private Map<class_2498, Double> occlusion;

    public OcclusionConfig(Path path) {
        super(path);
        this.save();
    }

    @Override
    public void load() throws IOException {
        super.load();
        this.occlusion = this.createDefaultMap();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            double value;
            String key = entry.getKey();
            try {
                value = Double.parseDouble(entry.getValue());
            }
            catch (NumberFormatException e) {
                SoundPhysics.LOGGER.warn("Failed to parse occlusion factor of {}", (Object)key);
                continue;
            }
            class_2498 soundType = SoundTypes.getSoundType(key);
            if (soundType == null) {
                SoundPhysics.LOGGER.warn("Sound type {} not found", (Object)key);
                continue;
            }
            this.occlusion.put(soundType, value);
        }
    }

    @Override
    public void saveSync() {
        this.properties.clear();
        for (Map.Entry<class_2498, Double> entry : this.occlusion.entrySet()) {
            this.properties.set(SoundTypes.getName(entry.getKey()), String.valueOf(entry.getValue()), new String[0]);
        }
        super.saveSync();
    }

    public Map<class_2498, Double> getOcclusionFactors() {
        return this.occlusion;
    }

    public double getOcclusionFactor(class_2498 soundType) {
        return this.occlusion.getOrDefault(soundType, SoundPhysicsMod.CONFIG.defaultBlockOcclusionFactor.get());
    }

    public OcclusionConfig setOcclusionFactor(class_2498 soundType, double value) {
        this.occlusion.put(soundType, value);
        return this;
    }

    public Map<class_2498, Double> createDefaultMap() {
        HashMap<class_2498, Double> map = new HashMap<class_2498, Double>();
        for (class_2498 type : SoundTypes.getTranslationMap().keySet()) {
            map.put(type, SoundPhysicsMod.CONFIG.defaultBlockOcclusionFactor.get());
        }
        map.put(class_2498.field_11543, 1.5);
        map.put(class_2498.field_28697, 0.75);
        map.put(class_2498.field_21214, 0.5);
        map.put(class_2498.field_11537, 0.1);
        map.put(class_2498.field_11548, 0.1);
        map.put(class_2498.field_27884, 0.1);
        map.put(class_2498.field_11542, 0.1);
        map.put(class_2498.field_11538, 0.1);
        map.put(class_2498.field_11534, 0.1);
        map.put(class_2498.field_28696, 0.1);
        map.put(class_2498.field_22140, 0.0);
        map.put(class_2498.field_23082, 0.0);
        map.put(class_2498.field_23083, 0.0);
        map.put(class_2498.field_17579, 0.0);
        map.put(class_2498.field_28693, 0.0);
        map.put(class_2498.field_28699, 0.0);
        map.put(class_2498.field_22138, 0.0);
        map.put(class_2498.field_28061, 0.0);
        map.put(class_2498.field_16498, 0.0);
        map.put(class_2498.field_28427, 0.0);
        map.put(class_2498.field_17580, 0.0);
        map.put(class_2498.field_22154, 0.0);
        map.put(class_2498.field_25183, 0.0);
        map.put(class_2498.field_27201, 0.0);
        map.put(class_2498.field_27200, 0.0);
        map.put(class_2498.field_27199, 0.0);
        map.put(class_2498.field_11532, 0.0);
        map.put(class_2498.field_24119, 0.0);
        return map;
    }
}

