/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.BzBiomeBlobLayer;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.BzBiomeLayer;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.BzBiomeMergeLayer;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.BzBiomePillarLayer;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.BzBiomePollinatedFieldsLayer;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.BzBiomePollinatedPillarLayer;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.BzBiomeScaleLayer;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.vanilla.Area;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.vanilla.AreaFactory;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.vanilla.AreaTransformer1;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.vanilla.BigContext;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.vanilla.Layer;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.vanilla.LazyArea;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.vanilla.LazyAreaContext;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.vanilla.ZoomLayer;
import java.util.Set;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2960;
import net.minecraft.class_4543;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6885;

public class BzBiomeSource
extends class_1966
implements class_4543.class_4544 {
    public static final Codec<BzBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").orElse((Object)0L).stable().forGetter(bzBiomeProvider -> bzBiomeProvider.seed), (App)class_1959.field_26750.fieldOf("blob_biomes").orElse((Object)class_6885.method_40246((class_6880[])new class_6880[0])).forGetter(biomeSource -> biomeSource.blobBiomes), (App)class_1959.field_26750.fieldOf("rare_blob_biomes").orElse((Object)class_6885.method_40246((class_6880[])new class_6880[0])).forGetter(biomeSource -> biomeSource.rareBlobBiomes), (App)class_1959.field_26750.fieldOf("main_biomes").orElse((Object)class_6885.method_40246((class_6880[])new class_6880[0])).forGetter(biomeSource -> biomeSource.mainBiomes)).apply((Applicative)instance, instance.stable(BzBiomeSource::new)));
    public static final class_2960 HIVE_WALL = new class_2960("the_bumblezone", "hive_wall");
    public static final class_2960 HIVE_PILLAR = new class_2960("the_bumblezone", "hive_pillar");
    public static final class_2960 SUGAR_WATER_FLOOR = new class_2960("the_bumblezone", "sugar_water_floor");
    public static final class_2960 POLLINATED_FIELDS = new class_2960("the_bumblezone", "pollinated_fields");
    public static final class_2960 POLLINATED_PILLAR = new class_2960("the_bumblezone", "pollinated_pillar");
    public static final class_2960 CRYSTAL_CANYON = new class_2960("the_bumblezone", "crystal_canyon");
    private final long seed;
    private final Layer biomeSampler;
    public final class_6885<class_1959> blobBiomes;
    public final class_6885<class_1959> rareBlobBiomes;
    public final class_6885<class_1959> mainBiomes;
    public final GeneralUtils.Lazy<Set<class_6880<class_1959>>> lazyPossibleBiomes = new GeneralUtils.Lazy();

    public BzBiomeSource(long seed, class_6885<class_1959> blobBiomes, class_6885<class_1959> rareBlobBiomes, class_6885<class_1959> mainBiomes) {
        this.seed = seed;
        this.blobBiomes = blobBiomes;
        this.rareBlobBiomes = rareBlobBiomes;
        this.mainBiomes = mainBiomes;
        this.biomeSampler = BzBiomeSource.buildWorldProcedure(seed, this.blobBiomes, this.rareBlobBiomes);
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    protected Stream<class_6880<class_1959>> method_49494() {
        return this.lazyPossibleBiomes.getOrCompute(() -> Stream.concat(Stream.concat(this.blobBiomes.method_40239(), this.mainBiomes.method_40239()), this.rareBlobBiomes.method_40239()).collect(Collectors.toSet())).stream();
    }

    public Set<class_6880<class_1959>> method_28443() {
        return this.lazyPossibleBiomes.getOrCompute(() -> Stream.concat(Stream.concat(this.blobBiomes.method_40239(), this.mainBiomes.method_40239()), this.rareBlobBiomes.method_40239()).collect(Collectors.toSet()));
    }

    public static <T extends Area, C extends BigContext<T>> AreaFactory<T> stack(long seed, AreaTransformer1 parent, AreaFactory<T> incomingArea, int count, LongFunction<C> contextFactory) {
        AreaFactory<T> LayerFactory = incomingArea;
        for (int i = 0; i < count; ++i) {
            LayerFactory = parent.run((BigContext)contextFactory.apply(seed + (long)i), LayerFactory);
        }
        return LayerFactory;
    }

    public static Layer buildWorldProcedure(long seed, class_6885<class_1959> blobBiomes, class_6885<class_1959> rareBlobBiomes) {
        AreaFactory<LazyArea> layerFactory = BzBiomeSource.build(salt -> new LazyAreaContext(25, seed, salt), seed, blobBiomes, rareBlobBiomes);
        return new Layer(layerFactory);
    }

    public static <T extends Area, C extends BigContext<T>> AreaFactory<T> build(LongFunction<C> contextFactory, long seed, class_6885<class_1959> blobBiomes, class_6885<class_1959> rareBlobBiomes) {
        AreaFactory layer = new BzBiomeLayer(seed).run((BigContext)contextFactory.apply(200L));
        layer = new BzBiomePillarLayer().run((BigContext)contextFactory.apply(1008L), layer);
        layer = new BzBiomeScaleLayer(Set.of(HIVE_PILLAR)).run((BigContext)contextFactory.apply(1055L), layer);
        layer = ZoomLayer.FUZZY.run((BigContext)contextFactory.apply(2003L), layer);
        layer = ZoomLayer.FUZZY.run((BigContext)contextFactory.apply(2523L), layer);
        layer = new BzBiomeScaleLayer(Set.of(CRYSTAL_CANYON, SUGAR_WATER_FLOOR)).run((BigContext)contextFactory.apply(54088L), layer);
        AreaFactory layerOverlay = new BzBiomeBlobLayer(blobBiomes, rareBlobBiomes).run((BigContext)contextFactory.apply(204L));
        layerOverlay = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2423L), layerOverlay);
        layerOverlay = new BzBiomePollinatedPillarLayer().run((BigContext)contextFactory.apply(3008L), layerOverlay);
        layerOverlay = new BzBiomeScaleLayer(Set.of(POLLINATED_PILLAR)).run((BigContext)contextFactory.apply(4455L), layerOverlay);
        layerOverlay = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2503L), layerOverlay);
        layerOverlay = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2603L), layerOverlay);
        layerOverlay = new BzBiomePollinatedFieldsLayer().run((BigContext)contextFactory.apply(3578L), layerOverlay);
        layerOverlay = new BzBiomeScaleLayer(Set.of(POLLINATED_FIELDS)).run((BigContext)contextFactory.apply(4055L), layerOverlay);
        layerOverlay = ZoomLayer.FUZZY.run((BigContext)contextFactory.apply(2853L), layerOverlay);
        layerOverlay = ZoomLayer.FUZZY.run((BigContext)contextFactory.apply(3583L), layerOverlay);
        layerOverlay = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(4583L), layerOverlay);
        layer = new BzBiomeMergeLayer().run((BigContext)contextFactory.apply(5583L), layerOverlay, layer);
        return layer;
    }

    public class_6880<class_1959> method_38109(int x, int y, int z, class_6544.class_6552 sampler) {
        return this.biomeSampler.sample(x, z);
    }

    public class_6880<class_1959> method_16359(int x, int y, int z) {
        return this.biomeSampler.sample(x, z);
    }
}

