/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminPose;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_3730;
import net.minecraft.class_4970;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5819;

public class EssenceBlockGreen
extends EssenceBlock {
    private static final int ROOTMIN_HEALTH = 30;
    private static final float STAGE_2_THRESHOLD = 0.75f;
    private static final float STAGE_3_THRESHOLD = 0.575f;
    private static final float STAGE_4_THRESHOLD = 0.3f;
    private static final float STAGE_5_THRESHOLD = 0.15f;

    public EssenceBlockGreen() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_15995));
    }

    @Override
    public class_2960 getArenaNbt() {
        return new class_2960("the_bumblezone", "essence/green_arena");
    }

    @Override
    public int getEventTimeFrame() {
        return 6000;
    }

    @Override
    public void awardPlayerWinStat(class_3222 serverPlayer) {
        serverPlayer.method_7281(BzStats.LIFE_EVENT_DEFEATED_RL.get());
    }

    @Override
    public ServerEssenceEvent getServerEssenceEvent() {
        return (ServerEssenceEvent)new ServerEssenceEvent("essence.the_bumblezone.green_essence_event", class_1259.class_1260.field_5785, class_1259.class_1261.field_5796).method_5406(true);
    }

    @Override
    public class_2960 getEssenceItemReward() {
        return new class_2960("the_bumblezone", "gameplay/rewards/green_arena_victory");
    }

    @Override
    public int getEssenceXpReward() {
        return 3000;
    }

    @Override
    public boolean hasMiningFatigue() {
        return true;
    }

    @Override
    public void performUniqueArenaTick(class_3218 serverLevel, class_2338 blockPos, class_2680 blockState, EssenceBlockEntity essenceBlockEntity) {
        class_2338 rootminPos = blockPos.method_10069(9, -3, 0);
        List<EssenceBlockEntity.EventEntities> eventEntitiesInArena = essenceBlockEntity.getEventEntitiesInArena();
        if (eventEntitiesInArena.isEmpty()) {
            EssenceBlockGreen.spawnRootmin(serverLevel, essenceBlockEntity, rootminPos, eventEntitiesInArena);
            if (eventEntitiesInArena.size() == 1) {
                List frames = serverLevel.method_18467(class_1530.class, new class_238((double)((float)blockPos.method_10263() - (float)essenceBlockEntity.getArenaSize().method_10263() * 0.5f), (double)((float)blockPos.method_10264() - (float)essenceBlockEntity.getArenaSize().method_10264() * 0.5f), (double)((float)blockPos.method_10260() - (float)essenceBlockEntity.getArenaSize().method_10260() * 0.5f), (double)((float)blockPos.method_10263() + (float)essenceBlockEntity.getArenaSize().method_10263() * 0.5f), (double)((float)blockPos.method_10264() + (float)essenceBlockEntity.getArenaSize().method_10264() * 0.5f), (double)((float)blockPos.method_10260() + (float)essenceBlockEntity.getArenaSize().method_10260() * 0.5f)));
                frames.forEach(frame -> eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(frame.method_5667())));
            }
        }
        if (!eventEntitiesInArena.isEmpty()) {
            RootminEntity rootminEntity;
            EssenceBlockEntity.EventEntities eventEntity;
            class_1297 entity = null;
            Iterator<EssenceBlockEntity.EventEntities> iterator = eventEntitiesInArena.iterator();
            while (iterator.hasNext() && !((entity = serverLevel.method_14190((eventEntity = iterator.next()).uuid())) instanceof RootminEntity)) {
                entity = null;
            }
            float progress = essenceBlockEntity.getEventBar().method_5412();
            if (progress == 0.0f && entity == null) {
                EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, true);
                return;
            }
            if (entity == null) {
                entity = EssenceBlockGreen.spawnRootmin(serverLevel, essenceBlockEntity, rootminPos, eventEntitiesInArena);
            }
            if (entity == null || !(entity instanceof RootminEntity) || !(rootminEntity = (RootminEntity)entity).getEssenceController().equals(essenceBlockEntity.getUUID())) {
                eventEntitiesInArena.remove(0);
                return;
            }
            int hitsLeft = Math.round(progress * 30.0f);
            RootminPose rootminPose = rootminEntity.getRootminPose();
            if (!rootminEntity.method_29504()) {
                rootminEntity.method_6033(hitsLeft);
            }
            float rootminHealthPercent = rootminEntity.method_6032() / 30.0f;
            if (rootminPose == RootminPose.SHOCK || rootminPose == RootminPose.ANGRY || rootminPose == RootminPose.CURSE) {
                if (rootminEntity.method_6065() != null && rootminPose == RootminPose.SHOCK) {
                    if (rootminHealthPercent > 0.75f && rootminHealthPercent < 0.8f) {
                        rootminEntity.runAngry();
                    } else if (rootminHealthPercent > 0.575f && rootminHealthPercent < 0.625f) {
                        rootminEntity.runAngry();
                    } else if (rootminHealthPercent > 0.3f && rootminHealthPercent < 0.35000002f) {
                        rootminEntity.runCurse();
                    } else if (rootminHealthPercent <= 0.3f) {
                        rootminEntity.setRootminPose(RootminPose.NONE);
                    }
                    --hitsLeft;
                    rootminEntity.method_6015(null);
                }
            } else {
                boolean fire;
                class_243 desiredRootminSpot = class_243.method_24953((class_2382)rootminPos).method_1031(0.0, -0.5, 0.0);
                if (!rootminEntity.method_19538().equals((Object)desiredRootminSpot)) {
                    class_243 diff = desiredRootminSpot.method_1020(rootminEntity.method_19538());
                    if (diff.method_1033() <= 3.0 && diff.method_1033() > 0.05) {
                        class_243 moveDirection = diff.method_1021(0.1);
                        rootminEntity.method_18800(moveDirection.method_10216(), moveDirection.method_10214(), moveDirection.method_10215());
                    } else if (diff.method_1033() > 3.0) {
                        rootminEntity.method_29495(desiredRootminSpot);
                    }
                }
                int interval = rootminHealthPercent > 0.3f && rootminHealthPercent <= 0.575f ? class_3532.method_48781((float)rootminHealthPercent, (int)15, (int)35) : class_3532.method_48781((float)rootminHealthPercent, (int)10, (int)45);
                boolean bl = fire = rootminEntity.field_6012 % interval == 0;
                if (!fire && rootminHealthPercent <= 0.3f) {
                    boolean bl2 = fire = (rootminEntity.field_6012 + 4) % interval == 0;
                    if (!fire && rootminHealthPercent <= 0.15f) {
                        boolean bl3 = fire = (rootminEntity.field_6012 + 7) % interval == 0;
                    }
                }
                if (fire && !rootminEntity.method_29504()) {
                    class_2338 playerArea = blockPos.method_10069(-9, -3, 0);
                    List players = serverLevel.method_18467(class_1657.class, new class_238((double)(playerArea.method_10263() - 1), (double)(playerArea.method_10264() - 1), (double)(playerArea.method_10260() - 1), (double)(playerArea.method_10263() + 2), (double)(playerArea.method_10264() + 3), (double)(playerArea.method_10260() + 2)));
                    if (essenceBlockEntity.getEventTimer() < this.getEventTimeFrame() - 100 && !players.isEmpty()) {
                        boolean isHoming;
                        boolean bl4 = isHoming = rootminHealthPercent > 0.3f && rootminHealthPercent <= 0.575f;
                        if (isHoming) {
                            class_5819 randomSource = rootminEntity.method_6051();
                            rootminEntity.method_5702(class_2183.class_2184.field_9853, ((class_1657)players.get(0)).method_19538().method_1031(randomSource.method_43058() * 21.0 - 10.0, randomSource.method_43058() * 21.0 - 10.0, randomSource.method_43058() * 21.0 - 10.0));
                        } else {
                            rootminEntity.method_5702(class_2183.class_2184.field_9853, ((class_1657)players.get(0)).method_19538());
                        }
                        if (rootminHealthPercent > 0.575f && rootminHealthPercent <= 0.75f) {
                            rootminEntity.runMultiShoot((class_1309)players.get(0), (float)class_3532.method_16436((double)rootminHealthPercent, (double)1.1, (double)0.8), 3);
                        } else {
                            rootminEntity.runShoot((class_1309)players.get(0), isHoming ? 0.8f : (float)class_3532.method_16436((double)rootminHealthPercent, (double)1.7, (double)0.85), isHoming);
                        }
                    } else {
                        rootminEntity.method_5702(class_2183.class_2184.field_9853, class_243.method_24954((class_2382)class_2350.field_11039.method_10163()).method_1019(rootminEntity.method_19538()));
                    }
                }
            }
            float newProgress = (float)hitsLeft / 30.0f;
            essenceBlockEntity.getEventBar().method_5408(newProgress);
            essenceBlockEntity.method_5431();
        }
    }

    private static class_1297 spawnRootmin(class_3218 serverLevel, EssenceBlockEntity essenceBlockEntity, class_2338 rootminPos, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        class_1297 entity = BzEntities.ROOTMIN.get().method_47821(serverLevel, rootminPos, class_3730.field_16461);
        if (entity instanceof RootminEntity) {
            class_1324 knockbackResistanceAttribute;
            RootminEntity rootminEntity = (RootminEntity)entity;
            rootminEntity.setEssenceController(essenceBlockEntity.getUUID());
            rootminEntity.setEssenceControllerBlockPos(essenceBlockEntity.method_11016());
            rootminEntity.setEssenceControllerDimension((class_5321<class_1937>)serverLevel.method_27983());
            class_1324 livingEntityAttributeHealth = rootminEntity.method_5996(class_5134.field_23716);
            if (livingEntityAttributeHealth != null) {
                float extraHealth = 30.0f - rootminEntity.method_6063();
                livingEntityAttributeHealth.method_26837(new class_1322(UUID.fromString("03c85bd0-09eb-11ee-be56-0242ac120002"), "Essence Arena Health Boost", (double)extraHealth, class_1322.class_1323.field_6328));
                rootminEntity.method_6025(extraHealth + rootminEntity.method_6063());
            }
            if ((knockbackResistanceAttribute = rootminEntity.method_5996(class_5134.field_23718)) != null) {
                knockbackResistanceAttribute.method_26837(new class_1322(UUID.fromString("0ebdc338-5575-11ee-8c99-0242ac120002"), "Essence Arena Knockback Resistance Boost", 0.25, class_1322.class_1323.field_6328));
            }
            entity.method_5702(class_2183.class_2184.field_9851, class_243.method_24954((class_2382)class_2350.field_11035.method_10163()));
            eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(entity.method_5667()));
        }
        return entity;
    }

    @Override
    public void onPlayerEnter(class_3218 serverLevel, class_3222 serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((class_1657)serverPlayer, BzSounds.LIFE_EVENT.get().method_14833(), true);
        super.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
    }

    @Override
    public void onPlayerLeave(class_3218 serverLevel, class_3222 serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((class_1657)serverPlayer, BzSounds.LIFE_EVENT.get().method_14833(), false);
        super.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
    }
}

