/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.mixin.WorldSavePathMixin;
import com.tiviacz.travelersbackpack.util.LogHelper;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BackpackManager {
    public static class_5218 BACKPACKS = WorldSavePathMixin.invokeInit("backpacks");

    public static void addBackpack(class_3222 player, class_1799 stack) {
        try {
            LocalDateTime deathTime = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy-HH.mm.ss");
            String formattedDeathTime = deathTime.format(formatter);
            String datedBackpackName = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString().replace(":", ".") + "_" + formattedDeathTime + ".dat";
            File backpackFile = BackpackManager.getBackpackFile(player, datedBackpackName);
            backpackFile.getParentFile().mkdirs();
            class_2507.method_10630((class_2487)stack.method_7953(new class_2487()), (File)backpackFile);
            LogHelper.info("Created new backpack backup file for " + player.method_5476().getString() + " with unique ID " + datedBackpackName, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static class_1799 getBackpack(class_3218 world, UUID playerUUID, String backpackId) {
        try {
            class_2487 data = class_2507.method_10633((File)BackpackManager.getBackpackFile(world, playerUUID, backpackId));
            if (data == null) {
                return null;
            }
            return class_1799.method_7915((class_2487)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static class_1799 getBackpack(class_3218 world, String backpackId) {
        File deathFolder = BackpackManager.getBackpackFolder(world);
        File[] players = deathFolder.listFiles((dir, name) -> name.matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$"));
        if (players == null) {
            return null;
        }
        for (File f : players) {
            File[] files;
            if (!f.isDirectory() || (files = f.listFiles((dir, name) -> name.equals(backpackId))) == null || files.length <= 0) continue;
            return BackpackManager.getBackpack(world, UUID.fromString(f.getName()), backpackId);
        }
        return null;
    }

    public static File getBackpackFile(class_3218 world, UUID playerUUID, String backpackId) {
        return new File(BackpackManager.getPlayerBackpackFolder(world, playerUUID), backpackId);
    }

    public static File getBackpackFile(class_3222 player, String backpackId) {
        return new File(BackpackManager.getPlayerBackpackFolder(player), backpackId);
    }

    public static File getPlayerBackpackFolder(class_3222 player) {
        return BackpackManager.getPlayerBackpackFolder(player.method_51469(), player.method_5667());
    }

    public static File getPlayerBackpackFolder(class_3218 world, UUID uuid) {
        return new File(BackpackManager.getBackpackFolder(world), uuid.toString());
    }

    public static File getBackpackFolder(class_3218 world) {
        return BackpackManager.getWorldFolder(world, BACKPACKS);
    }

    public static File getWorldFolder(class_3218 serverWorld, class_5218 path) {
        return serverWorld.method_8503().method_27050(path).toFile();
    }
}

