/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.sailing;

import com.cursee.monolib.core.MonoLibConfiguration;
import com.cursee.monolib.platform.Services;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.ArrayUtils;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

public class Sailing {
    public static boolean shouldVerifyJars = true;
    private static final HashMap<String, String> jarFilenameToNameMap = new HashMap();
    private static final CopyOnWriteArrayList<String> registeredJarFilenames = new CopyOnWriteArrayList();
    private static String MOD_ID;
    private static String PUBLISHER;
    private static String AUTHOR;
    private static String PRIMARY_URL;
    private static String CURSE_FORGE_URL;
    private static String MODRINTH_URL;

    public static void register(String mod_name, String mod_id, String mod_version, String mc_version_raw, Pair<String, String> publisher_author, Triplet<String, String, String> primary_curseforge_modrinth) {
        String mc_version = mc_version_raw.replaceAll("\\[", "").replaceAll("]", "");
        String MERGED_FILENAME_SCHEMA = mod_id + "-merged-" + mc_version + "-" + mod_version + ".jar";
        registeredJarFilenames.add(MERGED_FILENAME_SCHEMA);
        jarFilenameToNameMap.put(MERGED_FILENAME_SCHEMA, mod_name);
        MOD_ID = mod_id;
        PUBLISHER = (String)publisher_author.getA();
        AUTHOR = (String)publisher_author.getB();
        PRIMARY_URL = (String)primary_curseforge_modrinth.getA();
        CURSE_FORGE_URL = (String)primary_curseforge_modrinth.getB();
        MODRINTH_URL = (String)primary_curseforge_modrinth.getC();
    }

    public static boolean onEntityJoinLevel(class_1937 level, class_1297 entity) {
        String checkedEntityTag = MOD_ID + ".checked";
        Set tags = entity.method_5752();
        if (tags.contains(checkedEntityTag)) {
            return true;
        }
        if (!(entity instanceof class_1309) || !MonoLibConfiguration.enableAntiRepostingCheck) {
            return true;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (shouldVerifyJars) {
                Sailing.joinWorldProcess(level, player);
            }
        }
        entity.method_5780(checkedEntityTag);
        return true;
    }

    public static void joinWorldProcess(class_1937 level, class_1657 player) {
        if (!(level instanceof class_3218) || !MonoLibConfiguration.enableAntiRepostingCheck) {
            return;
        }
        List<String> failedJarFilenames = Sailing.checkIfAllJarsExist();
        if (!failedJarFilenames.isEmpty() && Sailing.processPreJoinWorldCheck(level)) {
            Sailing.sendMessage(player, "Mod(s) from incorrect sources:", class_124.field_1061, PRIMARY_URL);
            for (String filename : failedJarFilenames) {
                Sailing.sendMessage(player, " - " + filename, class_124.field_1054, PRIMARY_URL);
            }
            Sailing.sendMessage(player, "You are receiving this message because you are using at least one of " + PUBLISHER + "'s mods, but probably haven't downloaded them from an original source. Unofficial sources can contain malicious software, supply no income for developers and host outdated versions.", class_124.field_1061, PRIMARY_URL);
            Sailing.sendMessage(player, PUBLISHER + "'s mod downloads are only officially available at CurseForge and Modrinth.", class_124.field_1077, PRIMARY_URL);
            Sailing.sendMessage(player, "  CF: " + CURSE_FORGE_URL, class_124.field_1054, CURSE_FORGE_URL);
            Sailing.sendMessage(player, "  MR: " + MODRINTH_URL, class_124.field_1054, MODRINTH_URL);
            Sailing.sendMessage(player, "You won't see this message again in this instance. Thank you for reading.", class_124.field_1077, PRIMARY_URL);
            Sailing.sendMessage(player, "-" + AUTHOR, class_124.field_1054, PRIMARY_URL);
            System.out.println("You are receiving this message because you are using at least one of " + PUBLISHER + "'s mods, but probably haven't downloaded them from an original source. Unofficial sources can contain malicious software, supply no income for developers and host outdated versions.");
            System.out.println(PUBLISHER + "'s mod downloads are only officially available at CurseForge and Modrinth.");
            System.out.println("  CF: " + CURSE_FORGE_URL);
            System.out.println("  MR: " + MODRINTH_URL);
            System.out.println("You won't see this message again in this instance. Thank you for reading.");
            System.out.println("-" + AUTHOR);
            Sailing.processPostJoinWorldCheck(level);
        }
        shouldVerifyJars = false;
    }

    private static boolean processPreJoinWorldCheck(class_1937 world) {
        String path = Sailing.getWorldPath((class_3218)world) + File.separator + "config" + File.separator + MOD_ID + File.separator + "checked.txt";
        File checkfile = new File(path);
        if (checkfile.exists()) {
            shouldVerifyJars = false;
        } else if (!Sailing.checkAlternative()) {
            shouldVerifyJars = false;
        }
        return shouldVerifyJars;
    }

    private static void processPostJoinWorldCheck(class_1937 world) {
        shouldVerifyJars = false;
        String path = Sailing.getWorldPath((class_3218)world) + File.separator + "config" + File.separator + MOD_ID;
        File dir = new File(path);
        if (!dir.mkdirs()) {
            return;
        }
        try {
            PrintWriter writer = new PrintWriter(path + File.separator + "checked.txt", StandardCharsets.UTF_8);
            writer.println("# Please check out https://stopmodreposts.org/ for more information on why this feature exists.");
            writer.println("checked=true");
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Sailing.createRepostingCheckFile();
    }

    public static void createRepostingCheckFile() {
        String alternativePath = Sailing.getConfigDirectory() + File.separator + MOD_ID;
        if (new File(alternativePath + File.separator + "checked.txt").isFile()) {
            return;
        }
        File alternativeDirectory = new File(alternativePath);
        if (!alternativeDirectory.mkdirs()) {
            return;
        }
        try {
            PrintWriter writer = new PrintWriter(alternativePath + File.separator + "checked.txt", StandardCharsets.UTF_8);
            writer.println("# Please check out https://stopmodreposts.org/ for more information on why this feature exists.");
            writer.println("checked=true");
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static List<String> checkIfAllJarsExist() {
        List<String> installedModFilenames = Sailing.getInstalledModJars();
        ArrayList<String> failedToVerify = new ArrayList<String>();
        for (String filename : registeredJarFilenames) {
            if (installedModFilenames.contains(filename) || installedModFilenames.contains(filename.replace("-merged-", "-fabric-")) || installedModFilenames.contains(filename.replace("-merged-", "-forge-")) || installedModFilenames.contains(filename.replace("-merged-", "-neoforge-")) || !jarFilenameToNameMap.containsKey(filename)) continue;
            failedToVerify.add(jarFilenameToNameMap.get(filename));
        }
        if (!failedToVerify.isEmpty()) {
            Collections.sort(failedToVerify);
        }
        return failedToVerify;
    }

    private static boolean checkAlternative() {
        String alternativePath = Sailing.getConfigDirectory() + File.separator + MOD_ID + "checked.txt";
        File alternativeFile = new File(alternativePath);
        return !alternativeFile.exists();
    }

    public static List<String> getInstalledModJars() {
        ArrayList<String> installedModFilenames = new ArrayList<String>();
        File modDirectory = new File(Sailing.getModDirectory());
        Object[] installedFilesArray = modDirectory.listFiles();
        File versionFolder = new File(Sailing.getModDirectory() + File.separator + Sailing.getCurrentMinecraftVersion());
        Object[] installedVersionsArray = versionFolder.listFiles();
        for (File file : (File[])ArrayUtils.addAll((Object[])installedFilesArray, (Object[])installedVersionsArray)) {
            if (!file.isFile()) continue;
            String filename = file.getName().replaceAll(" +\\([0-9]+\\)", "");
            installedModFilenames.add(filename);
        }
        return installedModFilenames;
    }

    public static void sendMessage(class_1657 player, String message, class_124 colour, boolean insertNewLineBeforeMessage, String url) {
        if (message.isEmpty()) {
            return;
        }
        if (insertNewLineBeforeMessage) {
            player.method_43496((class_2561)class_2561.method_43470((String)""));
        }
        class_5250 mutableMessage = class_2561.method_43470((String)message);
        mutableMessage.method_27692(colour);
        if (message.contains("http") || !url.isEmpty()) {
            if (url.isEmpty()) {
                for (String word : message.split(" ")) {
                    if (!word.contains("http")) continue;
                    url = word;
                    break;
                }
            }
            if (!url.isEmpty()) {
                class_2583 clickstyle = mutableMessage.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11749, url));
                mutableMessage.method_27696(clickstyle);
            }
        }
        player.method_43496((class_2561)mutableMessage);
    }

    public static void sendMessage(class_1657 player, String message, class_124 color, String url) {
        Sailing.sendMessage(player, message, color, false, url);
    }

    public static String getGameDirectory() {
        return Services.PLATFORM.getGameDirectory();
    }

    public static String getModDirectory() {
        return Sailing.getGameDirectory() + File.separator + "mods";
    }

    public static String getConfigDirectory() {
        return Sailing.getGameDirectory() + File.separator + "config";
    }

    public static String getCurrentMinecraftVersion() {
        return "1.20.1";
    }

    public static String getWorldPath(MinecraftServer server) {
        String path = server.method_27050(class_5218.field_24188).toString();
        return path.substring(0, path.length() - 2);
    }

    public static String getWorldPath(class_3218 level) {
        return Sailing.getWorldPath(level.method_8503());
    }
}

