/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.recipe.RecipeUtils;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.integration.AlexCavesCompat;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.amendments.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.PotionNBTHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5253;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class LiquidCauldronBlock
extends ModCauldronBlock {
    public static final int MAX_LEVEL = PlatHelper.getPlatform().isFabric() ? 3 : 4;
    public static final class_2758 LEVEL = PlatHelper.getPlatform().isFabric() ? class_2741.field_12513 : ModBlockProperties.LEVEL_1_4;
    public static final class_2758 LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL;
    public static final class_2746 BOILING = ModBlockProperties.BOILING;

    public LiquidCauldronBlock(class_4970.class_2251 properties) {
        super(properties.method_9631(value -> (Integer)value.method_11654((class_2769)LIGHT_LEVEL)));
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(1))).method_11657((class_2769)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).method_11657((class_2769)BOILING, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public class_2758 getLevelProperty() {
        return LEVEL;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{LEVEL, LIGHT_LEVEL, BOILING});
    }

    protected boolean method_32765(class_3611 fluid) {
        return fluid != class_3612.field_15910 && fluid != class_3612.field_15908;
    }

    public void method_32764(class_2680 state, class_1937 level, class_2338 pos, class_3611 fluid) {
        class_2586 class_25862;
        if (!this.method_32766(state) && (class_25862 = level.method_8321(pos)) instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)class_25862;
            SoftFluidStack sf = SoftFluidStack.fromFluid((class_3611)fluid, (int)1, null);
            if (!sf.isEmpty() && te.getSoftFluidTank().addFluid(sf, false) != 0) {
                level.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)state));
                level.method_20290(1047, pos, 0);
            }
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)class_25862;
            if (te.handleInteraction(player, hand)) {
                this.maybeSendPotionMixMessage(te.getSoftFluidTank(), player);
                return class_1269.method_29236((boolean)level.field_9236);
            }
            if (!CommonConfigs.CAULDRON_CRAFTING.get().booleanValue()) {
                return class_1269.field_5811;
            }
            SoftFluidTank tank = te.getSoftFluidTank();
            SoftFluidStack fluid = tank.getFluid();
            class_1799 stack = player.method_5998(hand);
            Pair<class_1799, Float> crafted = RecipeUtils.craftWithFluid(level, tank.getFluid(), stack, true);
            if (crafted != null) {
                int mult;
                int n = mult = fluid.is((SoftFluid)BuiltInSoftFluids.POTION.get()) ? CommonConfigs.POTION_RECIPES_PER_LAYER.get() : 1;
                if (this.doCraftItem(level, pos, player, hand, fluid, stack, (class_1799)crafted.getFirst(), ((Float)crafted.getSecond()).floatValue(), mult)) {
                    te.method_5431();
                    return class_1269.method_29236((boolean)level.field_9236);
                }
            }
        }
        return class_1269.field_5811;
    }

    public boolean method_32766(class_2680 state) {
        return (Integer)state.method_11654((class_2769)LEVEL) == MAX_LEVEL;
    }

    protected double method_31615(class_2680 state) {
        return 0.4375 + 0.125 * (double)((Integer)state.method_11654((class_2769)LEVEL)).intValue();
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
        class_2586 class_25862;
        class_2680 s = super.method_9559(state, direction, neighborState, level, currentPos, neighborPos);
        if (direction == class_2350.field_11033 && (class_25862 = level.method_8321(currentPos)) instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)class_25862;
            boolean isFire = LiquidCauldronBlock.shouldBoil(neighborState, te.getSoftFluidTank().getFluid());
            s = (class_2680)s.method_11657((class_2769)BOILING, (Comparable)Boolean.valueOf(isFire));
        }
        return s;
    }

    public static boolean shouldBoil(class_2680 belowState, SoftFluidStack fluid) {
        return belowState.method_26164(ModTags.HEAT_SOURCES) && fluid.is(ModTags.CAN_BOIL);
    }

    @Override
    protected void handleEntityInside(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        if (((Boolean)state.method_11654((class_2769)BOILING)).booleanValue() && entity instanceof class_1309) {
            entity.method_5643(new class_1282(ModRegistry.BOILING_DAMAGE.getHolder()), 1.0f);
        }
        if (entity instanceof class_1309) {
            class_2586 class_25862;
            class_1309 living = (class_1309)entity;
            if (entity.method_36971(level, pos) && (class_25862 = level.method_8321(pos)) instanceof LiquidCauldronBlockTile) {
                LiquidCauldronBlockTile tile = (LiquidCauldronBlockTile)class_25862;
                SoftFluidStack fluid = tile.getSoftFluidTank().getFluid();
                PotionNBTHelper.Type potType = this.getPotType(fluid);
                if (potType != null && potType != PotionNBTHelper.Type.REGULAR && this.applyPotionFluidEffects(level, pos, living, fluid)) {
                    tile.consumeOneLayer();
                }
                if (CompatHandler.ALEX_CAVES) {
                    AlexCavesCompat.acidDamage(fluid, level, pos, state, entity);
                }
            }
        }
    }

    private boolean applyPotionFluidEffects(class_1937 level, class_2338 pos, class_1309 living, SoftFluidStack stack) {
        List effects = class_1844.method_8066((class_2487)stack.getTag());
        boolean success = false;
        for (class_1293 effect : effects) {
            class_1291 ef = effect.method_5579();
            if (living.method_6059(ef)) continue;
            if (ef.method_5561()) {
                ef.method_5564(null, null, living, effect.method_5578(), 1.0);
            } else {
                living.method_6092(new class_1293(effect));
            }
            success = true;
        }
        if (success) {
            level.method_8396(null, pos, class_3417.field_14737, class_3419.field_15245, 1.0f, 1.0f);
        }
        return success;
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 rand) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)class_25862;
            SoftFluidTank tank = te.getSoftFluidTank();
            if (((Boolean)state.method_11654((class_2769)BOILING)).booleanValue()) {
                int color = tank.getCachedParticleColor((class_1920)level, pos);
                int light = tank.getFluidValue().getEmissivity();
                LiquidCauldronBlock.playBubblingAnimation(level, pos, this.method_31615(state), rand, color, light);
            }
            if (level.field_9229.method_43048(4) == 0) {
                SoftFluidStack fluid = tank.getFluid();
                PotionNBTHelper.Type type = this.getPotType(fluid);
                double height = this.method_31615(state);
                if (type != null) {
                    if (this.getPotionEffects(fluid).size() >= CommonConfigs.POTION_MIXING_LIMIT.get()) {
                        LiquidCauldronBlock.addSurfaceParticles((class_2394)class_2398.field_11251, level, pos, 2, height, rand, 0.0f, 0.0f, 0.0f);
                    }
                    if (type != PotionNBTHelper.Type.REGULAR) {
                        class_2400 particle = type == PotionNBTHelper.Type.SPLASH ? class_2398.field_11225 : class_2398.field_11226;
                        int color = tank.getCachedParticleColor((class_1920)level, pos);
                        this.addPotionParticles((class_2394)particle, level, pos, 1, height, rand, color);
                    }
                }
                if (CompatHandler.ALEX_CAVES) {
                    AlexCavesCompat.acidParticles(fluid, level, pos, rand, height);
                }
                class_2338 blockPos = pos.method_10084();
                if (fluid.is((SoftFluid)BuiltInSoftFluids.LAVA.get()) && level.method_8320(blockPos).method_26215() && !level.method_8320(blockPos).method_26216((class_1922)level, blockPos)) {
                    class_243 c = pos.method_46558();
                    if (rand.method_43048(20) == 0) {
                        LiquidCauldronBlock.addSurfaceParticles((class_2394)class_2398.field_11239, level, pos, 1, height, rand, 0.0f, 0.0f, 0.0f);
                        level.method_8486(c.field_1352, height, c.field_1350, class_3417.field_14576, class_3419.field_15245, 0.2f + rand.method_43057() * 0.2f, 0.9f + rand.method_43057() * 0.15f, false);
                    }
                    if (rand.method_43048(40) == 0) {
                        level.method_8486(c.field_1352, height, c.field_1350, class_3417.field_15021, class_3419.field_15245, 0.2f + rand.method_43057() * 0.2f, 0.9f + rand.method_43057() * 0.15f, false);
                    }
                }
            }
        }
    }

    @Nullable
    private PotionNBTHelper.Type getPotType(SoftFluidStack stack) {
        if (stack.is((SoftFluid)BuiltInSoftFluids.POTION.get()) && stack.hasTag()) {
            return PotionNBTHelper.getPotionType((class_2487)stack.getTag());
        }
        return null;
    }

    private List<class_1293> getPotionEffects(SoftFluidStack stack) {
        return class_1844.method_8066((class_2487)stack.getTag());
    }

    public static void playBubblingAnimation(class_1937 level, class_2338 pos, double surface, class_5819 rand, int color, int light) {
        class_2400 type = (class_2400)ModRegistry.BOILING_PARTICLE.get();
        int count = 2;
        LiquidCauldronBlock.addSurfaceParticles((class_2394)type, level, pos, count, surface, rand, color, (float)pos.method_10264() + 0.3125f, light);
        if (level.field_9229.method_43048(4) == 0) {
            level.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_15161, class_3419.field_15245, 0.4f + level.field_9229.method_43057() * 0.2f, 0.35f + level.field_9229.method_43057() * 0.2f, false);
        }
    }

    private void addPotionParticles(class_2394 type, class_1937 level, class_2338 pos, int count, double surface, class_5819 rand, int color) {
        float r = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float g = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float b = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        LiquidCauldronBlock.addSurfaceParticles(type, level, pos, count, surface, rand, r, g, b);
    }

    @Override
    public class_2680 updateStateOnFluidChange(class_2680 state, class_1937 level, class_2338 pos, SoftFluidStack fluid) {
        class_2680 exploded = this.maybeExplode(state, level, pos, fluid);
        if (exploded != null) {
            return exploded;
        }
        int light = fluid.fluid().getLuminosity();
        if (light != (Integer)state.method_11654((class_2769)ModBlockProperties.LIGHT_LEVEL)) {
            state = (class_2680)state.method_11657((class_2769)ModBlockProperties.LIGHT_LEVEL, (Comparable)Integer.valueOf(light));
        }
        int height = fluid.getCount();
        state = fluid.isEmpty() ? class_2246.field_10593.method_9564() : (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(height));
        return state;
    }

    public void maybeSendPotionMixMessage(SoftFluidTank fluidTank, class_1657 player) {
        List<class_1293> potionEffects;
        int potionEffectAmount;
        if (fluidTank.getFluid().is((SoftFluid)BuiltInSoftFluids.POTION.get()) && (potionEffectAmount = (potionEffects = this.getPotionEffects(fluidTank.getFluid())).size()) == CommonConfigs.POTION_MIXING_LIMIT.get()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.amendments.cauldron"), true);
        }
    }

    @Nullable
    private class_2680 maybeExplode(class_2680 state, class_1937 level, class_2338 pos, SoftFluidStack fluid) {
        List<class_1293> potionEffects = this.getPotionEffects(fluid);
        int potionEffectAmount = potionEffects.size();
        if (potionEffectAmount >= CommonConfigs.POTION_MIXING_LIMIT.get()) {
            if (potionEffectAmount > CommonConfigs.POTION_MIXING_LIMIT.get()) {
                level.method_22352(pos, true);
                class_243 vec3 = pos.method_46558();
                level.method_8454(null, level.method_48963().method_48808(vec3), null, vec3.field_1352, vec3.field_1351, vec3.field_1350, 1.4f, false, class_1937.class_7867.field_40888);
                return state;
            }
            if (level.field_9236) {
                LiquidCauldronBlock.addSurfaceParticles((class_2394)class_2398.field_11251, level, pos, 12, this.method_31615(state), level.field_9229, 0.0f, 0.0f, 0.0f);
            }
            level.method_8396(null, pos, class_3417.field_15222, class_3419.field_15245, 1.0f, 1.0f);
            return null;
        }
        Map<class_1291, class_1291> inverse = CommonConfigs.INVERSE_POTIONS.get();
        List<class_1291> effects = potionEffects.stream().map(class_1293::method_5579).toList();
        for (class_1291 effect : effects) {
            class_1291 inv = inverse.get(effect);
            if (inv == null || !effects.contains(inv)) continue;
            if (level.field_9236) {
                LiquidCauldronBlock.addSurfaceParticles((class_2394)class_2398.field_11203, level, pos, 8, this.method_31615(state), level.field_9229, 0.0f, 0.01f + level.field_9229.method_43057() * 0.1f, 0.0f);
            }
            level.method_8396(null, pos, class_3417.field_15222, class_3419.field_15245, 1.0f, 1.0f);
            return class_2246.field_10593.method_9564();
        }
        return null;
    }
}

