/*
 * Decompiled with CFR 0.152.
 */
package cristelknight.wwoo.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import cristelknight.wwoo.ExpandedEcosphere;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static class_5250 translatableText(String id) {
        return class_2561.method_43471((String)("expanded_ecosphere.config.text." + id));
    }

    public static <T> T readConfig(JsonElement load, Codec<T> codec, DynamicOps<JsonElement> ops) {
        DataResult decode = codec.decode(ops, (Object)load);
        Optional error = decode.error();
        if (error.isPresent()) {
            throw new IllegalArgumentException("Couldn't read " + load.toString() + ", crashing instead.");
        }
        return (T)((Pair)decode.result().orElseThrow()).getFirst();
    }

    public static ExpandedEcosphere.Mode getMode(String mode) {
        if (!ExpandedEcosphere.isTerraBlenderLoaded()) {
            return ExpandedEcosphere.Mode.DEFAULT;
        }
        try {
            return ExpandedEcosphere.Mode.valueOf(mode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            ExpandedEcosphere.LOGGER.warn("Invalid Mode '{}' for option '{}'", (Object)mode, (Object)"mode");
            return ExpandedEcosphere.Mode.DEFAULT;
        }
    }

    @Nullable
    public static JsonObject getObjectFromPath(Path path) {
        JsonObject jsonObject;
        InputStream im;
        try {
            if (path == null) {
                ExpandedEcosphere.LOGGER.error("Path was null");
                return null;
            }
            im = Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            ExpandedEcosphere.LOGGER.error("Couldn't read " + String.valueOf(path));
            return null;
        }
        InputStreamReader reader = new InputStreamReader(im);
        try {
            JsonElement el = JsonParser.parseReader((Reader)reader);
            if (!el.isJsonObject()) {
                throw new RuntimeException("Input stream is on JsonElement");
            }
            jsonObject = el.getAsJsonObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return jsonObject;
    }
}

