/*
 * Decompiled with CFR 0.152.
 */
package cristelknight.wwoo.config.cloth;

import cristelknight.wwoo.ExpandedEcosphere;
import cristelknight.wwoo.config.configs.EEConfig;
import cristelknight.wwoo.config.configs.ReplaceBiomesConfig;
import cristelknight.wwoo.terra.TerraInit;
import cristelknight.wwoo.utils.BiomeReplace;
import cristelknight.wwoo.utils.Util;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.DropdownBoxEntry;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListListEntry;
import me.shedaniel.clothconfig2.gui.entries.TextListEntry;
import me.shedaniel.clothconfig2.impl.builders.DropdownMenuBuilder;
import net.cristellib.CristelLib;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2358;
import net.minecraft.class_2465;
import net.minecraft.class_2493;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ClothConfigScreen {
    public class_437 create(class_437 parent) {
        EEConfig config = (EEConfig)EEConfig.DEFAULT.getConfig();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setDefaultBackgroundTexture(new class_2960(ClothConfigScreen.getIdentifier(config.backGroundBlock().method_26204()))).setTitle((class_2561)class_2561.method_43471((String)"expanded_ecosphere.config.title").method_27692(class_124.field_1067));
        ConfigEntries entries = new ConfigEntries(builder.entryBuilder(), builder.getOrCreateCategory(ClothConfigScreen.mainName("main")), builder.getOrCreateCategory(ClothConfigScreen.mainName("biomes")), builder.getOrCreateCategory(ClothConfigScreen.mainName("modes")));
        builder.setSavingRunnable(() -> {
            EEConfig.DEFAULT.setInstance(entries.createConfig());
            EEConfig.DEFAULT.getConfig(true, true);
            ReplaceBiomesConfig.DEFAULT.setInstance(entries.createBiomesConfig());
            ReplaceBiomesConfig config2 = (ReplaceBiomesConfig)ReplaceBiomesConfig.DEFAULT.getConfig(true, true);
            if (ExpandedEcosphere.isTerraBlenderLoaded()) {
                TerraInit.terraEnableDisable();
            }
            if (config2.enableBiomes() && ExpandedEcosphere.currentMode.equals((Object)ExpandedEcosphere.Mode.DEFAULT)) {
                BiomeReplace.replace();
            } else {
                CristelLib.DATA_PACK.removeData(new class_2960("minecraft", "dimension/overworld.json"));
            }
        });
        return builder.build();
    }

    private static class_2561 fieldName(String id) {
        return class_2561.method_43471((String)("expanded_ecosphere.config.entry." + id));
    }

    private static class_2561 mainName(String id) {
        return class_2561.method_43471((String)("expanded_ecosphere.config.category." + id));
    }

    private static class_2561 fieldToolTip(String id) {
        return class_2561.method_43471((String)("expanded_ecosphere.config.entry." + id + ".toolTip"));
    }

    private static String getIdentifier(class_2248 b) {
        Stream<String> s = Arrays.stream(class_7923.field_41175.method_10221((Object)b).toString().split(":"));
        List<String> l = s.toList();
        Object s2 = l.get(1);
        if (b instanceof class_2493 || b instanceof class_2323 || b.equals(class_2246.field_10183) || b.equals(class_2246.field_10083)) {
            s2 = (String)s2 + "_top";
        } else if (b.equals(class_2246.field_10375)) {
            s2 = (String)s2 + "_side";
        } else if (b.equals(class_2246.field_10164) || b.equals(class_2246.field_10382)) {
            s2 = (String)s2 + "_still";
        } else if (b instanceof class_2358) {
            s2 = (String)s2 + "_0";
        }
        return l.get(0) + ":textures/block/" + (String)s2 + ".png";
    }

    private static class ConfigEntries {
        private final ConfigEntryBuilder builder;
        private final BooleanListEntry removeOreBlobs;
        private final BooleanListEntry showUpdates;
        private final BooleanListEntry showBigUpdates;
        private final BooleanListEntry forceLargeBiomes;
        private final BooleanListEntry enableBiomes;
        @NotNull
        private final DropdownBoxEntry<class_2248> backgroundBlock;
        private final EnumListEntry<ExpandedEcosphere.Mode> mode;
        private final StringListListEntry biomeList;

        public ConfigEntries(ConfigEntryBuilder builder, ConfigCategory category1, ConfigCategory category2, ConfigCategory category3) {
            this.builder = builder;
            EEConfig config = (EEConfig)EEConfig.DEFAULT.getConfig();
            if (!ExpandedEcosphere.isTerraBlenderLoaded()) {
                this.textListEntry((class_2561)class_2561.method_43469((String)"expanded_ecosphere.config.text.requiresTerrablender", (Object[])new Object[]{"3.0.0.169"}), category3);
                this.textListEntry((class_2561)class_2561.method_43471((String)"expanded_ecosphere.config.text.downloadTB").method_27694(s -> s.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://modrinth.com/mod/terrablender"))), category3);
            }
            this.mode = builder.startEnumSelector(ClothConfigScreen.fieldName("selectMode"), ExpandedEcosphere.Mode.class, (Enum)ExpandedEcosphere.currentMode).setDefaultValue((Enum)ExpandedEcosphere.Mode.DEFAULT).build();
            category3.addEntry(this.mode);
            this.textListEntry((class_2561)class_2561.method_43471((String)"expanded_ecosphere.config.text.defaultMode").method_27692(class_124.field_1080), category3);
            this.textListEntry((class_2561)class_2561.method_43471((String)"expanded_ecosphere.config.text.compatibleMode").method_27692(class_124.field_1080), category3);
            this.enableBiomes = this.createBooleanField("enableBiomes", ((ReplaceBiomesConfig)ReplaceBiomesConfig.DEFAULT.getConfig()).enableBiomes(), ReplaceBiomesConfig.DEFAULT.enableBiomes(), category2, new class_2561[0]);
            this.biomeList = builder.startStrList(ClothConfigScreen.fieldName("biomeList"), ConfigEntries.convertMapToList(((ReplaceBiomesConfig)ReplaceBiomesConfig.DEFAULT.getConfig()).bannedBiomes())).setTooltip(new class_2561[]{ClothConfigScreen.fieldToolTip("biomeList")}).setDefaultValue(List.of()).build();
            category2.addEntry((AbstractConfigListEntry)this.biomeList);
            this.textListEntry((class_2561)class_2561.method_43471((String)"expanded_ecosphere.config.text.replaceBiomes").method_27692(class_124.field_1080), category2);
            this.textListEntry((class_2561)class_2561.method_43469((String)"expanded_ecosphere.config.text.modes", (Object[])new Object[]{class_2561.method_43470((String)ExpandedEcosphere.currentMode.toString()).method_27692(class_124.field_1064)}).method_27692(class_124.field_1080), category1);
            this.backgroundBlock = this.createBlockField("bB", config.backGroundBlock().method_26204(), EEConfig.DEFAULT.backGroundBlock().method_26204(), category1, List.of(FT.NO_BLOCK_ENTITY, FT.NO_BUTTON));
            this.showUpdates = this.createBooleanField("showUpdates", config.showUpdates(), EEConfig.DEFAULT.showUpdates(), category1, new class_2561[0]);
            this.showBigUpdates = this.createBooleanField("showBigUpdates", config.showBigUpdates(), EEConfig.DEFAULT.showBigUpdates(), category1, new class_2561[0]);
            this.removeOreBlobs = this.createBooleanField("removeOreBlobs", config.removeOreBlobs(), EEConfig.DEFAULT.removeOreBlobs(), category1, new class_2561[]{ClothConfigScreen.fieldToolTip("removeOreBlobs")});
            this.forceLargeBiomes = this.createBooleanField("forceLargeBiomes", config.forceLargeBiomes(), EEConfig.DEFAULT.forceLargeBiomes(), category1, new class_2561[0]);
            this.textListEntry((class_2561)Util.translatableText("forceLargeBiomes").method_27692(class_124.field_1080), category1);
        }

        public EEConfig createConfig() {
            ExpandedEcosphere.Mode currentMode;
            ExpandedEcosphere.currentMode = currentMode = (ExpandedEcosphere.Mode)((Object)this.mode.getValue());
            return new EEConfig(currentMode.toString(), this.forceLargeBiomes.getValue(), this.removeOreBlobs.getValue(), this.showUpdates.getValue(), this.showBigUpdates.getValue(), ((class_2248)this.backgroundBlock.getValue()).method_9564());
        }

        public ReplaceBiomesConfig createBiomesConfig() {
            return new ReplaceBiomesConfig(this.enableBiomes.getValue(), ConfigEntries.convertListToMap(this.biomeList.getValue()));
        }

        private static List<String> convertMapToList(Map<String, String> stringMap) {
            return stringMap.entrySet().stream().map(entry -> (String)entry.getKey() + "/" + (String)entry.getValue()).collect(Collectors.toList());
        }

        private static Map<String, String> convertListToMap(List<String> stringList) {
            return stringList.stream().map(s -> s.split("/")).filter(parts -> ((String[])parts).length == 2).collect(Collectors.toMap(parts -> parts[0], parts -> parts[1]));
        }

        private BooleanListEntry createBooleanField(String id, boolean value, boolean defaultValue, ConfigCategory category, class_2561[] tooltip) {
            BooleanListEntry e = this.builder.startBooleanToggle(ClothConfigScreen.fieldName(id), value).setDefaultValue(defaultValue).setTooltip(tooltip).build();
            category.addEntry((AbstractConfigListEntry)e);
            return e;
        }

        @NotNull
        private DropdownBoxEntry<class_2248> createBlockField(String id, class_2248 value, class_2248 defaultValue, ConfigCategory category, List<FT> filter) {
            DropdownMenuBuilder e = this.builder.startDropdownMenu(ClothConfigScreen.fieldName(id), DropdownMenuBuilder.TopCellElementBuilder.ofBlockObject((class_2248)value), DropdownMenuBuilder.CellCreatorBuilder.ofBlockObject()).setDefaultValue((Object)defaultValue).setSelections((Iterable)class_7923.field_41175.method_10220().sorted(Comparator.comparing(class_2248::toString)).filter(new BlockPredicate(filter)).collect(Collectors.toCollection(LinkedHashSet::new)));
            @NotNull DropdownBoxEntry entry = e.build();
            category.addEntry((AbstractConfigListEntry)entry);
            return entry;
        }

        public void textListEntry(class_2561 component, ConfigCategory category) {
            TextListEntry tle = this.builder.startTextDescription(component).build();
            category.addEntry((AbstractConfigListEntry)tle);
        }

        static class BlockPredicate
        implements Predicate<class_2248> {
            private final List<FT> filters;

            public BlockPredicate(List<FT> filters) {
                this.filters = filters;
            }

            @Override
            public boolean test(class_2248 block) {
                boolean b = true;
                for (FT filter : this.filters) {
                    if (block instanceof class_2189) {
                        b = false;
                    }
                    if (filter.equals((Object)FT.NO_BUTTON) && block instanceof class_2269) {
                        b = false;
                    }
                    if (filter.equals((Object)FT.PILLAR) && !(block instanceof class_2465)) {
                        b = false;
                    }
                    if (!filter.equals((Object)FT.NO_BLOCK_ENTITY) || !block.method_9564().method_31709()) continue;
                    b = false;
                }
                return b;
            }
        }
    }

    public static enum FT {
        NO_BUTTON,
        PILLAR,
        NO_BLOCK_ENTITY,
        NONE;

    }
}

