/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.google.common.collect.ImmutableMap;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4590;
import org.joml.Matrix4f;

public class SurroundingBlockData {
    private static final ThreadLocal<class_2338.class_2339> MUTABLE_POS = ThreadLocal.withInitial(class_2338.class_2339::new);
    private final Map<class_2960, Map<class_2350, SideConnections>> connections;
    private final int hashCode;

    public static SurroundingBlockData create(class_1920 level, class_2338 pos, class_4590 rotation, Map<class_2960, ConnectionPredicate> predicates) {
        class_4590 inverseRotation = rotation.method_22935();
        Matrix4f rotationMatrix = inverseRotation == null ? class_4590.method_22931().method_22936() : rotation.method_22936();
        Matrix4f inverseRotationMatrix = inverseRotation == null ? class_4590.method_22931().method_22936() : inverseRotation.method_22936();
        class_2680[][][] states = new class_2680[3][3][3];
        class_2338.class_2339 neighborPos = MUTABLE_POS.get();
        for (int i = 0; i < 27; ++i) {
            neighborPos.method_10103(pos.method_10263() + i % 3 - 1, pos.method_10264() + i / 3 % 3 - 1, pos.method_10260() + i / 9 % 3 - 1);
            states[i % 3][i / 3 % 3][i / 9 % 3] = level.method_8320((class_2338)neighborPos);
        }
        ImmutableMap.Builder connectionsBuilder = ImmutableMap.builder();
        for (class_2960 sprite : predicates.keySet()) {
            EnumMap<class_2350, SideConnections> spriteConnections = new EnumMap<class_2350, SideConnections>(class_2350.class);
            for (class_2350 side : class_2350.values()) {
                spriteConnections.put(side, SurroundingBlockData.getConnections(side, rotationMatrix, inverseRotationMatrix, states, predicates.get(sprite), level, pos));
            }
            connectionsBuilder.put((Object)sprite, spriteConnections);
        }
        return new SurroundingBlockData((Map<class_2960, Map<class_2350, SideConnections>>)connectionsBuilder.build());
    }

    private static SideConnections getConnections(class_2350 side, Matrix4f rotation, Matrix4f inverseRotation, class_2680[][][] states, ConnectionPredicate predicate, class_1920 level, class_2338 pos) {
        class_2350 down;
        class_2350 up;
        class_2350 right;
        class_2350 left;
        class_2350 originalSide = class_2350.method_23225((Matrix4f)inverseRotation, (class_2350)side);
        if (originalSide.method_10166() == class_2350.class_2351.field_11052) {
            left = class_2350.field_11039;
            right = class_2350.field_11034;
            up = originalSide == class_2350.field_11036 ? class_2350.field_11043 : class_2350.field_11035;
            down = originalSide == class_2350.field_11036 ? class_2350.field_11035 : class_2350.field_11043;
        } else {
            left = originalSide.method_10170();
            right = originalSide.method_10160();
            up = class_2350.field_11036;
            down = class_2350.field_11033;
        }
        left = class_2350.method_23225((Matrix4f)rotation, (class_2350)left);
        right = class_2350.method_23225((Matrix4f)rotation, (class_2350)right);
        up = class_2350.method_23225((Matrix4f)rotation, (class_2350)up);
        down = class_2350.method_23225((Matrix4f)rotation, (class_2350)down);
        class_2680 self = states[1][1][1];
        boolean connectTop = SurroundingBlockData.shouldConnect(states, side, originalSide, self, up.method_10148(), up.method_10164(), up.method_10165(), ConnectionDirection.TOP, predicate, level, pos);
        boolean connectTopRight = SurroundingBlockData.shouldConnect(states, side, originalSide, self, up.method_10148() + right.method_10148(), up.method_10164() + right.method_10164(), up.method_10165() + right.method_10165(), ConnectionDirection.TOP_RIGHT, predicate, level, pos);
        boolean connectRight = SurroundingBlockData.shouldConnect(states, side, originalSide, self, right.method_10148(), right.method_10164(), right.method_10165(), ConnectionDirection.RIGHT, predicate, level, pos);
        boolean connectBottomRight = SurroundingBlockData.shouldConnect(states, side, originalSide, self, down.method_10148() + right.method_10148(), down.method_10164() + right.method_10164(), down.method_10165() + right.method_10165(), ConnectionDirection.BOTTOM_RIGHT, predicate, level, pos);
        boolean connectBottom = SurroundingBlockData.shouldConnect(states, side, originalSide, self, down.method_10148(), down.method_10164(), down.method_10165(), ConnectionDirection.BOTTOM, predicate, level, pos);
        boolean connectBottomLeft = SurroundingBlockData.shouldConnect(states, side, originalSide, self, down.method_10148() + left.method_10148(), down.method_10164() + left.method_10164(), down.method_10165() + left.method_10165(), ConnectionDirection.BOTTOM_LEFT, predicate, level, pos);
        boolean connectLeft = SurroundingBlockData.shouldConnect(states, side, originalSide, self, left.method_10148(), left.method_10164(), left.method_10165(), ConnectionDirection.LEFT, predicate, level, pos);
        boolean connectTopLeft = SurroundingBlockData.shouldConnect(states, side, originalSide, self, up.method_10148() + left.method_10148(), up.method_10164() + left.method_10164(), up.method_10165() + left.method_10165(), ConnectionDirection.TOP_LEFT, predicate, level, pos);
        return new SideConnections(side, connectTop, connectTopRight, connectRight, connectBottomRight, connectBottom, connectBottomLeft, connectLeft, connectTopLeft);
    }

    private static boolean shouldConnect(class_2680[][][] states, class_2350 side, class_2350 originalSide, class_2680 self, int neighborX, int neighborY, int neighborZ, ConnectionDirection direction, ConnectionPredicate predicate, class_1920 level, class_2338 pos) {
        class_2680 otherState = states[neighborX + 1][neighborY + 1][neighborZ + 1];
        class_2338.class_2339 neighborPos = MUTABLE_POS.get();
        neighborPos.method_10103(pos.method_10263() + neighborX, pos.method_10264() + neighborY, pos.method_10260() + neighborZ);
        class_2680 selfAppearance = self.getAppearance(level, pos, side, otherState, (class_2338)neighborPos);
        class_2680 otherStateAppearance = otherState.getAppearance(level, (class_2338)neighborPos, side, self, pos);
        class_2680 stateInFront = states[neighborX + 1 + side.method_10148()][neighborY + 1 + side.method_10164()][neighborZ + 1 + side.method_10165()];
        return predicate.shouldConnect((class_1922)level, pos, originalSide, selfAppearance, otherStateAppearance, stateInFront, direction);
    }

    private SurroundingBlockData(Map<class_2960, Map<class_2350, SideConnections>> connections) {
        this.connections = connections;
        this.hashCode = this.connections.hashCode();
    }

    public SideConnections getConnections(class_2960 sprite, class_2350 side) {
        return (SideConnections)this.connections.getOrDefault(sprite, Collections.emptyMap()).get(side);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof SurroundingBlockData && this.hashCode == ((SurroundingBlockData)obj).hashCode;
    }

    public static final class SideConnections {
        public final class_2350 side;
        public final boolean top;
        public final boolean topRight;
        public final boolean right;
        public final boolean bottomRight;
        public final boolean bottom;
        public final boolean bottomLeft;
        public final boolean left;
        public final boolean topLeft;
        public final int hash;

        public SideConnections(class_2350 side, boolean top, boolean topRight, boolean right, boolean bottomRight, boolean bottom, boolean bottomLeft, boolean left, boolean topLeft) {
            this.side = side;
            this.top = top;
            this.topRight = topRight;
            this.right = right;
            this.bottomRight = bottomRight;
            this.bottom = bottom;
            this.bottomLeft = bottomLeft;
            this.left = left;
            this.topLeft = topLeft;
            this.hash = Objects.hash(this.top, this.topRight, this.right, this.bottomRight, this.bottom, this.bottomLeft, this.left, this.topLeft);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SideConnections that = (SideConnections)o;
            return this.left == that.left && this.right == that.right && this.top == that.top && this.topLeft == that.topLeft && this.topRight == that.topRight && this.bottom == that.bottom && this.bottomLeft == that.bottomLeft && this.bottomRight == that.bottomRight && this.side == that.side;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

