/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.fluids;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.supplementaries.common.block.blocks.GunpowderBlock;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteFluid;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteLiquidBlock;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6908;
import org.jetbrains.annotations.Nullable;

public class FlammableLiquidBlock
extends FiniteLiquidBlock
implements ILightable {
    public static final class_2758 AGE = class_2741.field_12498;
    public final class_265[] interactionShapes = (class_265[])IntStream.range(0, 16).mapToObj(i -> FlammableLiquidBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)Math.max(0.0f, 15.0f * (1.0f - (float)i / (float)this.maxLevel)), (double)16.0)).toArray(class_265[]::new);

    public FlammableLiquidBlock(Supplier<? extends FiniteFluid> supplier, class_4970.class_2251 arg) {
        super(supplier, arg.method_9631(state -> (Integer)state.method_11654((class_2769)AGE) > 0 ? 15 : 0));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{AGE});
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public int getFireSpreadSpeed(class_2680 state, class_1922 world, class_2338 pos, class_2350 face) {
        return 60;
    }

    public int getFlammability(class_2680 state, class_1922 world, class_2338 pos, class_2350 face) {
        return 300;
    }

    public void onCaughtFire(class_2680 state, class_1937 world, class_2338 pos, @Nullable class_2350 face, @Nullable class_1309 igniter) {
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
        class_2680 newState = super.method_9559(state, direction, neighborState, level, currentPos, neighborPos);
        if (GunpowderBlock.isFireSource(neighborState)) {
            newState = (class_2680)newState.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(1));
        }
        return newState;
    }

    @Override
    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        super.method_9612(state, level, pos, block, fromPos, isMoving);
        if (!level.field_9236) {
            level.method_39279(pos, (class_2248)this, this.getReactToFireDelay());
        }
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean moving) {
        super.method_9615(state, world, pos, oldState, moving);
        if (!oldState.method_27852(state.method_26204()) && !world.field_9236) {
            world.method_39279(pos, (class_2248)this, this.getReactToFireDelay());
        }
    }

    private int getReactToFireDelay() {
        return 2;
    }

    private int getFireTickDelay(class_5819 random) {
        return 30 + random.method_43048(10);
    }

    public class_1269 method_9534(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit) {
        return this.interactWithPlayer(state, worldIn, pos, player, handIn);
    }

    public boolean lightUp(@Nullable class_1297 player, class_2680 state, class_2338 pos, class_1936 world, ILightable.FireSourceType fireSourceType) {
        if ((Integer)state.method_11654((class_2769)LEVEL) < 10 || world.method_8316(pos.method_10084()).method_15772().method_15780(state.method_26227().method_15772())) {
            return false;
        }
        return super.lightUp(player, state, pos, world, fireSourceType);
    }

    public boolean isLitUp(class_2680 state, class_1922 level, class_2338 pos) {
        return FlammableLiquidBlock.isOnFire(state);
    }

    public static boolean isOnFire(class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) > 0;
    }

    public void setLitUp(class_2680 state, class_1936 world, class_2338 pos, boolean lit) {
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(lit ? 1 : 0)), 3);
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return class_259.method_1073();
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return FlammableLiquidBlock.isOnFire(state) ? this.interactionShapes[(Integer)state.method_11654((class_2769)LEVEL)] : super.method_9530(state, level, pos, context);
    }

    public class_265 method_9584(class_2680 state, class_1922 level, class_2338 pos) {
        return this.interactionShapes[(Integer)state.method_11654((class_2769)LEVEL)];
    }

    public void method_19286(class_1937 level, class_2680 state, class_3965 pHit, class_1676 projectile) {
        class_2338 pos = pHit.method_17777();
        this.interactWithProjectile(level, state, projectile, pos);
    }

    public class_2680 method_9605(class_1750 context) {
        class_2680 state = this.method_9564();
        class_2338 pos = context.method_8037();
        class_1937 level = context.method_8045();
        boolean shouldBeOnFire = false;
        for (class_2350 direction : context.method_7718()) {
            if (!GunpowderBlock.isFireSource((class_1936)level, pos.method_10093(direction))) continue;
            shouldBeOnFire = true;
            break;
        }
        return (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(shouldBeOnFire ? 1 : 0));
    }

    @Override
    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        if (!FlammableLiquidBlock.isOnFire(state)) {
            return;
        }
        if (random.method_43048(24) == 0) {
            level.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_14993, class_3419.field_15245, 1.0f + random.method_43057(), random.method_43057() * 0.7f + 0.3f, false);
        }
        for (int i = 0; i < 3; ++i) {
            double d = (double)pos.method_10263() + random.method_43058();
            double e = (double)pos.method_10264() + random.method_43058() * 0.5 + 0.5;
            double f = (double)pos.method_10260() + random.method_43058();
            level.method_8406((class_2394)class_2398.field_11251, d, e, f, 0.0, 0.0, 0.0);
        }
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        if (entity instanceof class_1676) {
            class_1676 projectile = (class_1676)entity;
            this.interactWithProjectile(level, state, projectile, pos);
        }
        if (FlammableLiquidBlock.isOnFire(state)) {
            if (!entity.method_5753()) {
                entity.method_20803(entity.method_20802() + 1);
                if (entity.method_20802() == 0) {
                    entity.method_5639(8);
                }
            }
            entity.method_5643(level.method_48963().method_48794(), 1.0f);
        }
        super.method_9548(state, level, pos, entity);
    }

    protected void method_33614(class_1937 level, class_1657 player, class_2338 pos, class_2680 state) {
    }

    public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        if (!level.method_8608() && FlammableLiquidBlock.isOnFire(state)) {
            level.method_8444(null, 1009, pos, 0);
        }
        super.method_9576(level, pos, state, player);
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        level.method_39279(pos, (class_2248)this, this.getFireTickDelay(level.field_9229));
        if (level.method_8450().method_8355(class_1928.field_19387) && FlammableLiquidBlock.isOnFire(state)) {
            boolean burnout;
            int age = (Integer)state.method_11654((class_2769)AGE);
            int layers = (Integer)state.method_11654((class_2769)LEVEL);
            int ageAdd = random.method_43048(3) / 2;
            int ageIncrease = Math.min(15, age + ageAdd);
            if (age != ageIncrease) {
                state = (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(ageIncrease));
                level.method_8652(pos, state, 4);
            }
            int k = (burnout = level.method_23753(pos).method_40220(class_6908.field_41752)) ? -50 : 0;
            class_2338.class_2339 class_23392 = new class_2338.class_2339();
        }
    }

    @Override
    public void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        super.method_9514(state, level, pos, random);
        if (FlammableLiquidBlock.isOnFire(state)) {
            class_2246.field_10164.method_9514(class_2246.field_10164.method_9564(), level, pos, random);
        }
    }

    @Override
    public boolean method_9542(class_2680 state) {
        return true;
    }
}

