/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed.common;

import java.util.List;
import java.util.Random;
import net.konwboy.tumbleweed.common.Spawner;
import net.konwboy.tumbleweed.services.Services;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_52;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class EntityTumbleweed
extends class_1297 {
    public static final int FADE_TIME = 80;
    private static final int DESPAWN_RANGE = 160;
    private static final float BASE_SIZE = 0.75f;
    private static final double WIND_X = -0.0625;
    private static final double WIND_Z = -0.0625;
    private static final class_2940<Integer> SIZE = class_2945.method_12791(EntityTumbleweed.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> CUSTOM_WIND_ENABLED = class_2945.method_12791(EntityTumbleweed.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> CUSTOM_WIND_X = class_2945.method_12791(EntityTumbleweed.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> CUSTOM_WIND_Z = class_2945.method_12791(EntityTumbleweed.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> FADING = class_2945.method_12791(EntityTumbleweed.class, (class_2941)class_2943.field_13323);
    private int age;
    public int fadeProgress;
    public boolean persistent;
    private double windMod;
    private int lifetime;
    private float angularX;
    private float angularZ;
    public float stretch = 1.0f;
    public float prevStretch = 1.0f;
    private boolean prevVerticalCol;
    private class_243 prevMotion = class_243.field_1353;
    private int despawnCounter;
    public float rotOffsetX;
    public float rotOffsetY;
    public float rotOffsetZ;
    public Quaternionf quat;
    public Quaternionf prevQuat;

    public EntityTumbleweed(class_1299<?> type, class_1937 world) {
        super(type, world);
        this.field_23807 = true;
        this.method_5838(this.method_5628());
        if (this.method_37908().field_9236) {
            this.initClient();
        }
    }

    private void initClient() {
        this.rotOffsetX = 360.0f * this.method_37908().field_9229.method_43057();
        this.rotOffsetY = 360.0f * this.method_37908().field_9229.method_43057();
        this.rotOffsetZ = 360.0f * this.method_37908().field_9229.method_43057();
        this.quat = new Quaternionf();
        this.prevQuat = new Quaternionf();
    }

    protected void method_5693() {
        this.field_6011.method_12784(SIZE, (Object)2);
        this.field_6011.method_12784(CUSTOM_WIND_ENABLED, (Object)false);
        this.field_6011.method_12784(CUSTOM_WIND_X, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(CUSTOM_WIND_Z, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(FADING, (Object)false);
        this.method_18382();
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10569("Size", this.getSize());
        nbt.method_10556("CustomWindEnabled", this.getCustomWindEnabled());
        nbt.method_10549("CustomWindX", this.getCustomWindX());
        nbt.method_10549("CustomWindZ", this.getCustomWindZ());
        nbt.method_10556("Persistent", this.persistent);
        class_238 bb = this.method_5829();
        nbt.method_10566("AABB", (class_2520)this.method_5846(new double[]{bb.field_1323, bb.field_1322, bb.field_1321, bb.field_1320, bb.field_1325, bb.field_1324}));
    }

    protected void method_5749(class_2487 nbt) {
        if (nbt.method_10545("Size")) {
            this.field_6011.method_12778(SIZE, (Object)nbt.method_10550("Size"));
        }
        this.field_6011.method_12778(CUSTOM_WIND_ENABLED, (Object)nbt.method_10577("CustomWindEnabled"));
        this.field_6011.method_12778(CUSTOM_WIND_X, (Object)Float.valueOf(nbt.method_10583("CustomWindX")));
        this.field_6011.method_12778(CUSTOM_WIND_Z, (Object)Float.valueOf(nbt.method_10583("CustomWindZ")));
        this.persistent = nbt.method_10577("Persistent");
        if (nbt.method_10545("AABB")) {
            class_2499 aabb = nbt.method_10554("AABB", 6);
            this.method_5857(new class_238(aabb.method_10611(0), aabb.method_10611(1), aabb.method_10611(2), aabb.method_10611(3), aabb.method_10611(4), aabb.method_10611(5)));
        }
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (key.equals(SIZE)) {
            this.method_18382();
        }
    }

    public class_4048 method_18377(class_4050 pose) {
        float mcSize = 0.75f + (float)this.getSize() * 0.125f;
        return class_4048.method_18384((float)(this.method_37908().field_9236 ? mcSize - 9.765625E-4f : mcSize), (float)mcSize);
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_5810() {
        return true;
    }

    public void method_5838(int id) {
        super.method_5838(id);
        Random rand = new Random(id);
        this.windMod = 1.05 - 0.1 * rand.nextDouble();
        this.lifetime = 2400 + rand.nextInt(200);
    }

    public void method_5773() {
        double windZ;
        super.method_5773();
        if (this.method_37908().field_9236) {
            this.preTickClient();
        }
        if (this.method_5854() != null) {
            this.method_18799(class_243.field_1353);
            return;
        }
        if (!this.method_5799()) {
            this.method_18799(this.method_18798().method_1023(0.0, 0.012, 0.0));
        }
        this.prevMotion = this.method_18798();
        this.method_5784(class_1313.field_6308, this.method_18798());
        double windX = this.getCustomWindEnabled() ? this.getCustomWindX() : -0.0625 * this.windMod;
        double d = windZ = this.getCustomWindEnabled() ? this.getCustomWindZ() : -0.0625 * this.windMod;
        if (this.method_5799()) {
            this.method_18799(this.method_18798().method_18805(0.95, 1.0, 0.95));
            this.method_18799(this.method_18798().method_1031(0.0, 0.02, 0.0));
            windZ = 0.0;
            windX = 0.0;
        } else if (windX != 0.0 || windZ != 0.0) {
            this.method_18800(windX, this.method_18798().field_1351, windZ);
        }
        if (this.method_37908().field_9236) {
            this.tickClient();
        }
        if (this.method_24828()) {
            if (windX * windX + windZ * windZ >= 0.0025000000000000005) {
                this.method_18800(this.method_18798().field_1352, Math.max(-this.prevMotion.field_1351 * 0.7, 0.24 - (double)Math.abs(this.getSize()) * 0.02), this.method_18798().field_1350);
            } else {
                this.method_18800(this.method_18798().field_1352, -this.prevMotion.field_1351 * 0.7, this.method_18798().field_1350);
            }
        }
        this.method_18799(this.method_18798().method_18805(0.98, 0.98, 0.98));
        this.collideWithNearbyEntities();
        if (!this.method_37908().field_9236) {
            this.age += this.field_5976 || this.method_5799() ? 8 : 1;
            if (this.age > this.lifetime && this.fadeProgress == 0) {
                this.field_6011.method_12778(FADING, (Object)true);
            }
            this.tryDespawn();
        }
        if (this.isFading()) {
            ++this.fadeProgress;
            if (this.fadeProgress > 80) {
                this.method_5650(class_1297.class_5529.field_26999);
            }
        }
    }

    private void preTickClient() {
        this.prevStretch = this.stretch;
        this.stretch *= 1.2f;
        if (this.stretch > 1.0f) {
            this.stretch = 1.0f;
        }
        this.prevQuat = new Quaternionf((Quaternionfc)this.quat);
    }

    private void tickClient() {
        if (!this.prevVerticalCol && this.field_5992) {
            this.stretch *= 0.7f;
        }
        this.prevVerticalCol = this.field_5992;
        float motionAngleX = (float)this.prevMotion.field_1350 / (this.method_17681() * 0.5f);
        float motionAngleZ = (float)(-this.prevMotion.field_1352) / (this.method_17681() * 0.5f);
        if (this.method_24828()) {
            this.angularX = motionAngleX;
            this.angularZ = motionAngleZ;
        }
        if (this.method_5799()) {
            this.angularX += motionAngleX * 0.2f;
            this.angularZ += motionAngleZ * 0.2f;
        }
        float resistance = this.method_5799() ? 0.9f : 0.96f;
        this.angularX *= resistance;
        this.angularZ *= resistance;
        Quaternionf temp = new Quaternionf();
        temp.rotateXYZ(this.angularX, 0.0f, this.angularZ);
        temp.mul((Quaternionfc)this.quat);
        this.quat = temp;
    }

    private void tryDespawn() {
        if (this.shouldPersist()) {
            this.age = 0;
            return;
        }
        class_1657 player = this.method_37908().method_18460((class_1297)this, -1.0);
        if (player != null && player.method_5858((class_1297)this) > 25600.0) {
            this.method_5650(class_1297.class_5529.field_27001);
        }
    }

    public boolean shouldPersist() {
        return this.persistent || this.method_5854() != null;
    }

    public void tickDespawnNonEntityProcessing() {
        this.despawnCounter = !this.shouldPersist() && this.field_6012 > 0 && Spawner.isNonEntityProcessing((class_3218)this.method_37908(), this.method_24515()) ? ++this.despawnCounter : 0;
        if (this.despawnCounter > 20) {
            this.method_31472();
        }
    }

    public boolean method_5640(double distance) {
        return distance < 16384.0;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() == class_1802.field_8448 && stack.method_7938()) {
            if (!this.method_37908().field_9236) {
                this.method_5665(stack.method_7964());
                this.persistent = true;
                stack.method_7934(1);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return class_1269.field_5811;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (this.method_5805() && !this.method_37908().field_9236) {
            this.method_5650(class_1297.class_5529.field_26998);
            class_2498 sound = class_2498.field_11535;
            this.method_5783(sound.method_10595(), (sound.method_10597() + 1.0f) / 2.0f, sound.method_10599() * 0.8f);
            class_1297 killer = source.method_5529();
            if (killer instanceof class_1657) {
                ((class_1657)killer).method_7259(class_3468.field_15403.method_14956((Object)this.method_5864()));
            }
            if (Services.CONFIG.enableDrops() && (killer instanceof class_1657 || !Services.CONFIG.dropOnlyByPlayer())) {
                this.dropFromLootTable(source);
            }
        }
        return true;
    }

    @Nullable
    public class_1542 method_5699(class_1799 itemStack, float yOffset) {
        class_1542 item = super.method_5699(itemStack, yOffset);
        if (item == null) {
            return null;
        }
        item.method_18800(0.0, 0.2, 0.0);
        return item;
    }

    protected void dropFromLootTable(class_1282 damageSource) {
        class_52 loottable = this.method_37908().method_8503().method_3857().getLootTable(this.method_5864().method_16351());
        loottable.method_51878(this.createLootContext(damageSource)).forEach(arg_0 -> ((EntityTumbleweed)this).method_5775(arg_0));
    }

    protected class_8567 createLootContext(class_1282 damageSource) {
        return new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1231, (Object)damageSource).method_51877(class_181.field_1230, (Object)damageSource.method_5529()).method_51877(class_181.field_1227, (Object)damageSource.method_5526()).method_51875(class_173.field_1173);
    }

    public boolean method_5698(class_1297 entityIn) {
        return entityIn instanceof class_1657 && this.method_5643(this.method_48923().method_48802((class_1657)entityIn), 0.0f);
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
        this.method_5783(class_3417.field_14573, 0.15f, 1.0f);
    }

    public boolean canTumbleweedTrample(class_2680 state, class_2338 pos, float fallDistance) {
        return this.method_37908().field_9229.method_43057() < 0.7f && this.method_37908().method_8450().method_8355(class_1928.field_19388) && Services.CONFIG.damageCrops();
    }

    protected boolean method_5638() {
        return false;
    }

    private void collideWithNearbyEntities() {
        List list = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1012(0.2, 0.0, 0.2), class_1297::method_5810);
        for (class_1297 entity : list) {
            if (!this.method_37908().field_9236 && entity instanceof class_1688 && ((class_1688)entity).method_7518() == class_1688.class_1689.field_7674 && entity.method_18798().field_1352 * entity.method_18798().field_1352 + entity.method_18798().field_1350 * entity.method_18798().field_1350 > 0.01 && entity.method_5685().isEmpty() && this.method_5854() == null) {
                this.method_5804(entity);
                this.method_18799(this.method_18798().method_1031(0.0, 0.25, 0.0));
                this.field_6037 = true;
            }
            entity.method_5697((class_1297)this);
        }
    }

    public boolean isNotColliding() {
        return this.method_37908().method_8606((class_1297)this) && this.noBlockCollision() && !this.method_37908().method_22345(this.method_5829());
    }

    private boolean noBlockCollision() {
        for (class_265 voxelshape : this.method_37908().method_20812((class_1297)this, this.method_5829())) {
            if (voxelshape.method_1110()) continue;
            return false;
        }
        return true;
    }

    public void setSize(int size) {
        this.field_6011.method_12778(SIZE, (Object)size);
    }

    public int getSize() {
        return (Integer)this.field_6011.method_12789(SIZE);
    }

    public double getCustomWindX() {
        return ((Float)this.field_6011.method_12789(CUSTOM_WIND_X)).floatValue();
    }

    public double getCustomWindZ() {
        return ((Float)this.field_6011.method_12789(CUSTOM_WIND_Z)).floatValue();
    }

    public boolean getCustomWindEnabled() {
        return (Boolean)this.field_6011.method_12789(CUSTOM_WIND_ENABLED);
    }

    public boolean isFading() {
        return (Boolean)this.field_6011.method_12789(FADING);
    }

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this);
    }
}

