/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.fluid;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.IdentityHashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.core.fluid.fabric.SoftFluidInternalImpl;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundFinalizeFluidsMessage;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SoftFluidInternal {
    public static final Map<class_3611, class_6880<SoftFluid>> FLUID_MAP = new IdentityHashMap<class_3611, class_6880<SoftFluid>>();
    public static final Map<class_1792, class_6880<SoftFluid>> ITEM_MAP = new IdentityHashMap<class_1792, class_6880<SoftFluid>>();

    private static void populateSlaveMaps() {
        FLUID_MAP.clear();
        ITEM_MAP.clear();
        for (class_6880.class_6883<SoftFluid> h : SoftFluidRegistry.getHolders()) {
            SoftFluid s = (SoftFluid)h.comp_349();
            if (!s.isEnabled()) continue;
            s.getEquivalentFluids().forEach(f -> FLUID_MAP.put((class_3611)f, (class_6880<SoftFluid>)h));
            s.getContainerList().getPossibleFilled().forEach(i -> {
                if (i != class_1802.field_8574 || s != BuiltInSoftFluids.WATER.get()) {
                    ITEM_MAP.put((class_1792)i, (class_6880<SoftFluid>)h);
                }
            });
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        SoftFluidInternalImpl.init();
    }

    public static void postInitClient() {
        SoftFluidInternal.populateSlaveMaps();
        SoftFluidColors.refreshParticleColors();
    }

    public static void onDataSyncToPlayer(class_3222 player, boolean isJoined) {
        if (isJoined) {
            ModMessages.CHANNEL.sendToClientPlayer(player, new ClientBoundFinalizeFluidsMessage());
        }
    }

    public static void doPostInitServer() {
        SoftFluidInternal.populateSlaveMaps();
        SoftFluidInternal.registerExistingVanillaFluids(FLUID_MAP, ITEM_MAP);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerExistingVanillaFluids(Map<class_3611, class_6880<SoftFluid>> fluidMap, Map<class_1792, class_6880<SoftFluid>> itemMap) {
        void var1_1;
        SoftFluidInternalImpl.registerExistingVanillaFluids(fluidMap, (Map<class_1792, class_6880<SoftFluid>>)var1_1);
    }
}

