/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.overworld_mirror.portal;

import info.u_team.overworld_mirror.block.OverworldMirrorPortalBlock;
import info.u_team.overworld_mirror.config.CommonConfig;
import info.u_team.overworld_mirror.init.OverworldMirrorBlocks;
import info.u_team.overworld_mirror.portal.PortalLevelSavedData;
import info.u_team.u_team_core.util.LevelUtil;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2356;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2784;
import net.minecraft.class_2874;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3324;
import net.minecraft.class_5454;

public class PortalManager {
    public static boolean trySpawnPortalFromFrame(class_3218 level, class_2338 pos) {
        int northCount;
        int westCount;
        for (westCount = 0; level.method_8320(pos.method_10088(westCount + 1)).method_26204() != class_2246.field_10056 && westCount < 3; ++westCount) {
        }
        class_2338 westPost = pos.method_10088(westCount);
        for (northCount = 0; level.method_8320(westPost.method_10076(northCount + 1)).method_26204() != class_2246.field_10056 && northCount < 3; ++northCount) {
        }
        class_2338 westNorthPos = westPost.method_10076(northCount);
        class_2338 middlePos = westNorthPos.method_10078().method_10072();
        if (!PortalManager.validatePortalFrameAndSpawnPortal((class_1937)level, middlePos)) {
            return false;
        }
        PortalLevelSavedData data = PortalManager.getSavedData(level);
        data.getPortals().add(middlePos);
        data.method_80();
        return true;
    }

    private static boolean validatePortalFrameAndSpawnPortal(class_1937 level, class_2338 pos) {
        int i;
        ArrayList<class_2338> flowers = new ArrayList<class_2338>();
        ArrayList<class_2338> frame = new ArrayList<class_2338>();
        for (i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                flowers.add(pos.method_10069(i, 0, j));
            }
        }
        for (i = -1; i <= 1; ++i) {
            frame.add(pos.method_10069(2, 0, i));
            frame.add(pos.method_10069(-2, 0, i));
            frame.add(pos.method_10069(i, 0, 2));
            frame.add(pos.method_10069(i, 0, -2));
        }
        boolean flowersMatching = flowers.stream().allMatch(flowerPos -> level.method_8320(flowerPos).method_26204() instanceof class_2356);
        boolean frameMatching = frame.stream().allMatch(framePos -> level.method_8320(framePos).method_26204() == class_2246.field_10056);
        if (flowersMatching && frameMatching) {
            flowers.forEach(portalPos -> level.method_8652(portalPos, ((OverworldMirrorPortalBlock)((Object)((Object)OverworldMirrorBlocks.PORTAL.get()))).method_9564(), 2));
            class_3324 playerlist = level.method_8503().method_3760();
            flowers.forEach(portalPos -> playerlist.method_14605(null, (double)portalPos.method_10263(), (double)portalPos.method_10264(), (double)portalPos.method_10260(), 64.0, level.method_27983(), (class_2596)new class_2626((class_1922)level, portalPos)));
            return true;
        }
        return false;
    }

    public static class_5454 findOrCreatePortal(class_3218 destinationLevel, class_1297 entity) {
        class_2784 border = destinationLevel.method_8621();
        double coordinateScale = class_2874.method_31109((class_2874)entity.method_5770().method_8597(), (class_2874)destinationLevel.method_8597());
        class_2338 estimatedPos = border.method_39538(entity.method_23317() * coordinateScale, entity.method_23318(), entity.method_23321() * coordinateScale);
        PortalLevelSavedData data = PortalManager.getSavedData(destinationLevel);
        CommonConfig config = CommonConfig.getInstance();
        double searchDistance = Math.pow(destinationLevel.method_27983() == class_1937.field_25179 ? (Double)config.portalSearchDistanceOverworld().get() : (Double)config.portalSearchDistanceOverworldMirror().get(), 2.0);
        class_2338 portalMiddlePos = null;
        Iterator<class_2338> iterator = data.getPortals().iterator();
        while (iterator.hasNext()) {
            class_2338 pos = iterator.next();
            if (!((double)PortalManager.getPlaneDistanceSq(pos.method_10263(), pos.method_10260(), estimatedPos.method_10263(), estimatedPos.method_10260()) < searchDistance)) continue;
            if (PortalManager.validatePortal((class_1937)destinationLevel, pos)) {
                portalMiddlePos = pos;
                break;
            }
            iterator.remove();
            data.method_80();
        }
        if (portalMiddlePos == null) {
            portalMiddlePos = PortalManager.spawnPortal((class_1937)destinationLevel, estimatedPos);
            data.getPortals().add(portalMiddlePos);
            data.method_80();
        }
        return new class_5454(class_243.method_26410((class_2382)portalMiddlePos, (double)0.25), entity.method_18798(), entity.method_36454(), entity.method_36455());
    }

    private static boolean validatePortal(class_1937 level, class_2338 pos) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (level.method_8320(pos.method_10069(i, 0, j)).method_26204() == OverworldMirrorBlocks.PORTAL.get()) continue;
                return false;
            }
        }
        return true;
    }

    private static class_2338 spawnPortal(class_1937 level, class_2338 entityPos) {
        int i;
        level.method_22350(entityPos);
        class_2338 pos = level.method_8598(class_2902.class_2903.field_13202, entityPos).method_10074();
        ArrayList<class_2338> portal = new ArrayList<class_2338>();
        ArrayList<class_2338> frame = new ArrayList<class_2338>();
        for (i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                portal.add(pos.method_10069(i, 0, j));
            }
        }
        for (i = -2; i <= 2; ++i) {
            frame.add(pos.method_10069(2, 0, i));
            frame.add(pos.method_10069(-2, 0, i));
            frame.add(pos.method_10069(i, 0, 2));
            frame.add(pos.method_10069(i, 0, -2));
        }
        frame.forEach(framePos -> {
            level.method_8501(framePos, class_2246.field_10056.method_9564());
            level.method_8650(framePos.method_10084(), false);
            level.method_8650(framePos.method_10086(2), false);
        });
        portal.forEach(portalPos -> {
            level.method_8650(portalPos.method_10084(), false);
            level.method_8650(portalPos.method_10086(2), false);
            level.method_8501(portalPos.method_10074(), class_2246.field_10056.method_9564());
        });
        portal.forEach(portalPos -> level.method_8652(portalPos, ((OverworldMirrorPortalBlock)((Object)((Object)OverworldMirrorBlocks.PORTAL.get()))).method_9564(), 2));
        return pos;
    }

    public static PortalLevelSavedData getSavedData(class_3218 level) {
        String name = "overworldmirror_portal";
        return (PortalLevelSavedData)LevelUtil.getSaveData((class_3218)level, (String)"overworldmirror_portal", PortalLevelSavedData::load, PortalLevelSavedData::new);
    }

    public static float getPlaneDistanceSq(int x1, int z1, int x2, int z2) {
        int xDiff = x2 - x1;
        int zDiff = z2 - z1;
        return xDiff * xDiff + zDiff * zDiff;
    }
}

