/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.overworld_mirror.config;

import info.u_team.overworld_mirror.config.CommonConfig;
import info.u_team.u_team_core.UCoreReference;
import info.u_team.u_team_core.util.ConfigValueHolder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_3532;

public class FabricCommonConfig {
    private static final FabricCommonConfig INSTANCE = new FabricCommonConfig();
    public final ConfigValueHolder<Double> portalSearchDistanceOverworld;
    public final ConfigValueHolder<Double> portalSearchDistanceOverworldMirror;
    private final Path path = FabricLoader.getInstance().getConfigDir().resolve("overworldmirror.properties");
    private final Properties properties = new Properties();

    public static FabricCommonConfig getInstance() {
        return INSTANCE;
    }

    private FabricCommonConfig() {
        if (Files.exists(this.path, new LinkOption[0])) {
            this.load();
        }
        this.properties.computeIfAbsent("portalSearchDistanceOverworld", (Function<? super Object, ?>)((Function<Object, Object>)unused -> "30"));
        this.properties.computeIfAbsent("portalSearchDistanceOverworldMirror", (Function<? super Object, ?>)((Function<Object, Object>)unused -> "30"));
        this.portalSearchDistanceOverworld = new ConfigValueHolder(() -> class_3532.method_15350((double)Double.valueOf(this.properties.getProperty("portalSearchDistanceOverworld", "30")), (double)1.0, (double)1.0E10), value -> {
            this.properties.put("portalSearchDistanceOverworld", value.toString());
            class_156.method_27958().submit(this::save);
        });
        this.portalSearchDistanceOverworldMirror = new ConfigValueHolder(() -> class_3532.method_15350((double)Double.valueOf(this.properties.getProperty("portalSearchDistanceOverworldMirror", "30")), (double)1.0, (double)1.0E10), value -> {
            this.properties.put("portalSearchDistanceOverworldMirror", value.toString());
            class_156.method_27958().submit(this::save);
        });
        if (!Files.exists(this.path, new LinkOption[0])) {
            this.save();
        }
    }

    private void load() {
        try (BufferedReader reader = Files.newBufferedReader(this.path, StandardCharsets.UTF_8);){
            this.properties.load(reader);
        }
        catch (IOException ex) {
            UCoreReference.LOGGER.warn("Could not read property file '" + this.path.toAbsolutePath() + "'", (Throwable)ex);
        }
    }

    private void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.path, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.properties.store(writer, "Configuration file for Overworld Mirror mod");
        }
        catch (IOException ex) {
            UCoreReference.LOGGER.warn("Could not read property file '" + this.path.toAbsolutePath() + "'", (Throwable)ex);
        }
    }

    public static class Impl
    extends CommonConfig {
        @Override
        public ConfigValueHolder<Double> portalSearchDistanceOverworld() {
            return FabricCommonConfig.INSTANCE.portalSearchDistanceOverworld;
        }

        @Override
        public ConfigValueHolder<Double> portalSearchDistanceOverworldMirror() {
            return FabricCommonConfig.INSTANCE.portalSearchDistanceOverworldMirror;
        }
    }
}

